/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import java.util.function.IntConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;

@ParametersAreNonnullByDefault
public class TextBoxInt
extends class_342 {
    private final int defaultValue;
    private final int min;
    private final int max;
    private IntConsumer valueChangedCallback;

    public TextBoxInt(int defaultValue, int min, int max, class_327 font, int width) {
        super(font, 0, 0, width, 12, (class_2561)class_2561.method_43473());
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.setValue(defaultValue);
    }

    public void setValueChangedCallback(IntConsumer callback) {
        this.valueChangedCallback = callback;
    }

    public void method_53533(int height) {
        this.field_22759 = height;
    }

    public void method_1867(String textToWrite) {
        if (textToWrite.equals("-") && this.method_1881() == 0) {
            super.method_1867(textToWrite);
            return;
        }
        String currentString = this.method_1882();
        super.method_1867(textToWrite);
        try {
            int current = Integer.parseInt(this.method_1882());
            this.setValue(current);
        }
        catch (Exception e) {
            this.method_1852(currentString);
        }
    }

    public void setValue(Object object) {
        this.method_1852(object.toString());
        if (this.valueChangedCallback != null) {
            try {
                int current = Integer.parseInt(this.method_1882());
                this.valueChangedCallback.accept(current);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean method_25400(char c, int key) {
        boolean res = false;
        if (this.method_25367() && (res = super.method_25400(c, key))) {
            int current;
            try {
                current = Integer.parseInt(this.method_1882());
                if (current > this.max) {
                    this.setValue(this.max);
                    current = this.max;
                }
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
            finally {
                this.method_1870(false);
                this.method_1872(false);
            }
            if (this.valueChangedCallback != null) {
                this.valueChangedCallback.accept(Math.max(current, this.min));
            }
        }
        return res;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean res = false;
        if (this.method_25367()) {
            res = super.method_25404(keyCode, scanCode, modifiers);
            if (this.valueChangedCallback != null && (keyCode == 259 || keyCode == 261)) {
                this.valueChangedCallback.accept(this.clamped());
            }
            if (keyCode == 257 || keyCode == 335) {
                this.method_25365(false);
            }
        }
        return res;
    }

    public boolean method_25401(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.field_22764 && this.field_22762) {
            int current;
            try {
                current = Integer.parseInt(this.method_1882());
            }
            catch (Exception e) {
                current = this.defaultValue;
            }
            if (vDelta > 0.0 && current < this.max) {
                this.method_25354(class_310.method_1551().method_1483());
                this.setValue(++current);
            } else if (vDelta < 0.0 && current > this.min) {
                this.method_25354(class_310.method_1551().method_1483());
                this.setValue(--current);
            }
            return true;
        }
        return false;
    }

    public int clamped() {
        int current;
        String text = this.method_1882();
        if (text.isEmpty()) {
            return this.defaultValue;
        }
        try {
            current = Integer.parseInt(text);
        }
        catch (Exception e) {
            return this.defaultValue;
        }
        current = Math.max(this.min, current);
        current = Math.min(this.max, current);
        return current;
    }

    public void method_25365(boolean isFocusedIn) {
        if (!isFocusedIn) {
            this.setValue(this.clamped());
        }
        super.method_25365(isFocusedIn);
    }
}

