/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import java.util.function.IntConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class TextBoxInt
extends EditBox {
    private final int defaultValue;
    private final int min;
    private final int max;
    private IntConsumer valueChangedCallback;

    public TextBoxInt(int defaultValue, int min, int max, Font font, int width) {
        super(font, 0, 0, width, 12, (Component)Component.empty());
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.setValue(defaultValue);
    }

    public void setValueChangedCallback(IntConsumer callback) {
        this.valueChangedCallback = callback;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void insertText(String textToWrite) {
        if (textToWrite.equals("-") && this.getCursorPosition() == 0) {
            super.insertText(textToWrite);
            return;
        }
        String currentString = this.getValue();
        super.insertText(textToWrite);
        try {
            int current = Integer.parseInt(this.getValue());
            this.setValue(current);
        }
        catch (Exception e) {
            this.setValue(currentString);
        }
    }

    public void setValue(Object object) {
        this.setValue(object.toString());
        if (this.valueChangedCallback != null) {
            try {
                int current = Integer.parseInt(this.getValue());
                this.valueChangedCallback.accept(current);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean charTyped(CharacterEvent event) {
        boolean res = false;
        if (this.isHoveredOrFocused() && (res = super.charTyped(event))) {
            int current;
            try {
                current = Integer.parseInt(this.getValue());
                if (current > this.max) {
                    this.setValue(this.max);
                    current = this.max;
                }
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
            finally {
                this.moveCursorToStart(false);
                this.moveCursorToEnd(false);
            }
            if (this.valueChangedCallback != null) {
                this.valueChangedCallback.accept(Math.max(current, this.min));
            }
        }
        return res;
    }

    public boolean keyPressed(KeyEvent event) {
        boolean res = false;
        if (this.isHoveredOrFocused()) {
            res = super.keyPressed(event);
            if (this.valueChangedCallback != null && (event.input() == 259 || event.input() == 261)) {
                this.valueChangedCallback.accept(this.clamped());
            }
            if (event.input() == 257 || event.input() == 335) {
                this.setFocused(false);
            }
        }
        return res;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.visible && this.isHovered) {
            int current;
            try {
                current = Integer.parseInt(this.getValue());
            }
            catch (Exception e) {
                current = this.defaultValue;
            }
            if (vDelta > 0.0 && current < this.max) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.setValue(++current);
            } else if (vDelta < 0.0 && current > this.min) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.setValue(--current);
            }
            return true;
        }
        return false;
    }

    public int clamped() {
        int current;
        String text = this.getValue();
        if (text.isEmpty()) {
            return this.defaultValue;
        }
        try {
            current = Integer.parseInt(text);
        }
        catch (Exception e) {
            return this.defaultValue;
        }
        current = Math.max(this.min, current);
        current = Math.min(this.max, current);
        return current;
    }

    public void setFocused(boolean isFocusedIn) {
        if (!isFocusedIn) {
            this.setValue(this.clamped());
        }
        super.setFocused(isFocusedIn);
    }
}

