/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StringWidget
extends net.minecraft.client.gui.components.StringWidget {
    private float scale = 1.0f;
    private final Align align;

    public StringWidget(Component message, Font font) {
        this(message, font, 12, Align.Left);
    }

    public StringWidget(Component message, Font font, Align align) {
        this(message, font, 12, align);
    }

    public StringWidget(Component message, Font font, int height) {
        this(message, font, height, Align.Left);
    }

    public StringWidget(Component message, Font font, int height, Align align) {
        super(0, 0, font.width(message.getVisualOrderText()), height, message, font);
        this.align = align;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @NotNull
    public StringWidget setColor(int color) {
        super.setColor(color);
        return this;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.scale != 1.0f) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(this.scale, this.scale, 1.0f);
        }
        int x = Mth.floor((float)((float)this.getX() / this.scale));
        int y = Mth.floor((float)(((float)this.getY() + (float)(this.getHeight() - 10) / 2.0f) / this.scale));
        if (this.align == Align.Left) {
            guiGraphics.drawString(this.getFont(), this.getMessage(), x, y, this.getColor());
        } else if (this.align == Align.Center) {
            guiGraphics.drawString(this.getFont(), this.getMessage(), x - this.getFont().width((FormattedText)this.getMessage()) / 2, y, this.getColor());
        } else {
            guiGraphics.drawString(this.getFont(), this.getMessage(), x - this.getFont().width((FormattedText)this.getMessage()), y, this.getColor());
        }
        if (this.scale != 1.0f) {
            guiGraphics.pose().popPose();
        }
    }

    public static enum Align {
        Left,
        Center,
        Right;

    }
}

