/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common;

import com.mojang.serialization.DynamicOps;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class FrontierData {
    protected UUID id;
    protected final List<class_2338> vertices = new ArrayList<class_2338>();
    protected Set<class_1923> chunks = new HashSet<class_1923>();
    protected Mode mode = Mode.Vertex;
    protected String name1 = "New";
    protected String name2 = "Frontier";
    protected VisibilityData visibilityData;
    protected int color = -1;
    protected class_5321<class_1937> dimension;
    protected SettingsUser owner = new SettingsUser();
    protected BannerData banner;
    protected boolean personal = false;
    protected List<SettingsUserShared> usersShared;
    protected CopiedFrom copiedFrom;
    protected Date created;
    protected Date modified;
    protected Set<Change> changes = EnumSet.noneOf(Change.class);

    public FrontierData() {
        this.id = new UUID(0L, 0L);
        this.visibilityData = new VisibilityData();
    }

    public FrontierData(FrontierData other) {
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        this.visibilityData = new VisibilityData(other.visibilityData);
        this.color = other.color;
        this.name1 = other.name1;
        this.name2 = other.name2;
        this.banner = other.banner == null ? null : new BannerData(other.banner);
        this.usersShared = other.usersShared;
        this.vertices.clear();
        this.vertices.addAll(other.vertices);
        this.chunks.clear();
        this.chunks.addAll(other.chunks);
        this.mode = other.mode;
        this.copiedFrom = other.copiedFrom;
        this.created = other.created;
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void updateFromData(FrontierData other) {
        if (other == this) {
            this.changes = EnumSet.noneOf(Change.class);
            return;
        }
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        if (other.changes.contains((Object)Change.Visibility)) {
            this.visibilityData = other.visibilityData;
        }
        if (other.changes.contains((Object)Change.Color)) {
            this.color = other.color;
        }
        if (other.changes.contains((Object)Change.Name)) {
            this.name1 = other.name1;
            this.name2 = other.name2;
        }
        if (other.changes.contains((Object)Change.Banner)) {
            this.banner = other.banner == null ? null : new BannerData(other.banner);
        }
        if (other.changes.contains((Object)Change.Shared)) {
            this.usersShared = other.usersShared;
        }
        if (other.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            this.vertices.addAll(other.vertices);
            this.chunks.clear();
            this.chunks.addAll(other.chunks);
            this.mode = other.mode;
        }
        this.copiedFrom = other.copiedFrom;
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void setOwner(SettingsUser owner) {
        this.owner = owner;
    }

    public void ensureOwner(MinecraftServer server) {
        if (this.owner.isEmpty()) {
            List playerList;
            if (!server.method_3816() && !(playerList = server.method_3760().method_14571()).isEmpty()) {
                this.owner = new SettingsUser((class_1657)playerList.getFirst());
            }
        } else {
            this.owner.fillMissingInfo(false, server);
        }
    }

    public SettingsUser getOwner() {
        return this.owner;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addVertex(class_2338 pos, int index) {
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.vertices.add(index, pos.method_33096(70));
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVertex(class_2338 pos) {
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.addVertex(pos, this.vertices.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVertex(int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.vertices.remove(index);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveVertex(class_2338 pos, int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.vertices.set(index, pos);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAllVertices(class_2338 delta) {
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.vertices.replaceAll(blockPos -> blockPos.method_10081((class_2382)delta));
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleChunk(class_1923 chunk) {
        boolean added = false;
        Set<class_1923> set = this.chunks;
        synchronized (set) {
            if (!this.chunks.remove(chunk)) {
                this.chunks.add(chunk);
                added = true;
            }
        }
        this.changes.add(Change.Vertices);
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChunk(class_1923 chunk) {
        Set<class_1923> set = this.chunks;
        synchronized (set) {
            if (this.chunks.add(chunk)) {
                this.changes.add(Change.Vertices);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChunk(class_1923 chunk) {
        Set<class_1923> set = this.chunks;
        synchronized (set) {
            if (this.chunks.remove(chunk)) {
                this.changes.add(Change.Vertices);
                return true;
            }
        }
        return false;
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAllChunks(class_1923 delta) {
        Set<class_1923> set = this.chunks;
        synchronized (set) {
            this.chunks = this.chunks.stream().map(chunk -> new class_1923(chunk.field_9181 + delta.field_9181, chunk.field_9180 + delta.field_9180)).collect(Collectors.toSet());
        }
        this.changes.add(Change.Vertices);
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.changes.add(Change.Vertices);
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isEmpty() {
        if (this.mode == Mode.Vertex) {
            return this.vertices.isEmpty();
        }
        return this.chunks.isEmpty();
    }

    public void setName1(String name) {
        this.name1 = name;
        this.changes.add(Change.Name);
    }

    public String getName1() {
        return this.name1;
    }

    public void setName2(String name) {
        this.name2 = name;
        this.changes.add(Change.Name);
    }

    public String getName2() {
        return this.name2;
    }

    public boolean isNamed() {
        return !StringUtils.isBlank((CharSequence)this.name1) || !StringUtils.isBlank((CharSequence)this.name2);
    }

    public void setVisibility(VisibilityData.Visibility visibility, boolean enable) {
        this.visibilityData.setValue(visibility, enable);
        this.changes.add(Change.Visibility);
    }

    public void toggleVisibility(VisibilityData.Visibility visibility) {
        this.visibilityData.setValue(visibility, !this.visibilityData.getValue(visibility));
        this.changes.add(Change.Visibility);
    }

    public boolean getVisibility(VisibilityData.Visibility visibility) {
        return this.visibilityData.getValue(visibility);
    }

    public void setVisibilityData(VisibilityData visibilityData) {
        this.visibilityData = visibilityData;
        this.changes.add(Change.Visibility);
    }

    public VisibilityData getVisibilityData() {
        return this.visibilityData;
    }

    public void setColor(int color) {
        this.color = color;
        this.changes.add(Change.Color);
    }

    public int getColor() {
        return this.color;
    }

    public void setDimension(class_5321<class_1937> dimension) {
        this.dimension = dimension;
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public void setBanner(@Nullable class_1799 itemBanner) {
        this.changes.add(Change.Banner);
        this.banner = itemBanner == null ? null : new BannerData(itemBanner);
    }

    public void setBanner(class_1767 base, class_9307 bannerPatterns) {
        this.banner = new BannerData(base, bannerPatterns);
        this.changes.add(Change.Banner);
    }

    public boolean hasBanner() {
        return this.banner != null;
    }

    public void setBannerData(@Nullable BannerData bannerData) {
        this.changes.add(Change.Banner);
        this.banner = bannerData == null ? null : new BannerData(bannerData);
    }

    public BannerData getbannerData() {
        return this.banner;
    }

    public void setBannerRotation(int rotation) {
        this.changes.add(Change.Banner);
        this.banner.rotation = rotation;
    }

    public int getBannerRotation() {
        if (this.banner == null) {
            return 0;
        }
        return this.banner.rotation;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public boolean getPersonal() {
        return this.personal;
    }

    public void addUserShared(SettingsUserShared userShared) {
        if (this.usersShared == null) {
            this.usersShared = new ArrayList<SettingsUserShared>();
        }
        this.usersShared.add(userShared);
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(int index) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.remove(index);
        if (this.usersShared.isEmpty()) {
            this.usersShared = null;
        }
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(x -> x.getUser().equals(user));
        this.changes.add(Change.Shared);
    }

    public void removeAllUserShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared = null;
        this.changes.add(Change.Shared);
    }

    public void setUsersShared(List<SettingsUserShared> usersShared) {
        this.usersShared = usersShared;
        this.changes.add(Change.Shared);
    }

    public void removePendingUsersShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(SettingsUserShared::isPending);
        this.changes.add(Change.Shared);
    }

    public List<SettingsUserShared> getUsersShared() {
        return this.usersShared;
    }

    public SettingsUserShared getUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return null;
        }
        for (SettingsUserShared u : this.usersShared) {
            if (!u.getUser().equals(user)) continue;
            return u;
        }
        return null;
    }

    public boolean hasUserShared(SettingsUser user) {
        return this.getUserShared(user) != null;
    }

    public boolean checkActionUserShared(SettingsUser user, SettingsUserShared.Action action) {
        if (user.equals(this.owner)) {
            return true;
        }
        if (this.usersShared == null) {
            return false;
        }
        SettingsUserShared userShared = this.getUserShared(user);
        if (userShared == null) {
            return false;
        }
        return userShared.hasAction(action);
    }

    public void setCreated(Date created) {
        this.created = created;
        this.modified = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean wasCopied() {
        return this.copiedFrom != null;
    }

    public void removeCopiedFromInfo() {
        this.copiedFrom = null;
    }

    public void setCopiedFromId(UUID id) {
        if (!this.wasCopied()) {
            this.copiedFrom = new CopiedFrom();
        }
        this.copiedFrom.id = id;
    }

    public UUID getCopiedFromId() {
        if (this.copiedFrom == null) {
            return this.id;
        }
        return this.copiedFrom.id;
    }

    public void setCopiedFromUser(SettingsUser user) {
        if (!this.wasCopied()) {
            this.copiedFrom = new CopiedFrom();
        }
        this.copiedFrom.user = user;
    }

    public SettingsUser getCopiedFromUser() {
        if (this.copiedFrom == null) {
            return this.owner;
        }
        return this.copiedFrom.user;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getModified() {
        return this.modified;
    }

    public void addChange(Change change) {
        this.changes.add(change);
    }

    public void removeChange(Change change) {
        this.changes.remove((Object)change);
    }

    public void removeChanges() {
        this.changes.clear();
    }

    public boolean hasChange(Change change) {
        return this.changes.contains((Object)change);
    }

    public Set<Change> getChanges() {
        return EnumSet.copyOf(this.changes);
    }

    public void readFromNBT(class_2487 nbt, int version) {
        int i;
        class_2499 usersSharedTagList;
        this.id = UUID.fromString(nbt.method_10558("id"));
        this.color = nbt.method_10550("color");
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)nbt.method_10558("dimension")));
        this.name1 = nbt.method_10558("name1");
        this.name2 = nbt.method_10558("name2");
        this.visibilityData.readFromNBT(nbt, version);
        this.personal = nbt.method_10577("personal");
        this.owner = new SettingsUser();
        this.owner.readFromNBT(nbt.method_10562("owner"));
        if (nbt.method_10545("banner")) {
            this.banner = new BannerData();
            this.banner.readFromNBT(nbt.method_10562("banner"));
        }
        if (this.personal && !(usersSharedTagList = nbt.method_10554("usersShared", 10)).isEmpty()) {
            this.usersShared = new ArrayList<SettingsUserShared>();
            for (i = 0; i < usersSharedTagList.size(); ++i) {
                SettingsUserShared userShared = new SettingsUserShared();
                userShared.readFromNBT(usersSharedTagList.method_10602(i));
                this.usersShared.add(userShared);
            }
        }
        class_2499 verticesTagList = nbt.method_10554("vertices", 10);
        for (i = 0; i < verticesTagList.size(); ++i) {
            class_2487 posTag = verticesTagList.method_10602(i);
            this.vertices.add(new class_2338(posTag.method_10550("X"), 70, posTag.method_10550("Z")));
        }
        class_2499 chunksTagList = nbt.method_10554("chunks", 10);
        for (int i2 = 0; i2 < chunksTagList.size(); ++i2) {
            this.chunks.add(new class_1923(chunksTagList.method_10602(i2).method_10550("X"), chunksTagList.method_10602(i2).method_10550("Z")));
        }
        String modeTag = nbt.method_10558("mode");
        if (modeTag.isEmpty()) {
            this.mode = Mode.Vertex;
        } else {
            try {
                this.mode = Mode.valueOf(modeTag);
            }
            catch (IllegalArgumentException e) {
                this.mode = this.chunks.size() > 0 ? Mode.Chunk : Mode.Vertex;
                String availableModes = StringHelper.enumValuesToString(Arrays.asList(Mode.values()));
                MapFrontiers.LOGGER.warn(String.format("Unknown mode in frontier %1$s. Found: \"%2$s\". Expected: %3$s", this.id, modeTag, availableModes));
            }
        }
        if (nbt.method_10545("copiedFrom")) {
            this.copiedFrom = new CopiedFrom();
            this.copiedFrom.readFromNBT(nbt.method_10562("copiedFrom"), version);
        }
        if (nbt.method_10545("created")) {
            this.created = new Date(nbt.method_10537("created"));
        }
        if (nbt.method_10545("modified")) {
            this.modified = new Date(nbt.method_10537("modified"));
        }
    }

    public void writeToNBT(class_2487 nbt) {
        nbt.method_10582("id", this.id.toString());
        nbt.method_10569("color", this.color);
        nbt.method_10582("dimension", this.dimension.method_29177().toString());
        nbt.method_10582("name1", this.name1);
        nbt.method_10582("name2", this.name2);
        this.visibilityData.writeToNBT(nbt);
        nbt.method_10556("personal", this.personal);
        class_2487 nbtOwner = new class_2487();
        this.owner.writeToNBT(nbtOwner);
        nbt.method_10566("owner", (class_2520)nbtOwner);
        if (this.banner != null) {
            class_2487 nbtBanner = new class_2487();
            this.banner.writeToNBT(nbtBanner);
            nbt.method_10566("banner", (class_2520)nbtBanner);
        }
        if (this.personal && this.usersShared != null) {
            class_2499 usersSharedTagList = new class_2499();
            for (SettingsUserShared settingsUserShared : this.usersShared) {
                class_2487 nbtUserShared = new class_2487();
                settingsUserShared.writeToNBT(nbtUserShared);
                usersSharedTagList.add((Object)nbtUserShared);
            }
            nbt.method_10566("usersShared", (class_2520)usersSharedTagList);
        }
        class_2499 verticesTagList = new class_2499();
        for (class_2338 class_23382 : this.vertices) {
            class_2487 compoundtag = new class_2487();
            compoundtag.method_10569("X", class_23382.method_10263());
            compoundtag.method_10569("Y", class_23382.method_10264());
            compoundtag.method_10569("Z", class_23382.method_10260());
            verticesTagList.add((Object)compoundtag);
        }
        nbt.method_10566("vertices", (class_2520)verticesTagList);
        class_2499 chunksTagList = new class_2499();
        for (class_1923 pos : this.chunks) {
            class_2487 compoundtag = new class_2487();
            compoundtag.method_10569("X", pos.field_9181);
            compoundtag.method_10569("Z", pos.field_9180);
            chunksTagList.add((Object)compoundtag);
        }
        nbt.method_10566("chunks", (class_2520)chunksTagList);
        nbt.method_10582("mode", this.mode.name());
        if (this.wasCopied()) {
            class_2487 class_24872 = new class_2487();
            this.copiedFrom.writeToNBT(class_24872);
            nbt.method_10566("copiedFrom", (class_2520)class_24872);
        }
        if (this.created != null) {
            nbt.method_10544("created", this.created.getTime());
        }
        if (this.modified != null) {
            nbt.method_10544("modified", this.modified.getTime());
        }
    }

    public void fromBytes(class_2540 buf) {
        int i;
        this.changes.clear();
        for (Change change : Change.valuesArray) {
            if (!buf.readBoolean()) continue;
            this.changes.add(change);
        }
        this.id = UUIDHelper.fromBytes((ByteBuf)buf);
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buf.method_10810());
        this.personal = buf.readBoolean();
        this.owner = new SettingsUser();
        this.owner.fromBytes(buf);
        if (this.changes.contains((Object)Change.Visibility)) {
            this.visibilityData.fromBytes(buf);
        }
        if (this.changes.contains((Object)Change.Color)) {
            this.color = buf.readInt();
        }
        if (this.changes.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            this.name1 = buf.method_10800(maxBytes);
            this.name2 = buf.method_10800(maxBytes);
            if (this.name1.length() > maxCharacters) {
                this.name1 = this.name1.substring(0, maxCharacters);
            }
            if (this.name2.length() > maxCharacters) {
                this.name2 = this.name2.substring(0, maxCharacters);
            }
        }
        if (this.changes.contains((Object)Change.Banner)) {
            if (buf.readBoolean()) {
                this.banner = new BannerData();
                this.banner.fromBytes(buf);
            } else {
                this.banner = null;
            }
        }
        if (this.changes.contains((Object)Change.Shared)) {
            if (buf.readBoolean()) {
                this.usersShared = new ArrayList<SettingsUserShared>();
                int usersCount = buf.readInt();
                for (i = 0; i < usersCount; ++i) {
                    SettingsUserShared userShared = new SettingsUserShared();
                    userShared.fromBytes(buf);
                    this.usersShared.add(userShared);
                }
            } else {
                this.usersShared = null;
            }
        }
        if (this.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            int vertexCount = buf.readInt();
            for (i = 0; i < vertexCount; ++i) {
                class_2338 vertex = class_2338.method_10092((long)buf.readLong());
                this.vertices.add(vertex);
            }
            this.chunks.clear();
            int chunkCount = buf.readInt();
            for (int i2 = 0; i2 < chunkCount; ++i2) {
                class_1923 chunk = new class_1923(buf.readLong());
                this.chunks.add(chunk);
            }
            this.mode = Mode.values()[buf.readInt()];
        }
        if (buf.readBoolean()) {
            this.copiedFrom = new CopiedFrom();
            this.copiedFrom.fromBytes(buf);
        } else {
            this.copiedFrom = null;
        }
        this.created = buf.readBoolean() ? new Date(buf.readLong()) : null;
        this.modified = buf.readBoolean() ? new Date(buf.readLong()) : null;
    }

    public void toBytes(class_2540 buf) {
        this.toBytes(buf, true);
    }

    public void toBytes(class_2540 buf, boolean onlyChanges) {
        this.toBytes(buf, onlyChanges ? this.changes : null);
    }

    public void toBytes(class_2540 buf, @Nullable Set<Change> withChanges) {
        for (Change change : Change.valuesArray) {
            if (withChanges != null) {
                buf.method_52964(withChanges.contains((Object)change));
                continue;
            }
            buf.method_52964(true);
        }
        UUIDHelper.toBytes((ByteBuf)buf, this.id);
        buf.method_10812(this.dimension.method_29177());
        buf.method_52964(this.personal);
        this.owner.toBytes(buf);
        if (withChanges == null || withChanges.contains((Object)Change.Visibility)) {
            this.visibilityData.toBytes(buf);
        }
        if (withChanges == null || withChanges.contains((Object)Change.Color)) {
            buf.method_53002(this.color);
        }
        if (withChanges == null || withChanges.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            buf.method_10788(this.name1, maxBytes);
            buf.method_10788(this.name2, maxBytes);
        }
        if (withChanges == null || withChanges.contains((Object)Change.Banner)) {
            if (this.banner == null) {
                buf.method_52964(false);
            } else {
                buf.method_52964(true);
                this.banner.toBytes(buf);
            }
        }
        if (withChanges == null || withChanges.contains((Object)Change.Shared)) {
            if (this.personal && this.usersShared != null) {
                buf.method_52964(true);
                buf.method_53002(this.usersShared.size());
                for (SettingsUserShared userShared : this.usersShared) {
                    userShared.toBytes(buf);
                }
            } else {
                buf.method_52964(false);
            }
        }
        if (withChanges == null || withChanges.contains((Object)Change.Vertices)) {
            buf.method_53002(this.vertices.size());
            for (class_2338 pos : this.vertices) {
                buf.method_52974(pos.method_10063());
            }
            buf.method_53002(this.chunks.size());
            for (class_1923 pos : this.chunks) {
                buf.method_52974(pos.method_8324());
            }
            buf.method_53002(this.mode.ordinal());
        }
        if (this.wasCopied()) {
            buf.method_52964(true);
            this.copiedFrom.toBytes(buf);
        } else {
            buf.method_52964(false);
        }
        if (this.created == null) {
            buf.method_52964(false);
        } else {
            buf.method_52964(true);
            buf.method_52974(this.created.getTime());
        }
        if (this.modified == null) {
            buf.method_52964(false);
        } else {
            buf.method_52964(true);
            buf.method_52974(this.modified.getTime());
        }
    }

    public static enum Mode {
        Vertex,
        Chunk;

    }

    public static enum Change {
        Name,
        Vertices,
        Banner,
        Shared,
        Visibility,
        Color;

        public static final Change[] valuesArray;

        static {
            valuesArray = Change.values();
        }
    }

    public static class VisibilityData {
        private final EnumSet<Visibility> values;

        public VisibilityData() {
            this.values = EnumSet.of(Visibility.Frontier, new Visibility[]{Visibility.Fullscreen, Visibility.FullscreenName, Visibility.FullscreenDay, Visibility.FullscreenNight, Visibility.FullscreenUnderground, Visibility.FullscreenTopo, Visibility.FullscreenBiome, Visibility.Minimap, Visibility.MinimapName, Visibility.MinimapDay, Visibility.MinimapNight, Visibility.MinimapUnderground, Visibility.MinimapTopo, Visibility.MinimapBiome, Visibility.Webmap, Visibility.WebmapName, Visibility.WebmapDay, Visibility.WebmapNight, Visibility.WebmapUnderground, Visibility.WebmapTopo, Visibility.WebmapBiome});
        }

        public VisibilityData(boolean setAll) {
            this.values = setAll ? EnumSet.allOf(Visibility.class) : EnumSet.noneOf(Visibility.class);
        }

        public VisibilityData(VisibilityData other) {
            this.values = other.values.clone();
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof VisibilityData) {
                VisibilityData otherVisibility = (VisibilityData)other;
                return this.values.equals(otherVisibility.values);
            }
            return false;
        }

        public void setValue(Visibility value, boolean set) {
            if (set) {
                this.values.add(value);
            } else {
                this.values.remove((Object)value);
            }
        }

        public boolean getValue(Visibility value) {
            return this.values.contains((Object)value);
        }

        public boolean hasSome() {
            return !this.values.isEmpty();
        }

        public void readFromNBT(class_2487 nbt, int version) {
            boolean splitVisibility = version >= 10;
            this.setValue(Visibility.Frontier, nbt.method_10577("visible"));
            if (splitVisibility) {
                this.setValue(Visibility.Fullscreen, nbt.method_10545("fullscreenVisible") ? nbt.method_10577("fullscreenVisible") : true);
                this.setValue(Visibility.FullscreenName, nbt.method_10545("fullscreenNameVisible") ? nbt.method_10577("fullscreenNameVisible") : true);
                this.setValue(Visibility.FullscreenOwner, nbt.method_10545("fullscreenOwnerVisible") ? nbt.method_10577("fullscreenOwnerVisible") : false);
                this.setValue(Visibility.FullscreenBanner, nbt.method_10545("fullscreenBannerVisible") ? nbt.method_10577("fullscreenBannerVisible") : false);
                this.setValue(Visibility.FullscreenDay, nbt.method_10545("fullscreenDay") ? nbt.method_10577("fullscreenDay") : true);
                this.setValue(Visibility.FullscreenNight, nbt.method_10545("fullscreenNight") ? nbt.method_10577("fullscreenNight") : true);
                this.setValue(Visibility.FullscreenUnderground, nbt.method_10545("fullscreenUnderground") ? nbt.method_10577("fullscreenUnderground") : true);
                this.setValue(Visibility.FullscreenTopo, nbt.method_10545("fullscreenTopo") ? nbt.method_10577("fullscreenTopo") : true);
                this.setValue(Visibility.FullscreenBiome, nbt.method_10545("fullscreenBiome") ? nbt.method_10577("fullscreenBiome") : true);
                this.setValue(Visibility.Minimap, nbt.method_10545("minimapVisible") ? nbt.method_10577("minimapVisible") : true);
                this.setValue(Visibility.MinimapName, nbt.method_10545("minimapNameVisible") ? nbt.method_10577("minimapNameVisible") : true);
                this.setValue(Visibility.MinimapOwner, nbt.method_10545("minimapOwnerVisible") ? nbt.method_10577("minimapOwnerVisible") : false);
                this.setValue(Visibility.MinimapBanner, nbt.method_10545("minimapBannerVisible") ? nbt.method_10577("minimapBannerVisible") : false);
                this.setValue(Visibility.MinimapDay, nbt.method_10545("minimapDay") ? nbt.method_10577("minimapDay") : true);
                this.setValue(Visibility.MinimapNight, nbt.method_10545("minimapNight") ? nbt.method_10577("minimapNight") : true);
                this.setValue(Visibility.MinimapUnderground, nbt.method_10545("minimapUnderground") ? nbt.method_10577("minimapUnderground") : true);
                this.setValue(Visibility.MinimapTopo, nbt.method_10545("minimapTopo") ? nbt.method_10577("minimapTopo") : true);
                this.setValue(Visibility.MinimapBiome, nbt.method_10545("minimapBiome") ? nbt.method_10577("minimapBiome") : true);
                this.setValue(Visibility.Webmap, nbt.method_10545("webmapVisible") ? nbt.method_10577("webmapVisible") : this.getValue(Visibility.Minimap));
                this.setValue(Visibility.WebmapName, nbt.method_10545("webmapNameVisible") ? nbt.method_10577("webmapNameVisible") : this.getValue(Visibility.MinimapName));
                this.setValue(Visibility.WebmapOwner, nbt.method_10545("webmapOwnerVisible") ? nbt.method_10577("webmapOwnerVisible") : this.getValue(Visibility.MinimapOwner));
                this.setValue(Visibility.WebmapBanner, nbt.method_10545("webmapBannerVisible") ? nbt.method_10577("webmapBannerVisible") : this.getValue(Visibility.MinimapBanner));
                this.setValue(Visibility.WebmapDay, nbt.method_10545("webmapDay") ? nbt.method_10577("webmapDay") : this.getValue(Visibility.MinimapDay));
                this.setValue(Visibility.WebmapNight, nbt.method_10545("webmapNight") ? nbt.method_10577("webmapNight") : this.getValue(Visibility.MinimapNight));
                this.setValue(Visibility.WebmapUnderground, nbt.method_10545("webmapUnderground") ? nbt.method_10577("webmapUnderground") : this.getValue(Visibility.MinimapUnderground));
                this.setValue(Visibility.WebmapTopo, nbt.method_10545("webmapTopo") ? nbt.method_10577("webmapTopo") : this.getValue(Visibility.MinimapTopo));
                this.setValue(Visibility.WebmapBiome, nbt.method_10545("webmapBiome") ? nbt.method_10577("webmapBiome") : this.getValue(Visibility.MinimapBiome));
            } else {
                this.setValue(Visibility.Fullscreen, nbt.method_10577("visible"));
                this.setValue(Visibility.FullscreenName, nbt.method_10577("visible"));
                this.setValue(Visibility.FullscreenOwner, nbt.method_10577("nameVisible"));
                this.setValue(Visibility.FullscreenBanner, false);
                this.setValue(Visibility.FullscreenDay, nbt.method_10577("visible"));
                this.setValue(Visibility.FullscreenNight, nbt.method_10577("visible"));
                this.setValue(Visibility.FullscreenUnderground, nbt.method_10577("visible"));
                this.setValue(Visibility.FullscreenTopo, nbt.method_10577("visible"));
                this.setValue(Visibility.FullscreenBiome, nbt.method_10577("visible"));
                this.setValue(Visibility.Minimap, nbt.method_10577("visible"));
                this.setValue(Visibility.MinimapName, nbt.method_10577("nameVisible"));
                this.setValue(Visibility.MinimapOwner, nbt.method_10577("ownerVisible"));
                this.setValue(Visibility.MinimapBanner, false);
                this.setValue(Visibility.MinimapDay, nbt.method_10577("visible"));
                this.setValue(Visibility.MinimapNight, nbt.method_10577("visible"));
                this.setValue(Visibility.MinimapUnderground, nbt.method_10577("visible"));
                this.setValue(Visibility.MinimapTopo, nbt.method_10577("visible"));
                this.setValue(Visibility.MinimapBiome, nbt.method_10577("visible"));
                this.setValue(Visibility.Webmap, nbt.method_10577("visible"));
                this.setValue(Visibility.WebmapName, nbt.method_10577("nameVisible"));
                this.setValue(Visibility.WebmapOwner, nbt.method_10577("ownerVisible"));
                this.setValue(Visibility.WebmapBanner, false);
                this.setValue(Visibility.WebmapDay, nbt.method_10577("visible"));
                this.setValue(Visibility.WebmapNight, nbt.method_10577("visible"));
                this.setValue(Visibility.WebmapUnderground, nbt.method_10577("visible"));
                this.setValue(Visibility.WebmapTopo, nbt.method_10577("visible"));
                this.setValue(Visibility.WebmapBiome, nbt.method_10577("visible"));
            }
            if (nbt.method_10545("announceInChat")) {
                this.setValue(Visibility.AnnounceInChat, nbt.method_10577("announceInChat"));
            }
            if (nbt.method_10545("announceInTitle")) {
                this.setValue(Visibility.AnnounceInTitle, nbt.method_10577("announceInTitle"));
            }
        }

        public void writeToNBT(class_2487 nbt) {
            nbt.method_10556("visible", this.getValue(Visibility.Frontier));
            nbt.method_10556("announceInChat", this.getValue(Visibility.AnnounceInChat));
            nbt.method_10556("announceInTitle", this.getValue(Visibility.AnnounceInTitle));
            nbt.method_10556("fullscreenVisible", this.getValue(Visibility.Fullscreen));
            nbt.method_10556("fullscreenNameVisible", this.getValue(Visibility.FullscreenName));
            nbt.method_10556("fullscreenOwnerVisible", this.getValue(Visibility.FullscreenOwner));
            nbt.method_10556("fullscreenBannerVisible", this.getValue(Visibility.FullscreenBanner));
            nbt.method_10556("fullscreenDay", this.getValue(Visibility.FullscreenDay));
            nbt.method_10556("fullscreenNight", this.getValue(Visibility.FullscreenNight));
            nbt.method_10556("fullscreenUnderground", this.getValue(Visibility.FullscreenUnderground));
            nbt.method_10556("fullscreenTopo", this.getValue(Visibility.FullscreenTopo));
            nbt.method_10556("fullscreenBiome", this.getValue(Visibility.FullscreenBiome));
            nbt.method_10556("minimapVisible", this.getValue(Visibility.Minimap));
            nbt.method_10556("minimapNameVisible", this.getValue(Visibility.MinimapName));
            nbt.method_10556("minimapOwnerVisible", this.getValue(Visibility.MinimapOwner));
            nbt.method_10556("minimapBannerVisible", this.getValue(Visibility.MinimapBanner));
            nbt.method_10556("minimapDay", this.getValue(Visibility.MinimapDay));
            nbt.method_10556("minimapNight", this.getValue(Visibility.MinimapNight));
            nbt.method_10556("minimapUnderground", this.getValue(Visibility.MinimapUnderground));
            nbt.method_10556("minimapTopo", this.getValue(Visibility.MinimapTopo));
            nbt.method_10556("minimapBiome", this.getValue(Visibility.MinimapBiome));
            nbt.method_10556("webmapVisible", this.getValue(Visibility.Webmap));
            nbt.method_10556("webmapNameVisible", this.getValue(Visibility.WebmapName));
            nbt.method_10556("webmapOwnerVisible", this.getValue(Visibility.WebmapOwner));
            nbt.method_10556("webmapBannerVisible", this.getValue(Visibility.WebmapBanner));
            nbt.method_10556("webmapDay", this.getValue(Visibility.WebmapDay));
            nbt.method_10556("webmapNight", this.getValue(Visibility.WebmapNight));
            nbt.method_10556("webmapUnderground", this.getValue(Visibility.WebmapUnderground));
            nbt.method_10556("webmapTopo", this.getValue(Visibility.WebmapTopo));
            nbt.method_10556("webmapBiome", this.getValue(Visibility.WebmapBiome));
        }

        public void fromBytes(class_2540 buf) {
            this.setValue(Visibility.Frontier, buf.readBoolean());
            this.setValue(Visibility.AnnounceInChat, buf.readBoolean());
            this.setValue(Visibility.AnnounceInTitle, buf.readBoolean());
            this.setValue(Visibility.Fullscreen, buf.readBoolean());
            this.setValue(Visibility.FullscreenName, buf.readBoolean());
            this.setValue(Visibility.FullscreenOwner, buf.readBoolean());
            this.setValue(Visibility.FullscreenBanner, buf.readBoolean());
            this.setValue(Visibility.FullscreenDay, buf.readBoolean());
            this.setValue(Visibility.FullscreenNight, buf.readBoolean());
            this.setValue(Visibility.FullscreenUnderground, buf.readBoolean());
            this.setValue(Visibility.FullscreenTopo, buf.readBoolean());
            this.setValue(Visibility.FullscreenBiome, buf.readBoolean());
            this.setValue(Visibility.Minimap, buf.readBoolean());
            this.setValue(Visibility.MinimapName, buf.readBoolean());
            this.setValue(Visibility.MinimapOwner, buf.readBoolean());
            this.setValue(Visibility.MinimapBanner, buf.readBoolean());
            this.setValue(Visibility.MinimapDay, buf.readBoolean());
            this.setValue(Visibility.MinimapNight, buf.readBoolean());
            this.setValue(Visibility.MinimapUnderground, buf.readBoolean());
            this.setValue(Visibility.MinimapTopo, buf.readBoolean());
            this.setValue(Visibility.MinimapBiome, buf.readBoolean());
            this.setValue(Visibility.Webmap, buf.readBoolean());
            this.setValue(Visibility.WebmapName, buf.readBoolean());
            this.setValue(Visibility.WebmapOwner, buf.readBoolean());
            this.setValue(Visibility.WebmapBanner, buf.readBoolean());
            this.setValue(Visibility.WebmapDay, buf.readBoolean());
            this.setValue(Visibility.WebmapNight, buf.readBoolean());
            this.setValue(Visibility.WebmapUnderground, buf.readBoolean());
            this.setValue(Visibility.WebmapTopo, buf.readBoolean());
            this.setValue(Visibility.WebmapBiome, buf.readBoolean());
        }

        public void toBytes(class_2540 buf) {
            buf.method_52964(this.getValue(Visibility.Frontier));
            buf.method_52964(this.getValue(Visibility.AnnounceInChat));
            buf.method_52964(this.getValue(Visibility.AnnounceInTitle));
            buf.method_52964(this.getValue(Visibility.Fullscreen));
            buf.method_52964(this.getValue(Visibility.FullscreenName));
            buf.method_52964(this.getValue(Visibility.FullscreenOwner));
            buf.method_52964(this.getValue(Visibility.FullscreenBanner));
            buf.method_52964(this.getValue(Visibility.FullscreenDay));
            buf.method_52964(this.getValue(Visibility.FullscreenNight));
            buf.method_52964(this.getValue(Visibility.FullscreenUnderground));
            buf.method_52964(this.getValue(Visibility.FullscreenTopo));
            buf.method_52964(this.getValue(Visibility.FullscreenBiome));
            buf.method_52964(this.getValue(Visibility.Minimap));
            buf.method_52964(this.getValue(Visibility.MinimapName));
            buf.method_52964(this.getValue(Visibility.MinimapOwner));
            buf.method_52964(this.getValue(Visibility.MinimapBanner));
            buf.method_52964(this.getValue(Visibility.MinimapDay));
            buf.method_52964(this.getValue(Visibility.MinimapNight));
            buf.method_52964(this.getValue(Visibility.MinimapUnderground));
            buf.method_52964(this.getValue(Visibility.MinimapTopo));
            buf.method_52964(this.getValue(Visibility.MinimapBiome));
            buf.method_52964(this.getValue(Visibility.Webmap));
            buf.method_52964(this.getValue(Visibility.WebmapName));
            buf.method_52964(this.getValue(Visibility.WebmapOwner));
            buf.method_52964(this.getValue(Visibility.WebmapBanner));
            buf.method_52964(this.getValue(Visibility.WebmapDay));
            buf.method_52964(this.getValue(Visibility.WebmapNight));
            buf.method_52964(this.getValue(Visibility.WebmapUnderground));
            buf.method_52964(this.getValue(Visibility.WebmapTopo));
            buf.method_52964(this.getValue(Visibility.WebmapBiome));
        }

        public static enum Visibility {
            Frontier,
            AnnounceInChat,
            AnnounceInTitle,
            Fullscreen,
            FullscreenName,
            FullscreenOwner,
            FullscreenBanner,
            FullscreenDay,
            FullscreenNight,
            FullscreenUnderground,
            FullscreenTopo,
            FullscreenBiome,
            Minimap,
            MinimapName,
            MinimapOwner,
            MinimapBanner,
            MinimapDay,
            MinimapNight,
            MinimapUnderground,
            MinimapTopo,
            MinimapBiome,
            Webmap,
            WebmapName,
            WebmapOwner,
            WebmapBanner,
            WebmapDay,
            WebmapNight,
            WebmapUnderground,
            WebmapTopo,
            WebmapBiome;

        }
    }

    public static class BannerData {
        public class_1767 baseColor;
        public class_2499 patterns;
        public int rotation;

        public BannerData() {
            this.baseColor = class_1767.field_7952;
            this.rotation = 0;
        }

        public BannerData(BannerData other) {
            this.baseColor = other.baseColor;
            if (other.patterns != null) {
                this.patterns = other.patterns.method_10612();
            }
            this.rotation = other.rotation;
        }

        public BannerData(class_1799 item) {
            this(BannerData.getDyeColor(item), BannerData.getBannerPatternLayers(item));
        }

        public BannerData(class_1767 base, class_9307 bannerPatterns) {
            this.baseColor = base;
            class_638 level = class_310.method_1551().field_1687;
            Optional patternsOptional = class_9307.field_49405.encodeStart((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)bannerPatterns).result();
            patternsOptional.ifPresent(tag -> {
                if (tag.method_23258().equals((Object)class_2499.field_21039)) {
                    this.patterns = (class_2499)tag.method_10707();
                }
            });
            this.rotation = 0;
        }

        private static class_1767 getDyeColor(class_1799 item) {
            class_1792 class_17922 = item.method_7909();
            if (class_17922 instanceof class_1746) {
                class_1746 itemBanner = (class_1746)class_17922;
                return itemBanner.method_7706();
            }
            return class_1767.field_7963;
        }

        private static class_9307 getBannerPatternLayers(class_1799 item) {
            if (item.method_57353().method_57832(class_9334.field_49619)) {
                return (class_9307)item.method_57353().method_57829(class_9334.field_49619);
            }
            return class_9307.field_49404;
        }

        public void readFromNBT(class_2487 nbt) {
            this.baseColor = class_1767.method_7791((int)nbt.method_10550("Base"));
            this.patterns = nbt.method_10554("Patterns", 10);
            this.rotation = nbt.method_10550("Rotation");
        }

        public void writeToNBT(class_2487 nbt) {
            nbt.method_10569("Base", this.baseColor.method_7789());
            if (this.patterns != null) {
                nbt.method_10566("Patterns", (class_2520)this.patterns);
            }
            nbt.method_10569("Rotation", this.rotation);
        }

        public void fromBytes(class_2540 buf) {
            this.baseColor = class_1767.method_7791((int)buf.readInt());
            class_2487 nbt = buf.method_10798();
            if (nbt != null) {
                this.patterns = nbt.method_10554("Patterns", 10);
            }
            this.rotation = buf.readInt();
        }

        public void toBytes(class_2540 buf) {
            buf.method_53002(this.baseColor.method_7789());
            if (this.patterns == null) {
                buf.method_10794(null);
            } else {
                class_2487 nbt = new class_2487();
                nbt.method_10566("Patterns", (class_2520)this.patterns);
                buf.method_10794((class_2520)nbt);
            }
            buf.method_53002(this.rotation);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BannerData)) {
                return false;
            }
            BannerData that = (BannerData)o;
            return this.rotation == that.rotation && this.baseColor == that.baseColor && Objects.equals(this.patterns, that.patterns);
        }

        public int hashCode() {
            return Objects.hash(this.baseColor, this.patterns, this.rotation);
        }
    }

    public static class CopiedFrom {
        protected UUID id;
        protected SettingsUser user = new SettingsUser();

        public void readFromNBT(class_2487 nbt, int version) {
            this.id = UUID.fromString(nbt.method_10558("id"));
            this.user = new SettingsUser();
            if (nbt.method_10573("user", 10)) {
                this.user.readFromNBT(nbt.method_10562("user"));
            }
        }

        public int hashCode() {
            return Objects.hash(this.id, this.user);
        }

        public void writeToNBT(class_2487 nbt) {
            nbt.method_10582("id", this.id.toString());
            class_2487 nbtOwner = new class_2487();
            this.user.writeToNBT(nbtOwner);
            nbt.method_10566("user", (class_2520)nbtOwner);
        }

        public void fromBytes(class_2540 buf) {
            this.id = UUIDHelper.fromBytes((ByteBuf)buf);
            this.user = new SettingsUser();
            this.user.fromBytes(buf);
        }

        public void toBytes(class_2540 buf) {
            UUIDHelper.toBytes((ByteBuf)buf, this.id);
            this.user.toBytes(buf);
        }
    }
}

