/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers;

import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.event.EventHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontiers;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapFrontiers {
    public static final String MODID = "mapfrontiers";
    public static final Logger LOGGER = LogManager.getLogger((String)"MapFrontiers");
    public static final int FRONTIER_DATA_VERSION = 10;
    public static final int SETTINGS_DATA_VERSION = 4;
    private static FrontiersManager frontiersManager;

    protected static void init() {
        PacketHandler.init();
        EventHandler.subscribeServerStartingEvent(MapFrontiers.class, server -> {
            frontiersManager = new FrontiersManager();
            frontiersManager.loadOrCreateData((MinecraftServer)server);
            LOGGER.info("ServerStartingEvent done");
        });
        EventHandler.subscribeServerStoppingEvent(MapFrontiers.class, server -> {
            if (frontiersManager != null) {
                frontiersManager.close();
            }
            frontiersManager = null;
            LOGGER.info("ServerStoppingEvent done");
        });
        EventHandler.subscribePlayerJoinedEvent(MapFrontiers.class, (server, player) -> {
            if (frontiersManager == null) {
                return;
            }
            frontiersManager.ensureOwners((MinecraftServer)server);
            LOGGER.info("PlayerJoinedEvent done (" + player.method_5845() + ")");
        });
    }

    public static void ReceiveHandshake(class_3222 player) {
        PacketHandler.sendTo(new PacketSettingsProfile(frontiersManager.getSettings().getProfile(player)), player);
        PacketFrontiers packetFrontiers = new PacketFrontiers();
        for (ArrayList<FrontierData> frontiers : frontiersManager.getAllGlobalFrontiers().values()) {
            packetFrontiers.addGlobalFrontiers(frontiers);
        }
        for (ArrayList<FrontierData> frontiers : frontiersManager.getAllPersonalFrontiers(new SettingsUser((class_1657)player)).values()) {
            packetFrontiers.addPersonalFrontiers(frontiers);
        }
        PacketHandler.sendTo(packetFrontiers, player);
    }

    public static boolean isOPorHost(class_3222 player) {
        MinecraftServer server = player.method_51469().method_8503();
        return server.method_3760().method_14569(player.method_72498());
    }

    public static void createBackup(File folder, String filename) {
        File file = new File(folder, filename);
        if (!file.exists()) {
            return;
        }
        Path folderPath = folder.toPath();
        Path bakFile = folderPath.resolve(filename + ".bak1");
        try {
            for (int i = 10; i > 0; --i) {
                Path oldBak = folderPath.resolve(filename + ".bak" + i);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= 10) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, folderPath.resolve(filename + ".bak" + (i + 1)), new CopyOption[0]);
            }
            Files.copy(file.toPath(), bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            LOGGER.warn("Failed to back up file {}", (Object)file.toPath(), (Object)exception);
        }
    }
}

