/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ButtonBase;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.common.Config;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class SortToolbar
extends class_8667 {
    private SortButton selected;
    private Runnable onChange;

    public SortToolbar(class_327 font, Runnable onChange) {
        super(0, 0, class_8667.class_8668.field_45403);
        this.method_52735(8);
        this.onChange = onChange;
        for (Config.Sorting sort : Config.Sorting.values()) {
            int index = Config.frontierSorting.indexOf((Object)sort);
            if (index == -1) continue;
            SortButton button = (SortButton)this.method_52736((class_8021)new SortButton(font, sort, Config.frontierSortingDirection.get(index), this::buttonPressed));
            if (index != 0) continue;
            this.selected = button;
            this.selected.setSelected(true);
        }
    }

    private void buttonPressed(class_4185 button) {
        if (button instanceof SortButton) {
            SortButton sortButton = (SortButton)button;
            if (sortButton == this.selected) {
                sortButton.changeDirection();
                Config.frontierSortingDirection.set(0, Config.frontierSortingDirection.getFirst() == false);
            } else {
                this.selected.setSelected(false);
                int index = Config.frontierSorting.indexOf((Object)sortButton.getSorting());
                Config.frontierSorting.addFirst(Config.frontierSorting.remove(index));
                Config.frontierSortingDirection.addFirst(Config.frontierSortingDirection.remove(index));
                this.selected = sortButton;
                this.selected.setSelected(true);
            }
            ClientEventHandler.postUpdatedConfigEvent();
        }
        this.onChange.run();
    }

    @ParametersAreNonnullByDefault
    public static class SortButton
    extends ButtonBase {
        private final class_8667 layout = class_8667.method_52742();
        private boolean selected = false;
        private final Config.Sorting sorting;
        private boolean direction;
        private final StringWidget label;
        private final IconButton iconButton;

        public SortButton(class_327 font, Config.Sorting sorting, boolean direction, class_4185.class_4241 onPress) {
            super(0, 0, 0, 0, (class_2561)class_2561.method_43473(), onPress, field_40754);
            this.sorting = sorting;
            this.direction = direction;
            this.layout.method_52740().method_46474();
            class_2561 text = Config.getTranslatedEnum(sorting);
            this.label = (StringWidget)this.layout.method_52736((class_8021)new StringWidget(text, font, 16));
            this.iconButton = (IconButton)this.layout.method_52736((class_8021)new IconButton(direction ? IconButton.Type.SortUp : IconButton.Type.SortDown, b -> {}));
            this.layout.method_48222();
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.iconButton.method_25350(selected ? 1.0f : 0.0f);
        }

        public void changeDirection() {
            this.direction = !this.direction;
            this.iconButton.setType(this.direction ? IconButton.Type.SortUp : IconButton.Type.SortDown);
        }

        public Config.Sorting getSorting() {
            return this.sorting;
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            if (this.isHoveredOrKeyboardFocused()) {
                this.label.setColor(-1);
                this.iconButton.method_25365(true);
            } else {
                this.label.setColor(-6710887);
                this.iconButton.method_25365(false);
            }
            this.label.method_25394(graphics, mouseX, mouseY, partialTicks);
            if (this.selected) {
                this.iconButton.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
        }

        public void method_46421(int x) {
            super.method_46421(x);
            this.layout.method_46421(x);
        }

        public void method_46419(int y) {
            super.method_46419(y);
            this.layout.method_46419(y);
        }

        public int method_25368() {
            return this.layout.method_25368();
        }

        public int method_25364() {
            return this.layout.method_25364();
        }
    }
}

