/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.button.CheckBoxButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1074;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class UserSharedElement
extends ScrollBox.ScrollElement {
    private final class_327 font;
    private final SettingsUserShared user;
    private final CheckBoxButton updateFrontier;
    private final CheckBoxButton updateSettings;
    private IconButton buttonDelete;
    private final List<class_364> children;
    private final boolean enabled;
    private int pingBar = 0;

    public UserSharedElement(class_327 font, SettingsUserShared user, boolean enabled, boolean removable, ActionChangedConsumer actionChangedCallback) {
        super(430, 16);
        this.font = font;
        this.user = user;
        this.updateFrontier = new CheckBoxButton(user.hasAction(SettingsUserShared.Action.UpdateFrontier), b -> actionChangedCallback.accept(user, SettingsUserShared.Action.UpdateFrontier, b.isChecked()));
        this.updateFrontier.field_22763 = enabled;
        this.updateSettings = new CheckBoxButton(user.hasAction(SettingsUserShared.Action.UpdateSettings), b -> actionChangedCallback.accept(user, SettingsUserShared.Action.UpdateSettings, b.isChecked()));
        this.updateSettings.field_22763 = enabled;
        this.enabled = enabled;
        if (removable && enabled) {
            this.buttonDelete = new IconButton(IconButton.Type.Remove, button -> {});
        }
        this.children = List.of(this.updateFrontier, this.updateSettings);
    }

    public SettingsUser getUser() {
        return this.user.getUser();
    }

    public void setPingBar(int value) {
        this.pingBar = value;
        if (this.pingBar < 0) {
            this.pingBar = 0;
        } else if (this.pingBar > 5) {
            this.pingBar = 5;
        }
    }

    @Override
    protected void setX(int x) {
        super.setX(x);
        this.updateFrontier.method_46421(x + 244);
        this.updateSettings.method_46421(x + 304);
        if (this.buttonDelete != null) {
            this.buttonDelete.method_46421(this.x + 413);
        }
    }

    @Override
    protected void setY(int y) {
        super.setY(y);
        this.updateFrontier.method_46419(y + 2);
        this.updateSettings.method_46419(y + 2);
        if (this.buttonDelete != null) {
            this.buttonDelete.method_46419(this.y + 1);
        }
    }

    @Override
    protected void renderWidget(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        if (this.isHovered) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -1607454672);
        }
        if ((this.isHovered || focused) && this.buttonDelete != null) {
            this.buttonDelete.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.method_25303(this.font, this.user.getUser().toString(), this.x + 16, this.y + 4, -1);
        this.updateFrontier.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.updateSettings.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.user.isPending()) {
            graphics.method_25303(this.font, class_1074.method_4662((String)"mapfrontiers.pending", (Object[])new Object[]{class_124.field_1056}), this.x + 350, this.y + 4, -16720640);
        }
        if (this.pingBar > 0) {
            this.drawPingLine(graphics, this.x + 3, this.y + 11, 2);
        }
        if (this.pingBar > 1) {
            this.drawPingLine(graphics, this.x + 5, this.y + 11, 3);
        }
        if (this.pingBar > 2) {
            this.drawPingLine(graphics, this.x + 7, this.y + 11, 4);
        }
        if (this.pingBar > 3) {
            this.drawPingLine(graphics, this.x + 9, this.y + 11, 5);
        }
        if (this.pingBar > 4) {
            this.drawPingLine(graphics, this.x + 11, this.y + 11, 6);
        }
    }

    private void drawPingLine(class_332 graphics, int posX, int posY, int height) {
        graphics.method_25294(posX, posY - height, posX + 1, posY, -1);
    }

    @Override
    protected ScrollBox.ScrollElement.Action mousePressed(class_11909 event, boolean doubleClick) {
        if (this.enabled && this.visible && this.isHovered) {
            for (class_364 checkBox : this.children) {
                if (!checkBox.method_25402(event, doubleClick)) continue;
                return ScrollBox.ScrollElement.Action.None;
            }
            if (this.buttonDelete != null && this.buttonDelete.method_25405(event.comp_4798(), event.comp_4799())) {
                return ScrollBox.ScrollElement.Action.Deleted;
            }
        }
        return ScrollBox.ScrollElement.Action.None;
    }

    @Override
    public List<class_364> method_25396() {
        if (this.enabled) {
            return this.children;
        }
        return super.method_25396();
    }

    @Override
    protected boolean canBeDeleted() {
        return true;
    }

    @FunctionalInterface
    public static interface ActionChangedConsumer {
        public void accept(SettingsUserShared var1, SettingsUserShared.Action var2, boolean var3);
    }
}

