/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class TextBoxUser
extends TextBox {
    private final class_310 mc;
    private final class_327 font;
    private String partialText;
    private final List<String> suggestions;
    private final List<String> suggestionsToDraw;
    private class_2561 error;
    private int maxSuggestionWidth = 0;
    private int suggestionIndex = 0;

    public TextBoxUser(class_310 mc, class_327 font, int width) {
        this(mc, font, width, "");
    }

    public TextBoxUser(class_310 mc, class_327 font, int width, String defaultText) {
        super(font, width, defaultText);
        this.mc = mc;
        this.font = font;
        this.suggestions = new ArrayList<String>();
        this.suggestionsToDraw = new ArrayList<String>();
        this.setError(null);
    }

    public void setError(@Nullable class_2561 error) {
        this.error = error;
        if (this.error != null) {
            this.suggestions.clear();
            this.suggestionsToDraw.clear();
        }
    }

    @Override
    public boolean method_25404(class_11908 event) {
        if (event.method_74228() == 342) {
            if (this.suggestions.isEmpty()) {
                this.suggestionIndex = 0;
                class_634 handler = this.mc.method_1562();
                if (!StringUtils.isBlank((CharSequence)this.method_1882()) && handler != null) {
                    this.partialText = this.method_1882();
                    for (class_640 playerInfo : handler.method_2880()) {
                        String name = playerInfo.method_2966().name();
                        if (name == null || !name.regionMatches(true, 0, this.partialText, 0, this.partialText.length())) continue;
                        this.suggestions.add(name);
                    }
                }
            } else {
                ++this.suggestionIndex;
                if (this.suggestionIndex >= this.suggestions.size()) {
                    this.suggestionIndex = 0;
                }
            }
            this.suggestionsToDraw.clear();
            if (!this.suggestions.isEmpty()) {
                this.method_1852(this.suggestions.get(this.suggestionIndex));
                if (this.suggestions.size() == 1) {
                    this.suggestions.clear();
                } else {
                    this.maxSuggestionWidth = 0;
                    int size = this.suggestions.size();
                    if (size > 7) {
                        size = 7;
                    }
                    int firstIndex = 0;
                    if (this.suggestionIndex > 6) {
                        firstIndex = this.suggestionIndex - 6;
                    }
                    for (int i = firstIndex; i < firstIndex + size; ++i) {
                        this.suggestionsToDraw.add(this.suggestions.get(i));
                        int textWidth = this.font.method_1727(this.suggestions.get(i));
                        if (textWidth <= this.maxSuggestionWidth) continue;
                        this.maxSuggestionWidth = textWidth;
                    }
                }
            }
            return true;
        }
        this.suggestions.clear();
        this.suggestionsToDraw.clear();
        return super.method_25404(event);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        block7: {
            block6: {
                if (this.error == null) {
                    this.method_1868(-2039584);
                } else {
                    this.method_1868(-2289391);
                }
                super.method_48579(graphics, mouseX, mouseY, partialTicks);
                if (this.error == null) break block6;
                List errorList = this.font.method_1728((class_5348)this.error, this.field_22758 - 8);
                int maxErrorWidth = this.field_22758 - 8;
                graphics.method_25294(this.method_46426() - 1, this.method_46427() - errorList.size() * 12 - 5, this.method_46426() + maxErrorWidth + 9, this.method_46427() - 1, -6250336);
                graphics.method_25294(this.method_46426(), this.method_46427() - errorList.size() * 12 - 4, this.method_46426() + maxErrorWidth + 8, this.method_46427() - 1, -16777216);
                int posX = this.method_46426() + 4;
                int posY = this.method_46427() - errorList.size() * 12;
                for (class_5481 e : errorList) {
                    graphics.method_35720(this.font, e, posX, posY, -1);
                    posY += 12;
                }
                break block7;
            }
            if (this.suggestionsToDraw.isEmpty()) break block7;
            graphics.method_25294(this.method_46426() - 1, this.method_46427() - this.suggestionsToDraw.size() * 12 - 5, this.method_46426() + this.maxSuggestionWidth + 9, this.method_46427() - 1, -6250336);
            graphics.method_25294(this.method_46426(), this.method_46427() - this.suggestionsToDraw.size() * 12 - 4, this.method_46426() + this.maxSuggestionWidth + 8, this.method_46427() - 1, -16777216);
            int posX = this.method_46426() + 4;
            int posY = this.method_46427() - 12;
            for (int i = this.suggestionsToDraw.size() - 1; i >= 0; --i) {
                String t = this.suggestionsToDraw.get(i);
                if (this.suggestionsToDraw.get(i) == this.suggestions.get(this.suggestionIndex)) {
                    graphics.method_25303(this.font, t, posX, posY, -1);
                } else {
                    String suffix = t.substring(0, this.partialText.length());
                    String rest = t.substring(this.partialText.length());
                    graphics.method_25303(this.font, suffix, posX, posY, -1);
                    graphics.method_25303(this.font, rest, posX + this.font.method_1727(suffix), posY, 0xAAAAAA);
                }
                posY -= 12;
            }
        }
    }

    @Override
    public void method_25365(boolean isFocusedIn) {
        super.method_25365(isFocusedIn);
        if (!isFocusedIn) {
            this.suggestions.clear();
            this.suggestionsToDraw.clear();
        } else {
            this.setError(null);
        }
    }
}

