/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.FullscreenMap;
import games.alejandrocoria.mapfrontiers.client.gui.component.SortToolbar;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.FrontierListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.RadioListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierInfo;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ModSettings;
import games.alejandrocoria.mapfrontiers.client.gui.screen.NewFrontier;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import net.minecraft.class_1074;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

@ParametersAreNonnullByDefault
public class FrontierList
extends AutoScaledScreen {
    private static final class_2561 titleLabel = class_2561.method_43471((String)"mapfrontiers.title_frontiers");
    private static final class_2561 resetFiltersLabel = class_2561.method_43471((String)"mapfrontiers.reset_filters");
    private static final class_2561 filterTypeLabel = class_2561.method_43471((String)"mapfrontiers.filter_type");
    private static final class_2561 filterOwnerLabel = class_2561.method_43471((String)"mapfrontiers.filter_owner");
    private static final class_2561 filterDimensionLabel = class_2561.method_43471((String)"mapfrontiers.filter_dimension");
    private static final class_2561 configAllLabel = class_2561.method_43471((String)"mapfrontiers.config.All");
    private static final class_2561 configCurrentLabel = class_2561.method_43471((String)"mapfrontiers.config.Current");
    private static final class_2561 overworldLabel = class_2561.method_43470((String)"minecraft:overworld");
    private static final class_2561 theNetherLabel = class_2561.method_43470((String)"minecraft:the_nether");
    private static final class_2561 theEndLabel = class_2561.method_43470((String)"minecraft:the_end");
    private static final class_2561 createLabel = class_2561.method_43471((String)"mapfrontiers.create");
    private static final class_2561 infoLabel = class_2561.method_43471((String)"mapfrontiers.info");
    private static final class_2561 deleteLabel = class_2561.method_43471((String)"mapfrontiers.delete");
    private static final class_2561 hideLabel = class_2561.method_43471((String)"mapfrontiers.hide");
    private static final class_2561 settingsLabel = class_2561.method_43471((String)"mapfrontiers.settings");
    private static final class_2561 doneLabel = class_2561.method_43471((String)"gui.done");
    private final IClientAPI jmAPI;
    private final FullscreenMap fullscreenMap;
    private SortToolbar sortToolbar;
    private TextBox searchBox;
    private ScrollBox frontiers;
    private ScrollBox filterType;
    private ScrollBox filterOwner;
    private ScrollBox filterDimension;
    private SimpleButton buttonResetFilters;
    private SimpleButton buttonCreate;
    private SimpleButton buttonInfo;
    private SimpleButton buttonDelete;
    private SimpleButton buttonVisible;
    private SimpleButton buttonSettings;
    private SimpleButton buttonDone;

    public FrontierList(IClientAPI jmAPI, FullscreenMap fullscreenMap) {
        super(titleLabel, 778, 302);
        this.jmAPI = jmAPI;
        this.fullscreenMap = fullscreenMap;
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeNewFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> this.updateButtons());
    }

    @Override
    public void initScreen() {
        class_7845 mainLayout = new class_7845().method_48635(8).method_48636(4);
        this.content.method_52736((class_8021)mainLayout);
        class_7847 alignRightSettings = class_7847.method_46481().method_46470();
        class_7847 alignLeftSettings = class_7847.method_46481().method_46461();
        class_8667 toolbar = class_8667.method_52742();
        toolbar.method_52740().method_46474();
        mainLayout.method_46455((class_8021)toolbar, 0, 0, alignLeftSettings);
        this.sortToolbar = new SortToolbar(this.field_22793, this::updateFrontiers);
        toolbar.method_52736((class_8021)this.sortToolbar);
        toolbar.method_52736((class_8021)class_7852.method_46512((int)16));
        this.searchBox = new TextBox(this.field_22793, 100, class_1074.method_4662((String)"mapfrontiers.search", (Object[])new Object[0]));
        this.searchBox.method_1880(40);
        this.searchBox.method_53533(16);
        this.searchBox.setValueChangedCallback(value -> this.updateFrontiers());
        toolbar.method_52736((class_8021)this.searchBox);
        this.frontiers = new ScrollBox(this.actualHeight - 120, 450, 24);
        this.frontiers.setElementDeletedCallback(element -> this.updateButtons());
        this.frontiers.setElementClickedCallback(element -> {
            FrontierOverlay frontier = ((FrontierListElement)element).getFrontier();
            this.fullscreenMap.selectFrontier(frontier);
            this.updateButtons();
        });
        mainLayout.method_46455((class_8021)this.frontiers, 1, 0, alignRightSettings);
        this.buttonResetFilters = new SimpleButton(this.field_22793, 110, resetFiltersLabel, b -> {
            Config.filterFrontierType = Config.FilterFrontierType.All;
            this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
            Config.filterFrontierOwner = Config.FilterFrontierOwner.All;
            this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
            this.updateFrontiers();
            this.updateButtons();
        });
        mainLayout.method_46455((class_8021)this.buttonResetFilters, 0, 1, alignLeftSettings);
        class_8667 rightColumn = class_8667.method_52741().method_52735(2);
        rightColumn.method_52740().method_46461();
        mainLayout.method_46455((class_8021)rightColumn, 1, 1, alignLeftSettings);
        rightColumn.method_52736((class_8021)new StringWidget(filterTypeLabel, this.field_22793).setColor(-4144960));
        this.filterType = new ScrollBox(52, 200, 16);
        this.filterType.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierType.All), Config.FilterFrontierType.All.ordinal()));
        this.filterType.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierType.Global), Config.FilterFrontierType.Global.ordinal()));
        this.filterType.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierType.Personal), Config.FilterFrontierType.Personal.ordinal()));
        this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
        this.filterType.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierType = Config.FilterFrontierType.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        rightColumn.method_52736((class_8021)this.filterType);
        rightColumn.method_52736((class_8021)class_7852.method_46513((int)4));
        rightColumn.method_52736((class_8021)new StringWidget(filterOwnerLabel, this.field_22793).setColor(-4144960));
        this.filterOwner = new ScrollBox(52, 200, 16);
        this.filterOwner.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierOwner.All), Config.FilterFrontierOwner.All.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierOwner.You), Config.FilterFrontierOwner.You.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.field_22793, Config.getTranslatedEnum(Config.FilterFrontierOwner.Others), Config.FilterFrontierOwner.Others.ordinal()));
        this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
        this.filterOwner.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierOwner = Config.FilterFrontierOwner.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        rightColumn.method_52736((class_8021)this.filterOwner);
        rightColumn.method_52736((class_8021)class_7852.method_46513((int)4));
        rightColumn.method_52736((class_8021)new StringWidget(filterDimensionLabel, this.field_22793).setColor(-4144960));
        this.filterDimension = new ScrollBox(this.actualHeight - 274, 200, 16);
        this.filterDimension.addElement(new RadioListElement(this.field_22793, configAllLabel, "all".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, configCurrentLabel, "current".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, overworldLabel, "minecraft:overworld".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, theNetherLabel, "minecraft:the_nether".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.field_22793, theEndLabel, "minecraft:the_end".hashCode()));
        this.addDimensionsToFilter();
        this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        this.filterDimension.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierDimension = selected == "all".hashCode() ? "all" : (selected == "current".hashCode() ? "current" : this.getDimensionFromHash(selected));
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        if (this.filterDimension.getSelectedElement() == null) {
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        }
        rightColumn.method_52736((class_8021)this.filterDimension);
        this.buttonCreate = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 110, createLabel, b -> new NewFrontier(this.jmAPI, this.minecraft.field_1724.method_24515()).display()));
        this.buttonInfo = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 110, infoLabel, b -> {
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            new FrontierInfo(this.jmAPI, frontier).display();
        }));
        this.buttonDelete = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 110, deleteLabel, b -> {
            if (Config.askConfirmationFrontierDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_frontier_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationFrontierDelete = false;
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.deleteSelectedFrontier();
                }).display();
            } else {
                this.deleteSelectedFrontier();
            }
        }));
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonVisible = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 110, hideLabel, b -> {
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            frontier.toggleVisibility(FrontierData.VisibilityData.Visibility.Frontier);
            FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
            frontierManager.clientUpdateFrontier(frontier);
            this.updateButtons();
        }));
        this.buttonSettings = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 110, settingsLabel, b -> new ModSettings(true).display()));
        this.buttonDone = (SimpleButton)this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 110, doneLabel, b -> this.method_25419()));
        this.updateFrontiers();
        if (this.fullscreenMap.getSelected() != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(this.fullscreenMap.getSelected().getId()));
        }
        this.updateButtons();
    }

    @Override
    public void method_48640() {
        this.frontiers.method_55445(450, this.actualHeight - 100);
        this.filterDimension.method_55445(200, this.actualHeight - 269);
        super.method_48640();
        this.content.method_48229((this.actualWidth - this.content.method_25368()) / 2, 60);
    }

    @Override
    public void renderScaledBackgroundScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.actualWidth - 60, this.actualHeight - 60);
    }

    @Override
    public boolean method_25406(class_11909 event) {
        for (class_364 w : this.method_25396()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.method_25406(event);
    }

    public void method_25419() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.method_25419();
    }

    private void deleteSelectedFrontier() {
        FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
        frontierManager.clientDeleteFrontier(frontier);
        this.frontiers.removeElement(this.frontiers.getSelectedElement());
        this.updateButtons();
    }

    private void addDimensionsToFilter() {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.equals("minecraft:overworld") || dimension.equals("minecraft:the_nether") || dimension.equals("minecraft:the_end")) continue;
            this.filterDimension.addElement(new RadioListElement(this.field_22793, (class_2561)class_2561.method_43470((String)dimension), dimension.hashCode()));
        }
    }

    private String getDimensionFromHash(int hash) {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.hashCode() != hash) continue;
            return dimension;
        }
        return "";
    }

    private void updateFrontiers() {
        FrontierOverlay selectedFrontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        UUID frontierID = selectedFrontier == null ? null : selectedFrontier.getId();
        ArrayList<FrontierOverlay> toAdd = new ArrayList<FrontierOverlay>();
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Personal) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers().values()) {
                for (FrontierOverlay frontier2 : dimension) {
                    if (!this.checkFilterOwner(frontier2) || !this.checkFilterDimension(frontier2)) continue;
                    toAdd.add(frontier2);
                }
            }
        }
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Global) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers().values()) {
                for (FrontierOverlay frontier2 : dimension) {
                    if (!this.checkFilterOwner(frontier2) || !this.checkFilterDimension(frontier2)) continue;
                    toAdd.add(frontier2);
                }
            }
        }
        if (!class_3544.method_57181((String)this.searchBox.method_1882())) {
            String searchText = this.searchBox.method_1882().toLowerCase();
            toAdd.removeIf(frontier -> {
                String name = frontier.getName1().toLowerCase() + " " + frontier.getName2().toLowerCase();
                if (name.contains(searchText)) {
                    return false;
                }
                if (!class_3544.method_57181((String)frontier.getOwner().username) && frontier.getOwner().username.toLowerCase().contains(searchText)) {
                    return false;
                }
                return class_3544.method_57181((String)frontier.getOwner().uuid.toString()) || !frontier.getOwner().uuid.toString().toLowerCase().contains(searchText);
            });
        }
        toAdd.sort((a, b) -> {
            for (Config.Sorting sort : Config.frontierSorting) {
                int order;
                if ((order = (switch (sort) {
                    default -> throw new MatchException(null, null);
                    case Config.Sorting.Name -> {
                        int c = a.getName1().compareToIgnoreCase(b.getName1());
                        if (c == 0) {
                            yield a.getName2().compareToIgnoreCase(b.getName2());
                        }
                        yield c;
                    }
                    case Config.Sorting.Owner -> a.getOwner().compareTo(b.getOwner());
                    case Config.Sorting.VertexChunk -> Integer.compare(Math.max(a.getChunkCount(), a.getVertexCount()), Math.max(b.getChunkCount(), b.getVertexCount()));
                    case Config.Sorting.Area -> Float.compare(a.area, b.area);
                    case Config.Sorting.Modified -> {
                        if (a.getModified() == null && b.getModified() == null) {
                            yield 0;
                        }
                        if (a.getModified() == null) {
                            yield -1;
                        }
                        if (b.getModified() == null) {
                            yield 1;
                        }
                        yield a.getModified().compareTo(b.getModified());
                    }
                    case Config.Sorting.Created -> a.getCreated() == null && b.getCreated() == null ? 0 : (a.getCreated() == null ? -1 : (b.getCreated() == null ? 1 : a.getCreated().compareTo(b.getCreated())));
                })) == 0) continue;
                boolean ascending = Config.frontierSortingDirection.get(Config.frontierSorting.indexOf((Object)sort));
                return ascending ? order : -order;
            }
            return 0;
        });
        this.frontiers.removeAll();
        for (FrontierOverlay frontier3 : toAdd) {
            this.frontiers.addElement(new FrontierListElement(this.field_22793, frontier3));
        }
        if (frontierID != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(frontierID));
        }
    }

    private boolean checkFilterOwner(FrontierOverlay frontier) {
        boolean ownerIsPlayer;
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.All) {
            return true;
        }
        boolean bl = ownerIsPlayer = this.minecraft.field_1724 != null && frontier.getOwner().equals(new SettingsUser((class_1657)this.minecraft.field_1724));
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.You) {
            return ownerIsPlayer;
        }
        return !ownerIsPlayer;
    }

    private boolean checkFilterDimension(FrontierOverlay frontier) {
        if (Config.filterFrontierDimension.equals("all")) {
            return true;
        }
        String dimension = Config.filterFrontierDimension;
        if (dimension.equals("current") && this.minecraft.field_1687 != null) {
            dimension = this.minecraft.field_1687.method_27983().method_29177().toString();
        }
        return frontier.getDimension().method_29177().toString().equals(dimension);
    }

    private void updateButtons() {
        if (this.minecraft.field_1724 == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((class_1657)this.minecraft.field_1724);
        FrontierOverlay frontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, frontier, playerUser);
        this.buttonInfo.field_22763 = this.frontiers.getSelectedElement() != null;
        this.buttonDelete.field_22763 = actions.canDelete;
        this.buttonVisible.field_22763 = actions.canUpdate;
        if (frontier != null && ((FrontierData)frontier).getVisibility(FrontierData.VisibilityData.Visibility.Frontier)) {
            this.buttonVisible.method_25355((class_2561)class_2561.method_43471((String)"mapfrontiers.hide"));
        } else {
            this.buttonVisible.method_25355((class_2561)class_2561.method_43471((String)"mapfrontiers.show"));
        }
    }
}

