/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.mixin.GuiGraphicsAccessor;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import games.alejandrocoria.mapfrontiers.platform.services.IJourneyMapHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;

@ParametersAreNonnullByDefault
public class PreviewFrontiersWidget
extends AbstractWidgetNoNarration {
    private static final ResourceLocation backgroundTexture = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/frontier_preview_bg.png");
    private static final int SIZE = 420;
    private final IJourneyMapHelper.ICustomPreviewRenderer customPreviewRenderer;
    private final List<FrontierOverlay> previewFrontiers = new ArrayList<FrontierOverlay>();
    private float scaleFactor = 1.0f;

    public PreviewFrontiersWidget() {
        super(0, 0, 420, 420, (Component)Component.empty());
        HolderLookup patternRegistry = (HolderLookup)Minecraft.getInstance().level.registryAccess().lookup(Registries.BANNER_PATTERN).get();
        BannerPatternLayers patterns = new BannerPatternLayers.Builder().add((Holder)patternRegistry.get(BannerPatterns.FLOWER).get(), DyeColor.GREEN).add((Holder)patternRegistry.get(BannerPatterns.BRICKS).get(), DyeColor.LIGHT_GRAY).add((Holder)patternRegistry.get(BannerPatterns.BORDER).get(), DyeColor.LIGHT_BLUE).add((Holder)patternRegistry.get(BannerPatterns.TRIANGLE_TOP).get(), DyeColor.LIGHT_BLUE).add((Holder)patternRegistry.get(BannerPatterns.TRIANGLE_BOTTOM).get(), DyeColor.BLACK).add((Holder)patternRegistry.get(BannerPatterns.STRIPE_BOTTOM).get(), DyeColor.GREEN).build();
        SettingsUser owner = new SettingsUser();
        owner.username = "Player";
        FrontierData frontierData = new FrontierData();
        frontierData.setOwner(owner);
        frontierData.setName1("Preview");
        frontierData.setName2("Frontier");
        frontierData.setColor(-3342480);
        frontierData.setBanner(DyeColor.BLACK, patterns);
        frontierData.setDimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld")));
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenDay, true);
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenName, true);
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenOwner, true);
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenBanner, true);
        frontierData.addVertex(new BlockPos(10, 70, 10));
        frontierData.addVertex(new BlockPos(10, 70, 410));
        frontierData.addVertex(new BlockPos(270, 70, 410));
        frontierData.addVertex(new BlockPos(270, 70, 10));
        this.previewFrontiers.add(new FrontierOverlay(frontierData, null));
        frontierData = new FrontierData();
        frontierData.setOwner(owner);
        frontierData.setName1("Long name");
        frontierData.setName2("12345678901234567");
        frontierData.setColor(-6250241);
        frontierData.setDimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld")));
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenDay, true);
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenName, true);
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenOwner, false);
        frontierData.setVisibility(FrontierData.VisibilityData.Visibility.FullscreenBanner, false);
        frontierData.addVertex(new BlockPos(240, 70, 280));
        frontierData.addVertex(new BlockPos(300, 70, 245));
        frontierData.addVertex(new BlockPos(360, 70, 280));
        frontierData.addVertex(new BlockPos(360, 70, 350));
        frontierData.addVertex(new BlockPos(300, 70, 385));
        frontierData.addVertex(new BlockPos(240, 70, 350));
        this.previewFrontiers.add(new FrontierOverlay(frontierData, null));
        this.customPreviewRenderer = Services.JOURNEYMAP.createCustomPreviewRenderer();
        this.configUpdated();
    }

    public void configUpdated() {
        for (FrontierOverlay frontierOverlay : this.previewFrontiers) {
            frontierOverlay.recalculateOverlays();
        }
        this.customPreviewRenderer.setFrontiers(this.previewFrontiers);
    }

    public void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
        double guiScale = Minecraft.getInstance().getWindow().getGuiScale() / (double)scaleFactor;
        this.setWidth((int)(420.0 / guiScale));
        this.setHeight((int)(420.0 / guiScale));
        this.customPreviewRenderer.setFrontiers(this.previewFrontiers);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(RenderType::guiTextured, backgroundTexture, this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 420, 420, 420, 420);
        graphics.hLine(this.getX(), this.getX() + this.getWidth() - 1, this.getY(), -6250336);
        graphics.hLine(this.getX(), this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, -6250336);
        graphics.vLine(this.getX(), this.getY(), this.getY() + this.getHeight() - 1, -6250336);
        graphics.vLine(this.getX() + this.getWidth() - 1, this.getY(), this.getY() + this.getHeight() - 1, -6250336);
        this.customPreviewRenderer.draw(graphics, ((GuiGraphicsAccessor)graphics).getBufferSource(), this.getX(), this.getY(), 420, this.scaleFactor);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return null;
    }
}

