/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ScrollBox
extends AbstractContainerWidget {
    private final int elementHeight;
    private int scrollStart = 0;
    private int scrollHeight;
    private int scrollBarPos = 0;
    private int scrollBarHeight = 0;
    private boolean scrollBarHovered = false;
    private boolean scrollBarGrabbed = false;
    private int scrollBarGrabbedYPos = 0;
    private final List<ScrollElement> elements = new ArrayList<ScrollElement>();
    private int selected = -1;
    private int focused = -1;
    private Consumer<ScrollElement> elementClickedCallback;
    private Consumer<ScrollElement> elementDeletedCallback;
    private Consumer<ScrollElement> elementDeletePressedCallback;

    public ScrollBox(int height, int elementWidth, int elementHeight) {
        super(0, 0, elementWidth + 15, Math.max(height, elementHeight + 1), (Component)Component.empty());
        this.elementHeight = elementHeight + 1;
        this.scrollHeight = this.height / this.elementHeight;
        this.height = this.scrollHeight * this.elementHeight;
    }

    public void setElementClickedCallback(Consumer<ScrollElement> callback) {
        this.elementClickedCallback = callback;
    }

    public void setElementDeletedCallback(Consumer<ScrollElement> callback) {
        this.elementDeletedCallback = callback;
    }

    public void setElementDeletePressedCallback(Consumer<ScrollElement> callback) {
        this.elementDeletePressedCallback = callback;
    }

    public List<ScrollElement> getElements() {
        return this.elements;
    }

    public void addElement(ScrollElement element) {
        element.setX(this.getX());
        element.setY(this.getY() + this.elements.size() * this.elementHeight);
        this.elements.add(element);
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void selectElement(ScrollElement element) {
        this.focused = this.selected = this.elements.indexOf(element);
    }

    @Nullable
    public ScrollElement getSelectedElement() {
        if (this.selected >= 0 && this.selected < this.elements.size()) {
            return this.elements.get(this.selected);
        }
        return null;
    }

    public void selectIndex(int index) {
        this.focused = this.selected = Math.min(Math.max(index, 0), this.elements.size() - 1);
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void selectElementIf(Predicate<ScrollElement> pred) {
        ScrollElement element = this.elements.stream().filter(pred).findFirst().orElse(null);
        if (element == null) {
            this.selected = -1;
            this.focused = -1;
        } else {
            this.selectElement(element);
        }
    }

    public void removeElement(ScrollElement element) {
        ListIterator<ScrollElement> it = this.elements.listIterator();
        while (it.hasNext()) {
            if (it.next() != element) continue;
            this.removeElement(element, it);
            return;
        }
    }

    private void removeElement(ScrollElement element, ListIterator<ScrollElement> it) {
        it.remove();
        if (this.selected == this.elements.size()) {
            this.selected = this.elements.size() - 1;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setY(this.getY() + i * this.elementHeight);
        }
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
        if (this.elementDeletedCallback != null) {
            this.elementDeletedCallback.accept(element);
        }
        if (this.selected >= 0 && this.elementClickedCallback != null) {
            this.elementClickedCallback.accept(this.getSelectedElement());
        }
        this.focused = this.selected;
    }

    public void removeAll() {
        this.elements.clear();
        this.selected = -1;
        this.focused = -1;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigationEvent) {
        List<GuiEventListener> children;
        if (!this.visible || !this.active || this.elements.isEmpty()) {
            return null;
        }
        int focusedChild = -1;
        List<GuiEventListener> list = children = this.focused == -1 ? null : this.elements.get(this.focused).children();
        if (children != null) {
            if (children.isEmpty()) {
                children = null;
            } else {
                for (int i = 0; i < children.size(); ++i) {
                    if (!children.get(i).isFocused()) continue;
                    focusedChild = i;
                    break;
                }
            }
        }
        if (this.isFocused()) {
            boolean forward = true;
            if (navigationEvent instanceof FocusNavigationEvent.ArrowNavigation) {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)navigationEvent;
                forward = arrowNavigation.direction().isPositive();
                if (arrowNavigation.direction().getAxis() == ScreenAxis.HORIZONTAL) {
                    if (children != null) {
                        if ((focusedChild += forward ? 1 : -1) < 0 || focusedChild >= children.size()) {
                            return null;
                        }
                        return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)this.elements.get(this.focused).focusPathAtIndex(navigationEvent, focusedChild));
                    }
                    return null;
                }
            } else if (navigationEvent instanceof FocusNavigationEvent.TabNavigation) {
                FocusNavigationEvent.TabNavigation tabNavigation = (FocusNavigationEvent.TabNavigation)navigationEvent;
                forward = tabNavigation.forward();
            }
            if (forward) {
                if (this.focused == this.elements.size() - 1) {
                    return null;
                }
                ++this.focused;
            } else {
                if (this.focused == 0) {
                    return null;
                }
                this.focused = this.focused == -1 ? this.elements.size() - 1 : --this.focused;
            }
        } else {
            this.focused = navigationEvent.getVerticalDirectionForInitialFocus().isPositive() ? 0 : this.elements.size() - 1;
        }
        if (this.focused < this.scrollStart || this.focused >= this.scrollStart + this.scrollHeight) {
            this.scrollStart = this.focused < this.scrollStart ? this.focused : this.focused - this.scrollHeight + 1;
            this.updateScrollWindow();
            this.updateScrollBar();
        }
        if (!this.elements.get(this.focused).children().isEmpty()) {
            if (focusedChild == -1) {
                focusedChild = 0;
            }
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)this.elements.get(this.focused).focusPathAtIndex(navigationEvent, focusedChild));
        }
        return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)((GuiEventListener)this.elements.get(this.focused))));
    }

    public void setX(int x) {
        super.setX(x);
        for (ScrollElement element : this.elements) {
            element.setX(x);
        }
    }

    public void setY(int y) {
        super.setY(y);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setY(y + i * this.elementHeight);
        }
    }

    public void setSize(int elementWidth, int height) {
        super.setSize(elementWidth + 15, height);
        this.setHeight(height);
    }

    public void setWidth(int elementWidth) {
        super.setWidth(elementWidth + 15);
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.scrollHeight = this.height / this.elementHeight;
        this.height = this.scrollHeight * this.elementHeight;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public List<? extends GuiEventListener> children() {
        return this.elements;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.visible && (this.isHovered || this.scrollBarHovered) && !this.scrollBarGrabbed) {
            int amount = (int)(-vDelta);
            if (amount < 0 && this.scrollStart == 0) {
                return false;
            }
            if (amount > 0 && this.scrollStart + this.scrollHeight >= this.elements.size()) {
                return false;
            }
            this.scrollStart += amount;
            this.updateScrollWindow();
            this.updateScrollBar();
            return true;
        }
        return false;
    }

    protected int contentHeight() {
        return this.elementHeight;
    }

    protected double scrollRate() {
        return this.elementHeight;
    }

    public void scrollBottom() {
        this.scrollStart = this.elements.size() - this.scrollHeight;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.elements.size(); ++i) {
            boolean isFocused = this.focused == i && this.isKeyboardFocused();
            this.elements.get(i).render(graphics, mouseX, mouseY, partialTicks, this.selected == i, isFocused);
        }
        if (this.scrollBarHeight > 0) {
            this.scrollBarHovered = mouseX >= this.getX() + this.width - 10 && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int barColor = -8947849;
            if (this.scrollBarGrabbed) {
                barColor = -10066330;
            } else if (this.scrollBarHovered) {
                barColor = -5592406;
            }
            graphics.fill(this.getX() + this.width - 10, this.getY(), this.getX() + this.width, this.getY() + this.height, 0x1AFFFFFF);
            graphics.fill(this.getX() + this.width - 10, this.getY() + this.scrollBarPos, this.getX() + this.width, this.getY() + this.scrollBarPos + this.scrollBarHeight, barColor);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && this.isValidClickButton(button)) {
            if (this.scrollBarHeight > 0 && mouseX >= (double)(this.getX() + this.width - 10) && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.width) && mouseY < (double)(this.getY() + this.height)) {
                if (mouseY < (double)(this.getY() + this.scrollBarPos)) {
                    this.mouseScrolled(mouseX, mouseY, 0.0, 1.0);
                } else if (mouseY > (double)(this.getY() + this.scrollBarPos + this.scrollBarHeight)) {
                    this.mouseScrolled(mouseX, mouseY, 0.0, -1.0);
                } else {
                    this.scrollBarGrabbed = true;
                    this.scrollBarGrabbedYPos = (int)mouseY - this.getY() - this.scrollBarPos;
                }
                return true;
            }
            if (this.isHovered && !this.scrollBarGrabbed) {
                ListIterator<ScrollElement> it = this.elements.listIterator();
                while (it.hasNext()) {
                    ScrollElement element = it.next();
                    ScrollElement.Action action = element.mousePressed(mouseX, mouseY);
                    if (action == ScrollElement.Action.Deleted) {
                        if (this.elementDeletePressedCallback != null) {
                            this.elementDeletePressedCallback.accept(element);
                        } else {
                            this.removeElement(element, it);
                        }
                        return true;
                    }
                    if (action != ScrollElement.Action.Clicked || this.getSelectedElement() == element) continue;
                    this.selectElement(element);
                    if (this.elementClickedCallback != null) {
                        this.elementClickedCallback.accept(element);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void mouseReleased() {
        if (this.visible && this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            this.scrollBarGrabbed = false;
            this.updateScrollBar();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.active && this.visible) {
            ScrollElement element;
            if (CommonInputs.selected((int)keyCode)) {
                this.selectIndex(this.focused);
                if (this.selected != -1) {
                    ScrollElement focusedElement = this.elements.get(this.focused);
                    if (!focusedElement.children().isEmpty()) {
                        focusedElement.keyPressed(keyCode, scanCode, modifiers);
                    } else if (this.elementClickedCallback != null) {
                        this.elementClickedCallback.accept(this.getSelectedElement());
                    }
                }
                return true;
            }
            if (keyCode == 261 && this.focused != -1 && (element = this.elements.get(this.focused)).canBeDeleted()) {
                if (this.elementDeletePressedCallback != null) {
                    this.elementDeletePressedCallback.accept(element);
                } else {
                    this.removeElement(element);
                }
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            int delta = (int)mouseY - this.getY() - this.scrollBarPos - this.scrollBarGrabbedYPos;
            if (delta == 0) {
                return;
            }
            this.scrollBarPos += delta;
            if (this.scrollBarPos < 0) {
                this.scrollBarPos = 0;
            } else if (this.scrollBarPos + this.scrollBarHeight > this.height) {
                this.scrollBarPos = this.height - this.scrollBarHeight;
            }
            int newScrollStart = Math.round((float)this.scrollBarPos / (float)this.height * (float)this.elements.size());
            if (newScrollStart != this.scrollStart) {
                this.scrollStart = newScrollStart;
                this.updateScrollWindow();
            }
        }
    }

    protected boolean isHoveredOrKeyboardFocused() {
        return this.isHovered() || this.isFocused() && Minecraft.getInstance().getLastInputType().isKeyboard();
    }

    protected boolean isKeyboardFocused() {
        return this.isFocused() && Minecraft.getInstance().getLastInputType().isKeyboard();
    }

    private void updateScrollWindow() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollStart = 0;
        } else {
            int bottomExtra = this.elements.size() - (this.scrollStart + this.scrollHeight);
            if (bottomExtra < 0) {
                this.scrollStart += bottomExtra;
            }
            if (this.scrollStart < 0) {
                this.scrollStart = 0;
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i < this.scrollStart || i >= this.scrollStart + this.scrollHeight) {
                this.elements.get((int)i).visible = false;
                continue;
            }
            this.elements.get((int)i).visible = true;
            this.elements.get(i).setY(this.getY() + (i - this.scrollStart) * this.elementHeight);
        }
    }

    private void updateScrollBar() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollBarHeight = 0;
            this.scrollBarHovered = false;
            this.scrollBarGrabbed = false;
            return;
        }
        this.scrollBarHeight = Math.round((float)this.scrollHeight / (float)this.elements.size() * (float)this.height);
        this.scrollBarPos = Math.round((float)this.scrollStart / (float)this.elements.size() * (float)this.height);
        if (this.scrollBarPos + this.scrollBarHeight > this.height) {
            this.scrollBarPos = this.height - this.scrollBarHeight;
        }
    }

    public static class ScrollElement
    implements ContainerEventHandler {
        protected boolean visible = true;
        protected int x = 0;
        protected int y = 0;
        protected boolean isHovered = false;
        protected GuiEventListener focused;
        protected boolean dragging;
        protected final int height;
        protected final int width;

        protected ScrollElement(int width, int height) {
            this.width = width;
            this.height = height;
        }

        protected void setX(int x) {
            this.x = x;
        }

        protected void setY(int y) {
            this.y = y;
        }

        protected void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
            if (this.visible) {
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                this.renderWidget(graphics, mouseX, mouseY, partialTicks, selected, focused);
                if (focused) {
                    graphics.hLine(this.x - 1, this.x + this.width, this.y - 1, -1);
                    graphics.hLine(this.x - 1, this.x + this.width, this.y + this.height, -1);
                    graphics.vLine(this.x - 1, this.y - 1, this.y + this.height, -1);
                    graphics.vLine(this.x + this.width, this.y - 1, this.y + this.height, -1);
                }
            } else {
                this.isHovered = false;
            }
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        }

        protected Action mousePressed(double mouseX, double mouseY) {
            return Action.None;
        }

        protected boolean canBeDeleted() {
            return false;
        }

        public List<GuiEventListener> children() {
            return Collections.emptyList();
        }

        public boolean isDragging() {
            return this.dragging;
        }

        public void setDragging(boolean dragging) {
            this.dragging = dragging;
        }

        public GuiEventListener getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable GuiEventListener guiEventListener) {
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            this.focused = guiEventListener;
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent navigationEvent, int index) {
            int i;
            if (this.children().isEmpty()) {
                return null;
            }
            ComponentPath path = this.children().get(Math.min(index, this.children().size() - 1)).nextFocusPath(navigationEvent);
            for (i = index; i < this.children().size() && path == null && !this.children().get(i).isFocused(); ++i) {
                path = this.children().get(i).nextFocusPath(navigationEvent);
            }
            for (i = index - 1; i > 0 && path == null && !this.children().get(i).isFocused(); --i) {
                path = this.children().get(i).nextFocusPath(navigationEvent);
            }
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path);
        }

        public ComponentPath getCurrentFocusPath() {
            if (this.children().isEmpty()) {
                return ComponentPath.leaf((GuiEventListener)this);
            }
            return this.getFocused() != null ? ComponentPath.path((ContainerEventHandler)this, (ComponentPath)this.getFocused().getCurrentFocusPath()) : ComponentPath.leaf((GuiEventListener)this);
        }

        public static enum Action {
            None,
            Clicked,
            Deleted;

        }
    }
}

