/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import java.util.function.DoubleConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class TextBoxDouble
extends EditBox {
    private final double defaultValue;
    private final double min;
    private final double max;
    private DoubleConsumer valueChangedCallback;

    public TextBoxDouble(double defaultValue, double min, double max, Font font, int width) {
        super(font, 0, 0, width, 12, (Component)Component.empty());
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.setValue(defaultValue);
    }

    public void setValueChangedCallback(DoubleConsumer callback) {
        this.valueChangedCallback = callback;
    }

    public void insertText(String textToWrite) {
        if (textToWrite.equals("-") && this.getCursorPosition() == 0) {
            super.insertText(textToWrite);
            return;
        }
        if (textToWrite.equals("0")) {
            super.insertText(textToWrite);
            return;
        }
        if (textToWrite.equals(".")) {
            super.insertText(textToWrite);
            return;
        }
        String currentString = this.getValue();
        super.insertText(textToWrite);
        try {
            double current = Double.parseDouble(this.getValue());
            this.setValue(current);
        }
        catch (Exception e) {
            this.setValue(currentString);
        }
    }

    public void setValue(Object object) {
        this.setValue(object.toString());
        if (this.valueChangedCallback != null) {
            try {
                double current = Double.parseDouble(this.getValue());
                this.valueChangedCallback.accept(current);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean charTyped(char c, int key) {
        boolean res = false;
        if (this.isHoveredOrFocused() && (res = super.charTyped(c, key))) {
            double current;
            try {
                current = Double.parseDouble(this.getValue());
                if (current > this.max) {
                    this.setValue(this.max);
                    current = this.max;
                }
            }
            catch (Exception e) {
                boolean bl = true;
                return bl;
            }
            finally {
                this.moveCursorToStart(false);
                this.moveCursorToEnd(false);
            }
            if (this.valueChangedCallback != null) {
                this.valueChangedCallback.accept(Math.max(current, this.min));
            }
        }
        return res;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean res = false;
        if (this.isHoveredOrFocused()) {
            res = super.keyPressed(keyCode, scanCode, modifiers);
            if (this.valueChangedCallback != null && (keyCode == 259 || keyCode == 261)) {
                this.valueChangedCallback.accept(this.clamped());
            }
            if (keyCode == 257 || keyCode == 335) {
                this.setFocused(false);
            }
        }
        return res;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.visible && this.isHovered) {
            double current;
            try {
                current = Double.parseDouble(this.getValue());
            }
            catch (Exception e) {
                current = this.defaultValue;
            }
            if (vDelta > 0.0) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.setValue(Math.min(current + 0.1, this.max));
            } else if (vDelta < 0.0) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.setValue(Math.max(current - 0.1, this.min));
            }
            return true;
        }
        return false;
    }

    public double clamped() {
        double current;
        String text = this.getValue();
        if (text.isEmpty()) {
            return this.defaultValue;
        }
        try {
            current = Double.parseDouble(text);
        }
        catch (Exception e) {
            return this.defaultValue;
        }
        current = Math.max(this.min, current);
        current = Math.min(this.max, current);
        return current;
    }

    public void setFocused(boolean isFocusedIn) {
        if (!isFocusedIn) {
            this.setValue(this.clamped());
        }
        super.setFocused(isFocusedIn);
    }
}

