/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.hud;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class HUD {
    private static final Minecraft mc = Minecraft.getInstance();
    private FrontierOverlay frontier;
    private int frontierHash;
    private BlockPos lastPlayerPosition = new BlockPos(0, 0, 0);
    private final StringWidget frontierName1;
    private final StringWidget frontierName2;
    private final StringWidget frontierOwner;
    private final List<Config.HUDSlot> slots = new ArrayList<Config.HUDSlot>();
    private int posX = 0;
    private int posY = 0;
    private int nameOffsetY = 0;
    private int ownerOffsetY = 0;
    private int bannerOffsetY = 0;
    private int hudWidth = 0;
    private int hudHeight = 0;
    private int textScale = 1;
    private int bannerScale = 1;
    private boolean needUpdate = true;
    private boolean previewMode = false;
    private int displayWidth;
    private int displayHeight;

    public static HUD asPreview() {
        HUD hud = new HUD();
        hud.previewMode = true;
        HolderLookup patternRegistry = (HolderLookup)HUD.mc.level.registryAccess().lookup(Registries.BANNER_PATTERN).get();
        BannerPatternLayers patterns = new BannerPatternLayers.Builder().add((Holder)patternRegistry.get(BannerPatterns.FLOWER).get(), DyeColor.GREEN).add((Holder)patternRegistry.get(BannerPatterns.BRICKS).get(), DyeColor.LIGHT_GRAY).add((Holder)patternRegistry.get(BannerPatterns.BORDER).get(), DyeColor.LIGHT_BLUE).add((Holder)patternRegistry.get(BannerPatterns.TRIANGLE_TOP).get(), DyeColor.LIGHT_BLUE).add((Holder)patternRegistry.get(BannerPatterns.TRIANGLE_BOTTOM).get(), DyeColor.BLACK).add((Holder)patternRegistry.get(BannerPatterns.STRIPE_BOTTOM).get(), DyeColor.GREEN).build();
        FrontierData frontierData = new FrontierData();
        frontierData.setOwner(new SettingsUser((Player)HUD.mc.player));
        frontierData.setName1("Preview Frontier");
        frontierData.setName2("-----------------");
        frontierData.setBanner(DyeColor.BLACK, patterns);
        hud.frontier = new FrontierOverlay(frontierData, null);
        return hud;
    }

    public HUD() {
        this.frontierName1 = new StringWidget((Component)Component.empty(), HUD.mc.font, StringWidget.Align.Center);
        this.frontierName2 = new StringWidget((Component)Component.empty(), HUD.mc.font, StringWidget.Align.Center);
        this.frontierOwner = new StringWidget((Component)Component.empty(), HUD.mc.font, StringWidget.Align.Center);
        ClientEventHandler.subscribeDeletedFrontierEvent(this, frontierID -> this.frontierChanged());
        ClientEventHandler.subscribeNewFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedConfigEvent(this, this::configUpdated);
    }

    public int getWidth() {
        return this.hudWidth;
    }

    public int getHeight() {
        return this.hudHeight;
    }

    public boolean isInside(int x, int y) {
        return x >= this.posX && x < this.posX + this.hudWidth && y >= this.posY && y < this.posY + this.hudHeight;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void tick() {
        if (this.previewMode || HUD.mc.player == null || Config.frontierVisibility == Config.Visibility.Never) {
            return;
        }
        BlockPos currentPlayerPosition = HUD.mc.player.blockPosition();
        if (currentPlayerPosition.getX() != this.lastPlayerPosition.getX() || currentPlayerPosition.getZ() != this.lastPlayerPosition.getZ()) {
            this.lastPlayerPosition = currentPlayerPosition;
            List<FrontierOverlay> frontiers = MapFrontiersClient.getFrontiersInPosition((ResourceKey<Level>)HUD.mc.player.level().dimension(), this.lastPlayerPosition);
            if (!frontiers.isEmpty()) {
                FrontierOverlay newFrontier = frontiers.getFirst();
                if (this.frontierHash != newFrontier.getHash()) {
                    this.frontier = newFrontier;
                    this.frontierHash = newFrontier.getHash();
                    this.needUpdate = true;
                }
            } else if (this.frontier != null) {
                this.frontier = null;
                this.frontierHash = 0;
                this.needUpdate = true;
            }
        }
        if (this.frontier != null && this.frontierHash != this.frontier.getHash()) {
            this.frontierHash = this.frontier.getHash();
            this.needUpdate = true;
        }
    }

    public void configUpdated() {
        if (this.previewMode) {
            this.updateData();
        } else {
            this.needUpdate = true;
        }
    }

    public void frontierChanged() {
        if (this.previewMode) {
            return;
        }
        List<FrontierOverlay> frontiers = MapFrontiersClient.getFrontiersInPosition((ResourceKey<Level>)HUD.mc.player.level().dimension(), this.lastPlayerPosition);
        if (!frontiers.isEmpty()) {
            FrontierOverlay newFrontier = frontiers.getFirst();
            if (this.frontierHash != newFrontier.getHash()) {
                this.frontier = newFrontier;
                this.frontierHash = newFrontier.getHash();
                this.needUpdate = true;
            }
        } else if (this.frontier != null) {
            this.frontier = null;
            this.frontierHash = 0;
            this.needUpdate = true;
        }
    }

    public void drawInGameHUD(GuiGraphics graphics, float partialTicks) {
        if (this.previewMode) {
            return;
        }
        if (HUD.mc.screen != null && !(HUD.mc.screen instanceof ChatScreen)) {
            return;
        }
        if (this.frontier == null) {
            return;
        }
        if (!Config.hudEnabled) {
            return;
        }
        this.draw(graphics, partialTicks);
    }

    public void draw(GuiGraphics graphics, float partialTicks) {
        if (this.displayWidth != mc.getWindow().getWidth() || this.displayHeight != mc.getWindow().getHeight()) {
            this.needUpdate = true;
        }
        if ((Config.hudAnchor == Config.HUDAnchor.Minimap || Config.hudAnchor == Config.HUDAnchor.MinimapHorizontal || Config.hudAnchor == Config.HUDAnchor.MinimapVertical) && Services.JOURNEYMAP.minimapPropertiesChanged()) {
            this.needUpdate = true;
        }
        if (this.needUpdate) {
            this.needUpdate = false;
            this.updateData();
        }
        if (this.slots.isEmpty()) {
            return;
        }
        float factor = (float)mc.getWindow().getGuiScale();
        int frameColor = Services.JOURNEYMAP.minimapLabelBackgroundColor();
        int textNameColor = Services.JOURNEYMAP.minimapLabelHighlightColor();
        int textOwnerColor = Services.JOURNEYMAP.minimapLabelForegroundColor();
        graphics.pose().pushPose();
        graphics.pose().scale(1.0f / factor, 1.0f / factor, 1.0f);
        graphics.pose().translate(0.0, 0.0, -100.0);
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.drawName(graphics, frameColor, textNameColor, partialTicks);
                    break;
                }
                case Owner: {
                    this.drawOwner(graphics, frameColor, textOwnerColor, partialTicks);
                    break;
                }
                case Banner: {
                    this.drawBanner(graphics, frameColor);
                    break;
                }
            }
        }
        graphics.pose().popPose();
    }

    private void drawName(GuiGraphics graphics, int frameColor, int textColor, float partialTicks) {
        graphics.fill(this.posX, this.posY + this.nameOffsetY, this.posX + this.hudWidth, this.posY + this.nameOffsetY + 24 * this.textScale, frameColor);
        this.frontierName1.setColor(textColor);
        this.frontierName2.setColor(textColor);
        this.frontierName1.render(graphics, 0, 0, partialTicks);
        this.frontierName2.render(graphics, 0, 0, partialTicks);
    }

    private void drawOwner(GuiGraphics graphics, int frameColor, int textColor, float partialTicks) {
        graphics.fill(this.posX, this.posY + this.ownerOffsetY, this.posX + this.hudWidth, this.posY + this.ownerOffsetY + 12 * this.textScale, frameColor);
        this.frontierOwner.setColor(textColor);
        this.frontierOwner.render(graphics, 0, 0, partialTicks);
    }

    private void drawBanner(GuiGraphics graphics, int frameColor) {
        int bannerWidth = 20;
        int bannerHeight = 40;
        graphics.fill(this.posX + (this.hudWidth - bannerWidth * this.bannerScale) / 2 - 2, this.posY + this.bannerOffsetY, this.posX + (this.hudWidth + bannerWidth * this.bannerScale) / 2 + 2, this.posY + this.bannerOffsetY + 4 + bannerHeight * this.bannerScale, frameColor);
        this.frontier.getBannerRenderer().renderBanner(graphics, this.posX + this.hudWidth / 2, this.posY + this.bannerOffsetY + 2, this.bannerScale);
    }

    private void updateData() {
        String owner;
        this.displayWidth = mc.getWindow().getWidth();
        this.displayHeight = mc.getWindow().getHeight();
        this.slots.clear();
        if (this.frontier == null) {
            return;
        }
        this.addSlot(Config.hudSlot1);
        this.addSlot(Config.hudSlot2);
        this.addSlot(Config.hudSlot3);
        if (this.slots.isEmpty()) {
            return;
        }
        this.hudWidth = 0;
        this.hudHeight = 0;
        this.bannerScale = Config.hudBannerSize;
        this.textScale = Services.JOURNEYMAP.getMinimapFontScale();
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    int name1Width = HUD.mc.font.width(this.frontier.getName1()) + 3;
                    int name2Width = HUD.mc.font.width(this.frontier.getName2()) + 3;
                    int nameWidth = Math.max(name1Width, name2Width) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, nameWidth);
                    this.hudHeight += 24 * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    int ownerWidth = (HUD.mc.font.width(owner) + 3) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, ownerWidth);
                    this.hudHeight += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    this.hudWidth = Math.max(this.hudWidth, 20 * this.bannerScale + 4);
                    this.hudHeight += 40 * this.bannerScale + 4;
                    break;
                }
            }
        }
        Config.Point anchorPos = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPos = Config.getHUDOrigin(Config.hudAnchor, this.hudWidth, this.hudHeight);
        this.posX = anchorPos.x - originPos.x + Config.hudXPosition;
        this.posY = anchorPos.y - originPos.y + Config.hudYPosition;
        int offsetY = 0;
        this.nameOffsetY = 0;
        this.ownerOffsetY = 0;
        this.bannerOffsetY = 0;
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.nameOffsetY = offsetY;
                    this.frontierName1.setX(this.posX + this.hudWidth / 2);
                    this.frontierName1.setY(this.posY + this.nameOffsetY + 2 * this.textScale);
                    this.frontierName1.setScale(this.textScale);
                    this.frontierName1.setMessage((Component)Component.literal((String)this.frontier.getName1()));
                    this.frontierName2.setX(this.posX + this.hudWidth / 2);
                    this.frontierName2.setY(this.posY + this.nameOffsetY + 14 * this.textScale);
                    this.frontierName2.setScale(this.textScale);
                    this.frontierName2.setMessage((Component)Component.literal((String)this.frontier.getName2()));
                    offsetY += 24 * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    this.ownerOffsetY = offsetY;
                    this.frontierOwner.setX(this.posX + this.hudWidth / 2);
                    this.frontierOwner.setY(this.posY + this.ownerOffsetY + 2);
                    this.frontierOwner.setScale(this.textScale);
                    this.frontierOwner.setMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.ITALIC) + owner)));
                    offsetY += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    this.bannerOffsetY = offsetY;
                    offsetY += 40 * this.bannerScale + 4;
                    break;
                }
            }
        }
    }

    private String getOwnerString() {
        Object ownerString = "";
        if (!StringUtils.isBlank((CharSequence)this.frontier.getOwner().username)) {
            ownerString = this.frontier.getOwner().username;
        } else if (this.frontier.getOwner().uuid != null) {
            ownerString = this.frontier.getOwner().uuid.toString();
            ownerString = ((String)ownerString).substring(0, 8) + "...";
        }
        return ownerString;
    }

    private void addSlot(Config.HUDSlot slot) {
        if (slot == Config.HUDSlot.Name) {
            if (this.frontier.isNamed()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Owner) {
            if (!this.frontier.getOwner().isEmpty()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Banner && this.frontier.getBannerRenderer().hasBanner()) {
            this.slots.add(slot);
        }
    }
}

