/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.FullscreenMap;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.FrontierListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.RadioListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierInfo;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ModSettings;
import games.alejandrocoria.mapfrontiers.client.gui.screen.NewFrontier;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class FrontierList
extends AutoScaledScreen {
    private static final Component titleLabel = Component.translatable((String)"mapfrontiers.title_frontiers");
    private static final Component resetFiltersLabel = Component.translatable((String)"mapfrontiers.reset_filters");
    private static final Component filterTypeLabel = Component.translatable((String)"mapfrontiers.filter_type");
    private static final Component filterOwnerLabel = Component.translatable((String)"mapfrontiers.filter_owner");
    private static final Component filterDimensionLabel = Component.translatable((String)"mapfrontiers.filter_dimension");
    private static final Component configAllLabel = Component.translatable((String)"mapfrontiers.config.All");
    private static final Component configCurrentLabel = Component.translatable((String)"mapfrontiers.config.Current");
    private static final Component overworldLabel = Component.literal((String)"minecraft:overworld");
    private static final Component theNetherLabel = Component.literal((String)"minecraft:the_nether");
    private static final Component theEndLabel = Component.literal((String)"minecraft:the_end");
    private static final Component createLabel = Component.translatable((String)"mapfrontiers.create");
    private static final Component infoLabel = Component.translatable((String)"mapfrontiers.info");
    private static final Component deleteLabel = Component.translatable((String)"mapfrontiers.delete");
    private static final Component hideLabel = Component.translatable((String)"mapfrontiers.hide");
    private static final Component settingsLabel = Component.translatable((String)"mapfrontiers.settings");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private final IClientAPI jmAPI;
    private final FullscreenMap fullscreenMap;
    private ScrollBox frontiers;
    private ScrollBox filterType;
    private ScrollBox filterOwner;
    private ScrollBox filterDimension;
    private SimpleButton buttonResetFilters;
    private SimpleButton buttonCreate;
    private SimpleButton buttonInfo;
    private SimpleButton buttonDelete;
    private SimpleButton buttonVisible;
    private SimpleButton buttonSettings;
    private SimpleButton buttonDone;

    public FrontierList(IClientAPI jmAPI, FullscreenMap fullscreenMap) {
        super(titleLabel, 778, 302);
        this.jmAPI = jmAPI;
        this.fullscreenMap = fullscreenMap;
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeNewFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> this.updateButtons());
    }

    @Override
    public void initScreen() {
        GridLayout mainLayout = new GridLayout().spacing(8);
        this.content.addChild((LayoutElement)mainLayout);
        LayoutSettings leftColumnSettings = LayoutSettings.defaults().alignHorizontallyRight();
        LayoutSettings rightColumnSettings = LayoutSettings.defaults().alignHorizontallyLeft();
        this.frontiers = new ScrollBox(this.actualHeight - 100, 450, 24);
        this.frontiers.setElementDeletedCallback(element -> this.updateButtons());
        this.frontiers.setElementClickedCallback(element -> {
            FrontierOverlay frontier = ((FrontierListElement)element).getFrontier();
            this.fullscreenMap.selectFrontier(frontier);
            this.updateButtons();
        });
        mainLayout.addChild((LayoutElement)this.frontiers, 0, 0, leftColumnSettings);
        LinearLayout rightColumn = LinearLayout.vertical().spacing(2);
        rightColumn.defaultCellSetting().alignHorizontallyLeft();
        mainLayout.addChild((LayoutElement)rightColumn, 0, 1, rightColumnSettings);
        this.buttonResetFilters = (SimpleButton)rightColumn.addChild((LayoutElement)new SimpleButton(this.font, 110, resetFiltersLabel, b -> {
            Config.filterFrontierType = Config.FilterFrontierType.All;
            this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
            Config.filterFrontierOwner = Config.FilterFrontierOwner.All;
            this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
            this.updateFrontiers();
            this.updateButtons();
        }));
        rightColumn.addChild((LayoutElement)SpacerElement.height((int)4));
        rightColumn.addChild((LayoutElement)new StringWidget(filterTypeLabel, this.font).setColor(-4144960));
        this.filterType = new ScrollBox(52, 200, 16);
        this.filterType.addElement(new RadioListElement(this.font, Config.getTranslatedEnum(Config.FilterFrontierType.All), Config.FilterFrontierType.All.ordinal()));
        this.filterType.addElement(new RadioListElement(this.font, Config.getTranslatedEnum(Config.FilterFrontierType.Global), Config.FilterFrontierType.Global.ordinal()));
        this.filterType.addElement(new RadioListElement(this.font, Config.getTranslatedEnum(Config.FilterFrontierType.Personal), Config.FilterFrontierType.Personal.ordinal()));
        this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
        this.filterType.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierType = Config.FilterFrontierType.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        rightColumn.addChild((LayoutElement)this.filterType);
        rightColumn.addChild((LayoutElement)SpacerElement.height((int)4));
        rightColumn.addChild((LayoutElement)new StringWidget(filterOwnerLabel, this.font).setColor(-4144960));
        this.filterOwner = new ScrollBox(52, 200, 16);
        this.filterOwner.addElement(new RadioListElement(this.font, Config.getTranslatedEnum(Config.FilterFrontierOwner.All), Config.FilterFrontierOwner.All.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.font, Config.getTranslatedEnum(Config.FilterFrontierOwner.You), Config.FilterFrontierOwner.You.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.font, Config.getTranslatedEnum(Config.FilterFrontierOwner.Others), Config.FilterFrontierOwner.Others.ordinal()));
        this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
        this.filterOwner.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierOwner = Config.FilterFrontierOwner.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        rightColumn.addChild((LayoutElement)this.filterOwner);
        rightColumn.addChild((LayoutElement)SpacerElement.height((int)4));
        rightColumn.addChild((LayoutElement)new StringWidget(filterDimensionLabel, this.font).setColor(-4144960));
        this.filterDimension = new ScrollBox(this.actualHeight - 274, 200, 16);
        this.filterDimension.addElement(new RadioListElement(this.font, configAllLabel, "all".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.font, configCurrentLabel, "current".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.font, overworldLabel, "minecraft:overworld".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.font, theNetherLabel, "minecraft:the_nether".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.font, theEndLabel, "minecraft:the_end".hashCode()));
        this.addDimensionsToFilter();
        this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        this.filterDimension.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierDimension = selected == "all".hashCode() ? "all" : (selected == "current".hashCode() ? "current" : this.getDimensionFromHash(selected));
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        if (this.filterDimension.getSelectedElement() == null) {
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        }
        rightColumn.addChild((LayoutElement)this.filterDimension);
        this.buttonCreate = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 110, createLabel, b -> new NewFrontier(this.jmAPI, this.minecraft.player.blockPosition()).display()));
        this.buttonInfo = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 110, infoLabel, b -> {
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            new FrontierInfo(this.jmAPI, frontier).display();
        }));
        this.buttonDelete = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 110, deleteLabel, b -> {
            if (Config.askConfirmationFrontierDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_frontier_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationFrontierDelete = false;
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.deleteSelectedFrontier();
                }).display();
            } else {
                this.deleteSelectedFrontier();
            }
        }));
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonVisible = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 110, hideLabel, b -> {
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            frontier.toggleVisibility(FrontierData.VisibilityData.Visibility.Frontier);
            FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
            frontierManager.clientUpdateFrontier(frontier);
            this.updateButtons();
        }));
        this.buttonSettings = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 110, settingsLabel, b -> new ModSettings(true).display()));
        this.buttonDone = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 110, doneLabel, b -> this.onClose()));
        this.updateFrontiers();
        if (this.fullscreenMap.getSelected() != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(this.fullscreenMap.getSelected().getId()));
        }
        this.updateButtons();
    }

    @Override
    public void repositionElements() {
        this.frontiers.setSize(450, this.actualHeight - 100);
        this.filterDimension.setSize(200, this.actualHeight - 269);
        super.repositionElements();
        this.content.setPosition((this.actualWidth - this.content.getWidth()) / 2, 60);
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.actualWidth - 60, this.actualHeight - 60);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiEventListener w : this.children()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void onClose() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.onClose();
    }

    private void deleteSelectedFrontier() {
        FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
        frontierManager.clientDeleteFrontier(frontier);
        this.frontiers.removeElement(this.frontiers.getSelectedElement());
        this.updateButtons();
    }

    private void addDimensionsToFilter() {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.equals("minecraft:overworld") || dimension.equals("minecraft:the_nether") || dimension.equals("minecraft:the_end")) continue;
            this.filterDimension.addElement(new RadioListElement(this.font, (Component)Component.literal((String)dimension), dimension.hashCode()));
        }
    }

    private String getDimensionFromHash(int hash) {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.hashCode() != hash) continue;
            return dimension;
        }
        return "";
    }

    private void updateFrontiers() {
        FrontierOverlay selectedFrontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        UUID frontierID = selectedFrontier == null ? null : selectedFrontier.getId();
        this.frontiers.removeAll();
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Personal) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers().values()) {
                for (FrontierOverlay frontier : dimension) {
                    if (!this.checkFilterOwner(frontier) || !this.checkFilterDimension(frontier)) continue;
                    this.frontiers.addElement(new FrontierListElement(this.font, frontier));
                }
            }
        }
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Global) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers().values()) {
                for (FrontierOverlay frontier : dimension) {
                    if (!this.checkFilterOwner(frontier) || !this.checkFilterDimension(frontier)) continue;
                    this.frontiers.addElement(new FrontierListElement(this.font, frontier));
                }
            }
        }
        if (frontierID != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(frontierID));
        }
    }

    private boolean checkFilterOwner(FrontierOverlay frontier) {
        boolean ownerIsPlayer;
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.All) {
            return true;
        }
        boolean bl = ownerIsPlayer = this.minecraft.player != null && frontier.getOwner().equals(new SettingsUser((Player)this.minecraft.player));
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.You) {
            return ownerIsPlayer;
        }
        return !ownerIsPlayer;
    }

    private boolean checkFilterDimension(FrontierOverlay frontier) {
        if (Config.filterFrontierDimension.equals("all")) {
            return true;
        }
        String dimension = Config.filterFrontierDimension;
        if (dimension.equals("current") && this.minecraft.level != null) {
            dimension = this.minecraft.level.dimension().location().toString();
        }
        return frontier.getDimension().location().toString().equals(dimension);
    }

    private void updateButtons() {
        if (this.minecraft.player == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((Player)this.minecraft.player);
        FrontierOverlay frontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, frontier, playerUser);
        this.buttonInfo.active = this.frontiers.getSelectedElement() != null;
        this.buttonDelete.active = actions.canDelete;
        this.buttonVisible.active = actions.canUpdate;
        if (frontier != null && ((FrontierData)frontier).getVisibility(FrontierData.VisibilityData.Visibility.Frontier)) {
            this.buttonVisible.setMessage((Component)Component.translatable((String)"mapfrontiers.hide"));
        } else {
            this.buttonVisible.setMessage((Component)Component.translatable((String)"mapfrontiers.show"));
        }
    }
}

