/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierCreated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class PacketChangeFrontierToGlobal {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"packet_change_frontier_to_global");
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketChangeFrontierToGlobal> STREAM_CODEC = StreamCodec.ofMember(PacketChangeFrontierToGlobal::encode, PacketChangeFrontierToGlobal::new);
    private UUID frontierID;
    private Date modified;

    public PacketChangeFrontierToGlobal(UUID frontierID, @Nullable Date modified) {
        this.frontierID = frontierID;
        this.modified = modified;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public PacketChangeFrontierToGlobal(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
                if (buf.readBoolean()) {
                    this.modified = new Date(buf.readLong());
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketChangeFrontierToGlobal: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
            if (this.modified == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeLong(this.modified.getTime());
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketChangeFrontierToGlobal: %s", t));
        }
    }

    public static void handle(PacketContext<PacketChangeFrontierToGlobal> ctx) {
        PacketChangeFrontierToGlobal message = (PacketChangeFrontierToGlobal)ctx.message();
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerPlayer player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.server;
            SettingsUser playerUser = new SettingsUser((Player)player);
            FrontierData frontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (frontier != null) {
                if (frontier.getPersonal() && frontier.getOwner().equals(playerUser)) {
                    boolean changed;
                    ArrayList<ServerPlayer> relevantPlayers = new ArrayList<ServerPlayer>();
                    relevantPlayers.add(player);
                    if (frontier.getUsersShared() != null) {
                        for (SettingsUserShared userShared : frontier.getUsersShared()) {
                            ServerPlayer otherPlayer;
                            if (userShared.isPending() || (otherPlayer = server.getPlayerList().getPlayer(userShared.getUser().uuid)) == null) continue;
                            relevantPlayers.add(otherPlayer);
                        }
                    }
                    if (changed = FrontiersManager.instance.changePersonalFrontierToGlobal(frontier.getOwner(), frontier.getDimension(), frontier.getId())) {
                        PacketHandler.sendTo(new PacketChangeFrontierToGlobal(frontier.getId(), frontier.getModified()), relevantPlayers);
                        PacketHandler.sendToAllExcept(new PacketFrontierCreated(frontier, player.getId()), server, relevantPlayers);
                    }
                    return;
                }
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        } else {
            FrontiersOverlayManager personalManager = MapFrontiersClient.getFrontiersOverlayManager(true);
            FrontierOverlay frontierOverlay = personalManager.deleteFrontier(message.frontierID);
            frontierOverlay.setPersonal(false);
            if (message.modified != null) {
                frontierOverlay.setModified(message.modified);
            }
            frontierOverlay.removeAllUserShared();
            frontierOverlay.removeChanges();
            MapFrontiersClient.getFrontiersOverlayManager(false).addFrontier(frontierOverlay);
            ClientEventHandler.postUpdatedFrontierEvent(frontierOverlay, -1);
            frontierOverlay.updateOverlay();
        }
    }
}

