/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1144;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8016;
import net.minecraft.class_8023;

@ParametersAreNonnullByDefault
public class ShapeChunkButtons
extends AbstractWidgetNoNarration {
    private static final class_2960 texture = class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private int size;
    private final StringWidget labelShapes;
    private final Consumer<ShapeChunkButtons> callbackShapeUpdated;

    public ShapeChunkButtons(class_327 font, int selected, Consumer<ShapeChunkButtons> callbackShapeUpdated) {
        super(0, 0, 214, 122, (class_2561)class_2561.method_43473());
        this.selected = selected;
        this.labelShapes = new StringWidget((class_2561)class_2561.method_43471((String)"mapfrontiers.initial_shape"), font, StringWidget.Align.Center).setColor(-1);
        this.callbackShapeUpdated = callbackShapeUpdated;
    }

    public void setSize(int size) {
        this.size = Math.min(Math.max(size, 1), 32);
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2 || this.selected == 7) {
            return ShapeMeasure.None;
        }
        if (this.selected < 5) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Length;
    }

    public int getChunkCount() {
        int chunks;
        switch (this.selected) {
            case 1: {
                chunks = 1;
                break;
            }
            case 2: {
                chunks = this.size * this.size;
                break;
            }
            case 3: {
                chunks = Math.max(1, (this.size - 1) * 4);
                break;
            }
            case 4: {
                chunks = (this.size * this.size + 1) / 2;
                if (this.size % 2 != 0) break;
                chunks += this.size;
                break;
            }
            case 5: 
            case 6: {
                chunks = this.size;
                break;
            }
            case 7: {
                chunks = 1024;
                break;
            }
            default: {
                chunks = 0;
            }
        }
        return chunks;
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.labelShapes.method_46421(x + 107);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.labelShapes.method_46419(y + 2);
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigationEvent) {
        return null;
    }

    public void method_25348(double mouseX, double mouseY) {
        double col = (mouseX - (double)this.method_46426() + 3.0) / 55.0;
        double row = (mouseY - (double)this.method_46427() - 15.0) / 55.0;
        if (col >= 0.0 && col < 4.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 4;
            this.callbackShapeUpdated.accept(this);
        }
    }

    public void method_25354(class_1144 soundHandlerIn) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int col = 0;
        int row = 0;
        for (int i = 0; i < 8; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.method_25290(class_1921::method_62277, texture, this.method_46426() + col * 55, this.method_46427() + row * 55 + 18, (float)(texX + 588), (float)texY, 49, 49, 980, 98);
            if (++col != 4) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Length;

    }
}

