/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@ParametersAreNonnullByDefault
public class PacketPersonalFrontier {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_personal_frontier");
    public static final class_9139<class_9129, PacketPersonalFrontier> STREAM_CODEC = class_9139.method_56438(PacketPersonalFrontier::encode, PacketPersonalFrontier::new);
    private final FrontierData frontier;

    public PacketPersonalFrontier(FrontierData frontier) {
        this.frontier = frontier;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketPersonalFrontier(class_2540 buf) {
        this.frontier = new FrontierData();
        try {
            if (buf.readableBytes() > 1) {
                this.frontier.fromBytes(buf);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketPersonalFrontier: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            this.frontier.toBytes(buf, false);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketPersonalFrontier: %s", t));
        }
    }

    public static void handle(PacketContext<PacketPersonalFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketPersonalFrontier message = (PacketPersonalFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontier.getId());
            if (currentFrontier == null && message.frontier.getPersonal() && message.frontier.getOwner().equals(playerUser)) {
                message.frontier.removeAllUserShared();
                message.frontier.removeChange(FrontierData.Change.Shared);
                FrontiersManager.instance.addPersonalFrontier(message.frontier);
            }
        }
    }
}

