/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import java.awt.Color;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

@ParametersAreNonnullByDefault
public class ColorPicker
extends AbstractWidgetNoNarration {
    private static final Identifier texture = Identifier.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/color_picker.png");
    private static final int textureSizeX = 274;
    private static final int textureSizeY = 134;
    private double hsX;
    private double hsY;
    private double v;
    private int color;
    private int colorFullBrightness;
    private boolean hsGrabbed = false;
    private boolean vGrabbed = false;
    private final BiConsumer<Integer, Boolean> callbackColorUpdated;

    public ColorPicker(int color, BiConsumer<Integer, Boolean> callbackColorUpdated) {
        super(0, 0, 141, 128, (Component)Component.empty());
        this.callbackColorUpdated = callbackColorUpdated;
        this.setColor(color);
    }

    public void setColor(int newColor) {
        this.color = newColor;
        float[] hsv = Color.RGBtoHSB((newColor & 0xFF0000) >> 16, (newColor & 0xFF00) >> 8, newColor & 0xFF, null);
        double angle = (double)hsv[0] * Math.PI * 2.0;
        double dist = (double)hsv[1] * 64.0;
        this.hsX = dist * Math.cos(angle);
        this.hsY = dist * Math.sin(angle);
        this.v = 127.5 - (double)hsv[2] * 127.5;
        this.colorFullBrightness = Color.HSBtoRGB(hsv[0], hsv[1], 1.0f);
    }

    public int getColor() {
        return this.color;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigationEvent) {
        return null;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        this.hsGrabbed = false;
        this.vGrabbed = false;
        this.updateMouse(event.x(), event.y(), false);
        return true;
    }

    public void onRelease(MouseButtonEvent event) {
        if (!this.hsGrabbed && !this.vGrabbed) {
            return;
        }
        this.updateMouse(event.x(), event.y(), false);
        this.hsGrabbed = false;
        this.vGrabbed = false;
    }

    public void onDrag(MouseButtonEvent event, double dragX, double dragY) {
        if (!this.hsGrabbed && !this.vGrabbed) {
            return;
        }
        this.updateMouse(event.x(), event.y(), true);
    }

    public void playDownSound(SoundManager soundHandlerIn) {
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int texX = this.active ? 0 : 137;
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX(), this.getY(), (float)texX, 0.0f, 128, 128, 274, 134);
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX() + 132, this.getY(), (float)(texX + 129), 0.0f, 8, 128, 274, 134, this.active ? this.colorFullBrightness : -1);
        graphics.fill(this.getX() + (int)this.hsX + 64, this.getY() + (int)this.hsY + 64, this.getX() + (int)this.hsX + 65, this.getY() + (int)this.hsY + 65, this.active ? -1 : this.colorFullBrightness);
        graphics.fill(this.getX() + 131, this.getY() + (int)this.v, this.getX() + 139, this.getY() + (int)this.v + 1, this.color);
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX() + (int)this.hsX + 64 - 2, this.getY() + (int)this.hsY + 64 - 2, (float)texX, 129.0f, 5, 5, 274, 134);
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX() + 131, this.getY() + (int)this.v - 2, (float)(texX + 6), 129.0f, 10, 5, 274, 134);
    }

    private void updateMouse(double mouseX, double mouseY, boolean dragging) {
        double localY;
        double localX;
        if (!this.vGrabbed) {
            localX = mouseX - (double)(this.getX() + 64);
            double dist = Math.sqrt(localX * localX + (localY = mouseY - (double)(this.getY() + 64)) * localY);
            if (dist < 66.0) {
                this.hsGrabbed = true;
            }
            if (this.hsGrabbed) {
                if (dist >= 64.0) {
                    localX = localX / dist * 64.0;
                    localY = localY / dist * 64.0;
                }
                this.hsX = localX;
                this.hsY = localY;
                this.updateColor(dragging);
                return;
            }
        }
        if (!this.hsGrabbed) {
            localX = mouseX - (double)(this.getX() + 132);
            localY = mouseY - (double)this.getY();
            if (localX >= 0.0 && localX < 8.0 && localY >= 0.0 && localY < 128.0) {
                this.vGrabbed = true;
            }
            if (this.vGrabbed) {
                this.v = Math.max(0.0, Math.min(localY, 127.99));
                this.updateColor(dragging);
            }
        }
    }

    private void updateColor(boolean dragging) {
        double dist = Math.sqrt(this.hsX * this.hsX + this.hsY * this.hsY);
        double hue = Math.atan2(this.hsY, this.hsX) / (Math.PI * 2);
        double sat = dist / 64.0;
        double lum = 1.0 - this.v / 128.0;
        this.color = Color.HSBtoRGB((float)hue, (float)sat, (float)lum);
        this.colorFullBrightness = Color.HSBtoRGB((float)hue, (float)sat, 1.0f);
        this.callbackColorUpdated.accept(this.color, dragging);
    }
}

