/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.phys.Vec2;

@ParametersAreNonnullByDefault
public class ShapeVertexButtons
extends AbstractWidgetNoNarration {
    private static final int[] vertexCount = new int[]{0, 1, 3, 3, 3, 3, 4, 4, 6, 6, 8, 16};
    private static final double[] vertexAngle = new double[]{0.0, 0.0, -90.0, 0.0, 90.0, 180.0, 45.0, 0.0, 30.0, 0.0, 22.5, 0.0};
    private static final Identifier texture = Identifier.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private final StringWidget labelShapes;
    private final Consumer<ShapeVertexButtons> callbackShapeUpdated;

    public ShapeVertexButtons(Font font, int selected, Consumer<ShapeVertexButtons> callbackShapeUpdated) {
        super(0, 0, 324, 122, (Component)Component.empty());
        this.selected = selected;
        this.labelShapes = new StringWidget((Component)Component.translatable((String)"mapfrontiers.initial_shape"), font, StringWidget.Align.Center).setColor(-1);
        this.callbackShapeUpdated = callbackShapeUpdated;
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2) {
            return ShapeMeasure.None;
        }
        if (this.selected < 7) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Radius;
    }

    public int getVertexCount() {
        return vertexCount[this.selected];
    }

    public List<Vec2> getVertices() {
        return this.getVertices(vertexCount[this.selected], vertexAngle[this.selected] / 180.0 * Math.PI);
    }

    public List<Vec2> getVertices(int count) {
        return this.getVertices(count, 0.0);
    }

    private List<Vec2> getVertices(int count, double angleOffset) {
        if (count == 0) {
            return null;
        }
        ArrayList<Vec2> vertices = new ArrayList<Vec2>();
        if (count == 1) {
            vertices.add(Vec2.ZERO);
            return vertices;
        }
        for (int i = 0; i < count; ++i) {
            double vertexAngle = Math.PI * 2 / (double)count * (double)i + angleOffset;
            vertices.add(new Vec2((float)Math.cos(vertexAngle), (float)Math.sin(vertexAngle)));
        }
        return vertices;
    }

    public void setX(int x) {
        super.setX(x);
        this.labelShapes.setX(x + 162);
    }

    public void setY(int y) {
        super.setY(y);
        this.labelShapes.setY(y + 2);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigationEvent) {
        return null;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        double col = (event.x() - (double)this.getX() + 3.0) / 55.0;
        double row = (event.y() - (double)this.getY() - 15.0) / 55.0;
        if (col >= 0.0 && col < 6.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 6;
            this.callbackShapeUpdated.accept(this);
        }
        return true;
    }

    public void playDownSound(SoundManager soundHandlerIn) {
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int col = 0;
        int row = 0;
        for (int i = 0; i < 12; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX() + col * 55, this.getY() + row * 55 + 18, (float)texX, (float)texY, 49, 49, 980, 98);
            if (++col != 6) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.render(graphics, mouseX, mouseY, partialTicks);
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Radius;

    }
}

