/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import com.mojang.logging.annotations.MethodsReturnNonnullByDefault;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.CheckBoxButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsGroup;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GroupActionElement
extends ScrollBox.ScrollElement {
    private final Font font;
    private final SettingsGroup group;
    private final CheckBoxButton createFrontier;
    private final CheckBoxButton deleteFrontier;
    private final CheckBoxButton updateFrontier;
    private final CheckBoxButton updateSettings;
    private final CheckBoxButton personalFrontier;
    private final List<GuiEventListener> children;

    public GroupActionElement(Font font, SettingsGroup group, ActionChangedConsumer actionChangedCallback) {
        this(font, group, false, actionChangedCallback);
    }

    public GroupActionElement(Font font, SettingsGroup group, boolean ownersGroup, ActionChangedConsumer actionChangedCallback) {
        super(430, 16);
        this.font = font;
        this.group = group;
        this.createFrontier = new CheckBoxButton(group.hasAction(FrontierSettings.Action.CreateGlobalFrontier), b -> actionChangedCallback.accept(group, FrontierSettings.Action.CreateGlobalFrontier, b.isChecked()));
        this.createFrontier.active = !ownersGroup;
        this.deleteFrontier = new CheckBoxButton(group.hasAction(FrontierSettings.Action.DeleteGlobalFrontier), b -> actionChangedCallback.accept(group, FrontierSettings.Action.DeleteGlobalFrontier, b.isChecked()));
        this.updateFrontier = new CheckBoxButton(group.hasAction(FrontierSettings.Action.UpdateGlobalFrontier), b -> actionChangedCallback.accept(group, FrontierSettings.Action.UpdateGlobalFrontier, b.isChecked()));
        this.updateSettings = new CheckBoxButton(group.hasAction(FrontierSettings.Action.UpdateSettings), b -> actionChangedCallback.accept(group, FrontierSettings.Action.UpdateSettings, b.isChecked()));
        this.updateSettings.active = !ownersGroup;
        this.personalFrontier = new CheckBoxButton(group.hasAction(FrontierSettings.Action.SharePersonalFrontier), b -> actionChangedCallback.accept(group, FrontierSettings.Action.SharePersonalFrontier, b.isChecked()));
        this.personalFrontier.active = !ownersGroup;
        this.children = List.of(this.createFrontier, this.deleteFrontier, this.updateFrontier, this.updateSettings, this.personalFrontier);
    }

    @Override
    protected void setX(int x) {
        super.setX(x);
        this.createFrontier.setX(x + 154);
        this.deleteFrontier.setX(x + 214);
        this.updateFrontier.setX(x + 274);
        this.updateSettings.setX(x + 334);
        this.personalFrontier.setX(x + 394);
    }

    @Override
    protected void setY(int y) {
        super.setY(y);
        this.createFrontier.setY(y + 2);
        this.deleteFrontier.setY(y + 2);
        this.updateFrontier.setY(y + 2);
        this.updateSettings.setY(y + 2);
        this.personalFrontier.setY(y + 2);
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        String text;
        if (this.isHovered) {
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, -1607454672);
        }
        if ((text = this.group.getName()).isEmpty()) {
            text = I18n.get((String)"mapfrontiers.unnamed", (Object[])new Object[]{ChatFormatting.ITALIC});
        }
        graphics.drawString(this.font, text, this.x + 4, this.y + 4, -1);
        this.createFrontier.render(graphics, mouseX, mouseY, partialTicks);
        this.deleteFrontier.render(graphics, mouseX, mouseY, partialTicks);
        this.updateFrontier.render(graphics, mouseX, mouseY, partialTicks);
        this.updateSettings.render(graphics, mouseX, mouseY, partialTicks);
        this.personalFrontier.render(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected ScrollBox.ScrollElement.Action mousePressed(MouseButtonEvent event, boolean doubleClick) {
        block1: {
            if (!this.visible || !this.isHovered) break block1;
            for (GuiEventListener checkBox : this.children) {
                if (checkBox.mouseClicked(event, doubleClick)) break;
            }
        }
        return ScrollBox.ScrollElement.Action.None;
    }

    @Override
    public List<GuiEventListener> children() {
        return this.children;
    }

    @FunctionalInterface
    public static interface ActionChangedConsumer {
        public void accept(SettingsGroup var1, FrontierSettings.Action var2, boolean var3);
    }
}

