/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import com.mojang.logging.annotations.MethodsReturnNonnullByDefault;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.CheckBoxButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class UserSharedElement
extends ScrollBox.ScrollElement {
    private final Font font;
    private final SettingsUserShared user;
    private final CheckBoxButton updateFrontier;
    private final CheckBoxButton updateSettings;
    private IconButton buttonDelete;
    private final List<GuiEventListener> children;
    private final boolean enabled;
    private int pingBar = 0;

    public UserSharedElement(Font font, SettingsUserShared user, boolean enabled, boolean removable, ActionChangedConsumer actionChangedCallback) {
        super(430, 16);
        this.font = font;
        this.user = user;
        this.updateFrontier = new CheckBoxButton(user.hasAction(SettingsUserShared.Action.UpdateFrontier), b -> actionChangedCallback.accept(user, SettingsUserShared.Action.UpdateFrontier, b.isChecked()));
        this.updateFrontier.active = enabled;
        this.updateSettings = new CheckBoxButton(user.hasAction(SettingsUserShared.Action.UpdateSettings), b -> actionChangedCallback.accept(user, SettingsUserShared.Action.UpdateSettings, b.isChecked()));
        this.updateSettings.active = enabled;
        this.enabled = enabled;
        if (removable && enabled) {
            this.buttonDelete = new IconButton(IconButton.Type.Remove, button -> {});
        }
        this.children = List.of(this.updateFrontier, this.updateSettings);
    }

    public SettingsUser getUser() {
        return this.user.getUser();
    }

    public void setPingBar(int value) {
        this.pingBar = value;
        if (this.pingBar < 0) {
            this.pingBar = 0;
        } else if (this.pingBar > 5) {
            this.pingBar = 5;
        }
    }

    @Override
    protected void setX(int x) {
        super.setX(x);
        this.updateFrontier.setX(x + 244);
        this.updateSettings.setX(x + 304);
        if (this.buttonDelete != null) {
            this.buttonDelete.setX(this.x + 413);
        }
    }

    @Override
    protected void setY(int y) {
        super.setY(y);
        this.updateFrontier.setY(y + 2);
        this.updateSettings.setY(y + 2);
        if (this.buttonDelete != null) {
            this.buttonDelete.setY(this.y + 1);
        }
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        if (this.isHovered) {
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, -1607454672);
        }
        if ((this.isHovered || focused) && this.buttonDelete != null) {
            this.buttonDelete.render(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.drawString(this.font, this.user.getUser().toString(), this.x + 16, this.y + 4, -1);
        this.updateFrontier.render(graphics, mouseX, mouseY, partialTicks);
        this.updateSettings.render(graphics, mouseX, mouseY, partialTicks);
        if (this.user.isPending()) {
            graphics.drawString(this.font, I18n.get((String)"mapfrontiers.pending", (Object[])new Object[]{ChatFormatting.ITALIC}), this.x + 350, this.y + 4, -16720640);
        }
        if (this.pingBar > 0) {
            this.drawPingLine(graphics, this.x + 3, this.y + 11, 2);
        }
        if (this.pingBar > 1) {
            this.drawPingLine(graphics, this.x + 5, this.y + 11, 3);
        }
        if (this.pingBar > 2) {
            this.drawPingLine(graphics, this.x + 7, this.y + 11, 4);
        }
        if (this.pingBar > 3) {
            this.drawPingLine(graphics, this.x + 9, this.y + 11, 5);
        }
        if (this.pingBar > 4) {
            this.drawPingLine(graphics, this.x + 11, this.y + 11, 6);
        }
    }

    private void drawPingLine(GuiGraphics graphics, int posX, int posY, int height) {
        graphics.fill(posX, posY - height, posX + 1, posY, -1);
    }

    @Override
    protected ScrollBox.ScrollElement.Action mousePressed(MouseButtonEvent event, boolean doubleClick) {
        if (this.enabled && this.visible && this.isHovered) {
            for (GuiEventListener checkBox : this.children) {
                if (!checkBox.mouseClicked(event, doubleClick)) continue;
                return ScrollBox.ScrollElement.Action.None;
            }
            if (this.buttonDelete != null && this.buttonDelete.isMouseOver(event.x(), event.y())) {
                return ScrollBox.ScrollElement.Action.Deleted;
            }
        }
        return ScrollBox.ScrollElement.Action.None;
    }

    @Override
    public List<GuiEventListener> children() {
        if (this.enabled) {
            return this.children;
        }
        return super.children();
    }

    @Override
    protected boolean canBeDeleted() {
        return true;
    }

    @FunctionalInterface
    public static interface ActionChangedConsumer {
        public void accept(SettingsUserShared var1, SettingsUserShared.Action var2, boolean var3);
    }
}

