/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.dialog;

import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

@ParametersAreNonnullByDefault
public class ConfirmationDialog
extends AutoScaledScreen {
    private final String titleKey;
    @Nullable
    private final String textKey;
    private final String confirmKey;
    private final String cancelKey;
    @Nullable
    private final String confirmAlternativeKey;
    private final Consumer<Response> callback;
    protected SimpleButton confirmButton;
    protected SimpleButton cancelButton;
    @Nullable
    protected SimpleButton confirmAlternativeButton;

    public ConfirmationDialog(String titleKey, @Nullable String textKey, String confirmKey, String cancelKey, @Nullable String confirmAlternativeKey, Consumer<Response> callback) {
        super((Component)Component.empty());
        this.titleKey = titleKey;
        this.textKey = textKey;
        this.confirmKey = confirmKey;
        this.cancelKey = cancelKey;
        this.confirmAlternativeKey = confirmAlternativeKey;
        this.callback = callback;
    }

    @Override
    protected void initScreen() {
        LinearLayout mainLayout = LinearLayout.vertical().spacing(8);
        mainLayout.defaultCellSetting().alignHorizontallyCenter();
        this.content.addChild((LayoutElement)mainLayout);
        mainLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)this.titleKey).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))), this.font).setColor(-1));
        if (this.textKey != null) {
            mainLayout.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.translatable((String)this.textKey), this.font).setCentered(true));
        }
        GridLayout buttons = new GridLayout().spacing(4);
        mainLayout.addChild((LayoutElement)buttons);
        this.confirmButton = (SimpleButton)buttons.addChild((LayoutElement)new SimpleButton(this.font, 150, (Component)Component.translatable((String)this.confirmKey), b -> {
            this.onClose();
            this.callback.accept(Response.Confirm);
        }), 0, 0);
        this.cancelButton = (SimpleButton)buttons.addChild((LayoutElement)new SimpleButton(this.font, 150, (Component)Component.translatable((String)this.cancelKey), b -> this.onClose()), 0, 1);
        if (this.confirmAlternativeKey != null) {
            this.confirmAlternativeButton = (SimpleButton)buttons.addChild((LayoutElement)new SimpleButton(this.font, 304, (Component)Component.translatable((String)this.confirmAlternativeKey), b -> {
                this.onClose();
                this.callback.accept(Response.ConfirmAlternative);
            }), 1, 0, 1, 2);
        }
    }

    protected void setInitialFocus() {
        if (this.minecraft.getLastInputType().isKeyboard()) {
            this.setInitialFocus((GuiEventListener)this.cancelButton);
        }
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.getWidth() + 20, this.content.getHeight() + 20);
    }

    public static enum Response {
        Confirm,
        ConfirmAlternative;

    }
}

