/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.mixin.GuiGraphicsAccessor;
import games.alejandrocoria.mapfrontiers.client.mixin.GuiRenderStateAccessor;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.ui.component.LayeredScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.PlainTextContents;

@ParametersAreNonnullByDefault
public abstract class AutoScaledScreen
extends LayeredScreen {
    protected float scaleFactor = 1.0f;
    private final int minWidth;
    private final int minHeight;
    protected int actualWidth;
    protected int actualHeight;
    protected LinearLayout content;
    protected LinearLayout bottomButtons;

    public AutoScaledScreen(Component title) {
        this(title, 0, 0);
    }

    public AutoScaledScreen(Component title, int minWidth, int minHeight) {
        super(title);
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    public final void init() {
        this.updateScale(this.width, this.height);
        this.content = LinearLayout.vertical();
        this.bottomButtons = LinearLayout.horizontal();
        this.initScreen();
        this.content.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.content.visitWidgets(w -> w.setTabOrderGroup(0));
        this.bottomButtons.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.bottomButtons.visitWidgets(w -> w.setTabOrderGroup(1));
        this.bottomButtons.spacing(7);
        this.repositionElements();
    }

    public void repositionElements() {
        this.content.arrangeElements();
        this.content.setPosition((this.actualWidth - this.content.getWidth()) / 2, (this.actualHeight - this.content.getHeight()) / 2);
        this.bottomButtons.arrangeElements();
        this.bottomButtons.setPosition((this.actualWidth - this.bottomButtons.getWidth()) / 2, this.actualHeight - 15 - this.bottomButtons.getHeight() / 2);
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.updateScale(width, height);
        super.resize(width, height);
    }

    private void updateScale(int width, int height) {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.minecraft, (Screen)this, this.minWidth, this.minHeight);
        this.actualWidth = (int)((float)width * this.scaleFactor);
        this.actualHeight = (int)((float)height * this.scaleFactor);
    }

    protected abstract void initScreen();

    protected void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void renderScaledScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected final void renderPopupScreenBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft.screen == this) {
            if (((GuiRenderStateAccessor)((GuiGraphicsAccessor)graphics).mapfrontiers$getGuiRenderState()).mapfrontiers$setFirstStratumAfterBlur() == Integer.MAX_VALUE) {
                graphics.blurBeforeThisStratum();
            } else {
                graphics.fill(0, 0, this.width, this.height, -1090519040);
            }
        }
    }

    protected final void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.pose().pushMatrix();
            graphics.pose().scale(1.0f / this.scaleFactor, 1.0f / this.scaleFactor);
        }
        if (this.title.getContents() != PlainTextContents.EMPTY) {
            graphics.drawCenteredString(this.font, this.title, this.actualWidth / 2, 11, -1);
        }
        this.renderScaledBackgroundScreen(graphics, mouseX, mouseY, partialTicks);
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof Renderable)) continue;
            Renderable renderable = (Renderable)child;
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderScaledScreen(graphics, mouseX, mouseY, partialTicks);
        if (this.minecraft.screen == this) {
            graphics.renderDeferredElements();
        }
        if (this.scaleFactor != 1.0f) {
            graphics.pose().popMatrix();
        }
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.input() == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        MouseButtonEvent scaledEvent = new MouseButtonEvent(event.x() * (double)this.scaleFactor, event.y() * (double)this.scaleFactor, event.buttonInfo());
        return super.mouseClicked(scaledEvent, doubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        MouseButtonEvent scaledEvent = new MouseButtonEvent(event.x() * (double)this.scaleFactor, event.y() * (double)this.scaleFactor, event.buttonInfo());
        return super.mouseReleased(scaledEvent);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hDelta, double vDelta) {
        return super.mouseScrolled(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, hDelta, vDelta);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        MouseButtonEvent scaledEvent = new MouseButtonEvent(event.x() * (double)this.scaleFactor, event.y() * (double)this.scaleFactor, event.buttonInfo());
        return super.mouseDragged(scaledEvent, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void closeAndReturnToFullscreenMap() {
        Screen screen;
        if (this.minecraft == null) {
            return;
        }
        this.onClose();
        if (this.minecraft.screen != null && (screen = this.minecraft.screen) instanceof AutoScaledScreen) {
            AutoScaledScreen autoScaledScreen = (AutoScaledScreen)screen;
            autoScaledScreen.closeAndReturnToFullscreenMap();
        }
    }

    protected void drawCenteredBoxBackground(GuiGraphics graphics, int width, int height) {
        int x1 = (this.actualWidth - width) / 2;
        int x2 = (this.actualWidth + width) / 2;
        int y1 = (this.actualHeight - height) / 2;
        int y2 = (this.actualHeight + height) / 2;
        graphics.fill(x1, y1, x2, y2, -955248624);
        graphics.hLine(x1, x2, y1, -8947849);
        graphics.hLine(x1, x2, y2, -8947849);
        graphics.vLine(x1, y1, y2, -8947849);
        graphics.vLine(x2, y1, y2, -8947849);
    }
}

