/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import com.mojang.blaze3d.platform.Window;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUDWidget;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.platform.Services;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class HUDSettings
extends AutoScaledScreen {
    private static final Component slot1Label = Config.getTranslatedName("hud.slot1");
    private static final Tooltip slot1Tooltip = Config.getTooltip("hud.slot1");
    private static final Component slot2Label = Config.getTranslatedName("hud.slot2");
    private static final Tooltip slot2Tooltip = Config.getTooltip("hud.slot2");
    private static final Component slot3Label = Config.getTranslatedName("hud.slot3");
    private static final Tooltip slot3Tooltip = Config.getTooltip("hud.slot3");
    private static final Component textSizeLabel = Config.getTranslatedName("hud.textSize");
    private static final Tooltip textSizeTooltip = Config.getTooltip("hud.textSize");
    private static final Component bannerSizeLabel = Config.getTranslatedName("hud.bannerSize");
    private static final Tooltip bannerSizeTooltip = Config.getTooltip("hud.bannerSize");
    private static final Component anchorLabel = Config.getTranslatedName("hud.anchor");
    private static final Tooltip anchorTooltip = Config.getTooltip("hud.anchor");
    private static final Component positionLabel = Component.translatable((String)"mapfrontiers.config.hud.position");
    private static final Tooltip positionTooltip = Tooltip.create((Component)Component.literal((String)"HUD position relative to anchor."));
    private static final Component positionSeparatorLabel = Component.literal((String)"x");
    private static final Component autoAdjustAnchorLabel = Config.getTranslatedName("hud.autoAdjustAnchor");
    private static final Tooltip autoAdjustAnchorTooltip = Config.getTooltip("hud.autoAdjustAnchor");
    private static final Component snapToBorderLabel = Config.getTranslatedName("hud.snapToBorder");
    private static final Tooltip snapToBorderTooltip = Config.getTooltip("hud.snapToBorder");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private static final Component onLabel = Component.translatable((String)"options.on");
    private static final Component offLabel = Component.translatable((String)"options.off");
    private HUDWidget HUDWidget;
    private OptionButton buttonSlot1;
    private OptionButton buttonSlot2;
    private OptionButton buttonSlot3;
    private TextBoxInt textTextSize;
    private TextBoxInt textBannerSize;
    private OptionButton buttonAnchor;
    private TextBoxInt textPositionX;
    private TextBoxInt textPositionY;
    private OptionButton buttonAutoAdjustAnchor;
    private OptionButton buttonSnapToBorder;
    private SimpleButton buttonDone;
    private final HUD hud = HUD.asPreview();
    private int anchorLineColor = -2236963;
    private int anchorLineColorTick = 0;
    private Screen previousScreen;

    public HUDSettings() {
        super((Component)Component.empty());
    }

    public void display() {
        super.display();
        this.previousScreen = this.backgroundScreen;
        this.backgroundScreen = null;
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        if (this.previousScreen != null) {
            this.previousScreen.resize(this.width, this.height);
        }
    }

    @Override
    public void initScreen() {
        ClientEventHandler.postUpdatedConfigEvent();
        this.HUDWidget = (HUDWidget)this.addRenderableWidget((GuiEventListener)new HUDWidget(this.hud, Services.JOURNEYMAP.isMinimapEnabled(), widget -> this.HUDUpdated()));
        GridLayout mainLayout = new GridLayout().spacing(4);
        this.content.addChild((LayoutElement)mainLayout);
        StringWidget labelSlot1 = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(slot1Label, this.font).setColor(-4144960), 0, 0);
        labelSlot1.setTooltip(slot1Tooltip);
        this.buttonSlot1 = new OptionButton(this.font, 64, b -> this.updateSlots());
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot1.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot1.setSelected(Config.hudSlot1.ordinal());
        mainLayout.addChild((LayoutElement)this.buttonSlot1, 0, 1);
        StringWidget labelSlot2 = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(slot2Label, this.font).setColor(-4144960), 1, 0);
        labelSlot2.setTooltip(slot2Tooltip);
        this.buttonSlot2 = new OptionButton(this.font, 64, b -> this.updateSlots());
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot2.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot2.setSelected(Config.hudSlot2.ordinal());
        mainLayout.addChild((LayoutElement)this.buttonSlot2, 1, 1);
        StringWidget labelSlot3 = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(slot3Label, this.font).setColor(-4144960), 2, 0);
        labelSlot3.setTooltip(slot3Tooltip);
        this.buttonSlot3 = new OptionButton(this.font, 64, b -> this.updateSlots());
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.None));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Name));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Owner));
        this.buttonSlot3.addOption(Config.getTranslatedEnum(Config.HUDSlot.Banner));
        this.buttonSlot3.setSelected(Config.hudSlot3.ordinal());
        mainLayout.addChild((LayoutElement)this.buttonSlot3, 2, 1);
        StringWidget labelTextSize = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(textSizeLabel, this.font).setColor(-4144960), 3, 0);
        labelTextSize.setTooltip(textSizeTooltip);
        this.textTextSize = new TextBoxInt(1, 1, 8, this.font, 64);
        this.textTextSize.setValue(String.valueOf(Config.hudTextSize));
        this.textTextSize.setMaxLength(1);
        this.textTextSize.setValueChangedCallback(value -> {
            Config.hudTextSize = value;
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        mainLayout.addChild((LayoutElement)this.textTextSize, 3, 1);
        StringWidget labelBannerSize = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(bannerSizeLabel, this.font).setColor(-4144960), 4, 0);
        labelBannerSize.setTooltip(bannerSizeTooltip);
        this.textBannerSize = new TextBoxInt(3, 1, 8, this.font, 64);
        this.textBannerSize.setValue(String.valueOf(Config.hudBannerSize));
        this.textBannerSize.setMaxLength(1);
        this.textBannerSize.setValueChangedCallback(value -> {
            Config.hudBannerSize = value;
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        mainLayout.addChild((LayoutElement)this.textBannerSize, 4, 1);
        StringWidget labelAnchorLabel = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(anchorLabel, this.font).setColor(-4144960), 0, 3);
        labelAnchorLabel.setTooltip(anchorTooltip);
        this.buttonAnchor = new OptionButton(this.font, 134, b -> {
            Config.hudAnchor = Config.HUDAnchor.values()[b.getSelected()];
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        });
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTop));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomRight));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottom));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenBottomLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.ScreenTopLeft));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.Minimap));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapHorizontal));
        this.buttonAnchor.addOption(Config.getTranslatedEnum(Config.HUDAnchor.MinimapVertical));
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        mainLayout.addChild((LayoutElement)this.buttonAnchor, 0, 4);
        StringWidget labelPosition = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(positionLabel, this.font).setColor(-4144960), 1, 3);
        labelPosition.setTooltip(positionTooltip);
        LinearLayout positionLayout = LinearLayout.horizontal();
        mainLayout.addChild((LayoutElement)positionLayout, 1, 4);
        this.textPositionX = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.font, 61);
        this.textPositionX.setValue(String.valueOf(Config.hudXPosition));
        this.textPositionX.setMaxLength(5);
        this.textPositionX.setValueChangedCallback(value -> {
            Config.hudXPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        positionLayout.addChild((LayoutElement)this.textPositionX);
        positionLayout.addChild((LayoutElement)SpacerElement.width((int)3));
        positionLayout.addChild((LayoutElement)new StringWidget(positionSeparatorLabel, this.font).setColor(-8947849));
        positionLayout.addChild((LayoutElement)SpacerElement.width((int)2));
        this.textPositionY = new TextBoxInt(0, Integer.MIN_VALUE, Integer.MAX_VALUE, this.font, 62);
        this.textPositionY.setValue(String.valueOf(Config.hudYPosition));
        this.textPositionY.setMaxLength(5);
        this.textPositionY.setValueChangedCallback(value -> {
            Config.hudYPosition = value;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        positionLayout.addChild((LayoutElement)this.textPositionY);
        StringWidget labelAutoAdjustAnchor = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(autoAdjustAnchorLabel, this.font).setColor(-4144960), 2, 3);
        labelAutoAdjustAnchor.setTooltip(autoAdjustAnchorTooltip);
        this.buttonAutoAdjustAnchor = new OptionButton(this.font, 134, b -> {
            Config.hudAutoAdjustAnchor = b.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.buttonAutoAdjustAnchor.addOption(onLabel);
        this.buttonAutoAdjustAnchor.addOption(offLabel);
        this.buttonAutoAdjustAnchor.setSelected(Config.hudAutoAdjustAnchor ? 0 : 1);
        mainLayout.addChild((LayoutElement)this.buttonAutoAdjustAnchor, 2, 4);
        StringWidget labelSnapToBorder = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(snapToBorderLabel, this.font).setColor(-4144960), 3, 3);
        labelSnapToBorder.setTooltip(snapToBorderTooltip);
        this.buttonSnapToBorder = new OptionButton(this.font, 134, b -> {
            Config.hudSnapToBorder = b.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        });
        this.buttonSnapToBorder.addOption(onLabel);
        this.buttonSnapToBorder.addOption(offLabel);
        this.buttonSnapToBorder.setSelected(Config.hudSnapToBorder ? 0 : 1);
        mainLayout.addChild((LayoutElement)this.buttonSnapToBorder, 3, 4);
        this.buttonDone = new SimpleButton(this.font, 100, doneLabel, b -> this.onClose());
        mainLayout.addChild((LayoutElement)this.buttonDone, 5, 0, 1, 5, LayoutSettings.defaults().alignHorizontallyCenter());
        this.updatePosition();
    }

    public void tick() {
        ++this.anchorLineColorTick;
        if (this.anchorLineColorTick >= 3) {
            this.anchorLineColorTick = 0;
            this.anchorLineColor = this.anchorLineColor == -2236963 ? -14540254 : -2236963;
        }
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (Services.JOURNEYMAP.isMinimapEnabled()) {
            Services.JOURNEYMAP.drawMinimapPreview(graphics);
        }
        this.drawAnchor(graphics, this.minecraft.getWindow());
        this.drawCenteredBoxBackground(graphics, this.content.getWidth() + 20, this.content.getHeight() + 20);
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        if (event.input() == 69 && !(this.getFocused() instanceof EditBox)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    private void drawAnchor(GuiGraphics graphics, Window mainWindow) {
        float factor = mainWindow.getGuiScale();
        graphics.pose().pushMatrix();
        graphics.pose().scale(1.0f / factor, 1.0f / factor);
        int directionX = 0;
        int directionY = 0;
        int length = 25;
        Config.Point anchor = Config.getHUDAnchor(Config.hudAnchor);
        int displayWidth = mainWindow.getWidth();
        int displayHeight = mainWindow.getHeight();
        if (anchor.x < displayWidth / 2) {
            directionX = 1;
        } else if (anchor.x > displayWidth / 2) {
            directionX = -1;
            --anchor.x;
        }
        if (anchor.y < displayHeight / 2) {
            directionY = 1;
        } else if (anchor.y > displayHeight / 2) {
            directionY = -1;
            --anchor.y;
        }
        if (Config.hudAnchor == Config.HUDAnchor.Minimap) {
            directionX = -directionX;
            directionY = -directionY;
            if (directionX == 1) {
                ++anchor.x;
            }
            if (directionY == 1) {
                ++anchor.y;
            }
        }
        if (directionX == 0) {
            graphics.hLine(anchor.x - length, anchor.x + length, anchor.y, this.anchorLineColor);
        } else {
            graphics.hLine(anchor.x, anchor.x + length * directionX, anchor.y, this.anchorLineColor);
        }
        if (directionY == 0) {
            graphics.vLine(anchor.x, anchor.y - length, anchor.y + length, this.anchorLineColor);
        } else {
            graphics.vLine(anchor.x, anchor.y, anchor.y + length * directionY, this.anchorLineColor);
        }
        graphics.pose().popMatrix();
    }

    private void updateSlots() {
        this.updateSlotsValidity();
        boolean updated = false;
        if (this.buttonSlot1.getColor() == -4144960 || this.buttonSlot1.getColor() == -1) {
            Config.hudSlot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
            updated = true;
        }
        if (this.buttonSlot2.getColor() == -4144960 || this.buttonSlot2.getColor() == -1) {
            Config.hudSlot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
            updated = true;
        }
        if (this.buttonSlot3.getColor() == -4144960 || this.buttonSlot3.getColor() == -1) {
            Config.hudSlot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
            updated = true;
        }
        if (updated) {
            ClientEventHandler.postUpdatedConfigEvent();
            this.updatePosition();
        }
    }

    private void updateSlotsValidity() {
        Config.HUDSlot slot1 = Config.HUDSlot.values()[this.buttonSlot1.getSelected()];
        Config.HUDSlot slot2 = Config.HUDSlot.values()[this.buttonSlot2.getSelected()];
        Config.HUDSlot slot3 = Config.HUDSlot.values()[this.buttonSlot3.getSelected()];
        this.buttonSlot1.setColor(-4144960, -1);
        this.buttonSlot2.setColor(-4144960, -1);
        this.buttonSlot3.setColor(-4144960, -1);
        if (slot1 != Config.HUDSlot.None && slot1 == slot2) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot2.setColor(-2289391, -48060);
        }
        if (slot1 != Config.HUDSlot.None && slot1 == slot3) {
            this.buttonSlot1.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
        if (slot2 != Config.HUDSlot.None && slot2 == slot3) {
            this.buttonSlot2.setColor(-2289391, -48060);
            this.buttonSlot3.setColor(-2289391, -48060);
        }
    }

    public void onClose() {
        this.backgroundScreen = this.previousScreen;
        super.onClose();
    }

    public void removed() {
        ClientEventHandler.postUpdatedConfigEvent();
    }

    private void updatePosition() {
        Config.Point anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
        Config.Point positionPoint = new Config.Point();
        positionPoint.x = Config.hudXPosition + anchorPoint.x - originPoint.x;
        positionPoint.y = Config.hudYPosition + anchorPoint.y - originPoint.y;
        this.HUDWidget.setPositionHUD(positionPoint);
    }

    private void HUDUpdated() {
        this.buttonAnchor.setSelected(Config.hudAnchor.ordinal());
        this.textPositionX.setValue(String.valueOf(Config.hudXPosition));
        this.textPositionY.setValue(String.valueOf(Config.hudYPosition));
    }
}

