/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.UserSharedElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketRemoveSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketUpdateSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import java.util.Date;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class ShareSettings
extends AutoScaledScreen {
    private static final Component titleLabel = Component.translatable((String)"mapfrontiers.title_share_settings");
    private static final Component updateFrontierLabel = Component.translatable((String)"mapfrontiers.update_frontier");
    private static final Component updateSettingsLabel = Component.translatable((String)"mapfrontiers.update_settings");
    private static final Component errorUUIDSizeLabel = Component.translatable((String)"mapfrontiers.new_user_error_uuid_size");
    private static final Component errorUUIDFormatLabel = Component.translatable((String)"mapfrontiers.new_user_error_uuid_format");
    private static final Component errorUserNotFoundLabel = Component.translatable((String)"mapfrontiers.new_user_shared_error_user_not_found");
    private static final Component errorSelfLabel = Component.translatable((String)"mapfrontiers.new_user_shared_error_self");
    private static final Component errorOwnerLabel = Component.translatable((String)"mapfrontiers.new_user_shared_error_owner");
    private static final Component errorRepeatedLabel = Component.translatable((String)"mapfrontiers.new_user_shared_error_user_repeated");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private final FrontiersOverlayManager frontiersOverlayManager;
    private FrontierOverlay frontier;
    private MultiLineTextWidget updateFrontier;
    private MultiLineTextWidget updateSettings;
    private ScrollBox users;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;
    private boolean canUpdate;
    private int ticksSinceLastUpdate = 0;

    public ShareSettings(FrontiersOverlayManager frontiersOverlayManager, FrontierOverlay frontier) {
        super(titleLabel, 470, 120);
        this.frontiersOverlayManager = frontiersOverlayManager;
        this.frontier = frontier;
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontierID.equals(this.frontier.getId())) {
                this.onClose();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (frontierOverlay.getId().equals(this.frontier.getId())) {
                this.frontier = frontierOverlay;
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
        });
    }

    @Override
    public void initScreen() {
        if (!MapFrontiersClient.isModOnServer()) {
            this.onClose();
        }
        LinearLayout mainLayout = LinearLayout.vertical().spacing(8);
        mainLayout.defaultCellSetting().alignHorizontallyCenter();
        this.content.addChild((LayoutElement)mainLayout);
        LinearLayout header = LinearLayout.horizontal();
        mainLayout.addChild((LayoutElement)header);
        this.updateFrontier = (MultiLineTextWidget)header.addChild((LayoutElement)new MultiLineTextWidget((Component)updateFrontierLabel.copy().withColor(-1), this.font));
        this.updateFrontier.setCentered(true);
        this.updateSettings = (MultiLineTextWidget)header.addChild((LayoutElement)new MultiLineTextWidget((Component)updateSettingsLabel.copy().withColor(-1), this.font));
        this.updateSettings.setCentered(true);
        this.users = new ScrollBox(this.actualHeight - 128, 430, 16);
        this.users.setElementDeletePressedCallback(element -> {
            if (Config.askConfirmationUserDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_user_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationUserDelete = false;
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.deleteUserPressed((ScrollBox.ScrollElement)element);
                }).display();
            } else {
                this.deleteUserPressed((ScrollBox.ScrollElement)element);
            }
        });
        mainLayout.addChild((LayoutElement)this.users);
        LinearLayout newUserLayout = LinearLayout.horizontal().spacing(4);
        mainLayout.addChild((LayoutElement)newUserLayout);
        this.textNewUser = new TextBoxUser(this.minecraft, this.font, 238);
        this.textNewUser.setMaxLength(38);
        this.textNewUser.setSubmitCallback(value -> this.buttonNewUserPressed());
        newUserLayout.addChild((LayoutElement)this.textNewUser);
        this.buttonNewUser = new IconButton(IconButton.Type.Add, b -> this.buttonNewUserPressed());
        this.buttonNewUser.visible = false;
        newUserLayout.addChild((LayoutElement)this.buttonNewUser);
        this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 140, doneLabel, b -> this.onClose()));
        this.updateCanUpdate();
        this.updateButtonsVisibility();
        this.updateUsers();
    }

    public void tick() {
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 100) {
            this.ticksSinceLastUpdate = 0;
            ClientPacketListener handler = this.minecraft.getConnection();
            if (handler == null) {
                return;
            }
            for (ScrollBox.ScrollElement element : this.users.getElements()) {
                UserSharedElement userElement = (UserSharedElement)element;
                SettingsUser user = userElement.getUser();
                PlayerInfo networkplayerinfo = null;
                if (user.uuid != null) {
                    networkplayerinfo = handler.getPlayerInfo(user.uuid);
                } else if (!StringUtils.isBlank((CharSequence)user.username)) {
                    networkplayerinfo = handler.getPlayerInfo(user.username);
                }
                if (networkplayerinfo == null) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 0) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 150) {
                    userElement.setPingBar(5);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 300) {
                    userElement.setPingBar(4);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 600) {
                    userElement.setPingBar(3);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 1000) {
                    userElement.setPingBar(2);
                    continue;
                }
                userElement.setPingBar(1);
            }
        }
    }

    @Override
    public void repositionElements() {
        this.users.setSize(430, this.actualHeight - 128);
        super.repositionElements();
        this.updateFrontier.setX(this.users.getX() + 250 - this.updateFrontier.getWidth() / 2);
        this.updateSettings.setX(this.users.getX() + 310 - this.updateSettings.getWidth() / 2);
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.getWidth() + 20, this.content.getHeight() + 20);
    }

    @Override
    public boolean mouseReleased(MouseButtonEvent event) {
        for (GuiEventListener w : this.children()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.mouseReleased(event);
    }

    private void deleteUserPressed(ScrollBox.ScrollElement element) {
        this.users.removeElement(element);
        SettingsUser user = ((UserSharedElement)element).getUser();
        this.frontier.removeUserShared(user);
        PacketHandler.sendToServer(new PacketRemoveSharedUserPersonalFrontier(this.frontier.getId(), user));
        this.resetLabels();
    }

    private void buttonNewUserPressed() {
        if (this.minecraft.player == null) {
            return;
        }
        SettingsUser user = new SettingsUser();
        String usernameOrUUID = this.textNewUser.getValue();
        this.textNewUser.setFocused(false);
        if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
            return;
        }
        if (usernameOrUUID.length() < 28) {
            user.username = usernameOrUUID;
            user.fillMissingInfo(false, null);
        } else {
            if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                this.textNewUser.setError(errorUUIDSizeLabel);
                return;
            }
            usernameOrUUID = usernameOrUUID.toLowerCase();
            String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
            try {
                user.uuid = UUID.fromString(uuid);
                user.fillMissingInfo(true, null);
            }
            catch (Exception e) {
                this.textNewUser.setError(errorUUIDFormatLabel);
                return;
            }
        }
        if (user.uuid == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        ClientPacketListener handler = this.minecraft.getConnection();
        if (handler != null && handler.getPlayerInfo(user.uuid) == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        if (user.username.equals(this.minecraft.player.getGameProfile().name())) {
            this.textNewUser.setError(errorSelfLabel);
            return;
        }
        if (this.frontier.getOwner().equals(user)) {
            this.textNewUser.setError(errorOwnerLabel);
            return;
        }
        if (this.frontier.hasUserShared(user)) {
            this.textNewUser.setError(errorRepeatedLabel);
            return;
        }
        SettingsUserShared userShared = new SettingsUserShared(user, true);
        this.frontier.addUserShared(userShared);
        this.frontiersOverlayManager.clientShareFrontier(this.frontier.getId(), user);
        UserSharedElement element = new UserSharedElement(this.font, userShared, this.canUpdate, true, this::actionChanged);
        this.users.addElement(element);
        this.users.scrollBottom();
        this.textNewUser.setValue("");
        this.resetLabels();
    }

    public void onClose() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.onClose();
    }

    private void resetLabels() {
        if (this.users.getElements().isEmpty()) {
            this.updateFrontier.visible = false;
            this.updateSettings.visible = false;
        } else {
            this.updateFrontier.visible = true;
            this.updateSettings.visible = true;
        }
    }

    private void updateButtonsVisibility() {
        this.buttonNewUser.visible = this.canUpdate;
        this.textNewUser.visible = this.canUpdate;
    }

    private void actionChanged(SettingsUserShared user, SettingsUserShared.Action action, boolean checked) {
        if (this.minecraft.player == null) {
            return;
        }
        if (checked) {
            user.addAction(action);
        } else {
            user.removeAction(action);
        }
        if (user.getUser().equals(new SettingsUser((Player)this.minecraft.player))) {
            if (action == SettingsUserShared.Action.UpdateSettings) {
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
            this.frontier.setModified(new Date());
            ClientEventHandler.postUpdatedFrontierEvent(this.frontier, -1);
        }
        PacketHandler.sendToServer(new PacketUpdateSharedUserPersonalFrontier(this.frontier.getId(), user));
    }

    private void updateUsers() {
        this.users.removeAll();
        if (this.minecraft.player == null) {
            return;
        }
        SettingsUser player = new SettingsUser((Player)this.minecraft.player);
        if (this.frontier.getUsersShared() != null) {
            for (SettingsUserShared user : this.frontier.getUsersShared()) {
                this.users.addElement(new UserSharedElement(this.font, user, this.canUpdate, !user.getUser().equals(player), this::actionChanged));
            }
        }
        this.resetLabels();
    }

    private void updateCanUpdate() {
        if (this.minecraft.player == null) {
            return;
        }
        this.canUpdate = this.frontier.checkActionUserShared(new SettingsUser((Player)this.minecraft.player), SettingsUserShared.Action.UpdateSettings);
    }
}

