/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.plugin;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.FullscreenMap;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.event.FullscreenMapEvent;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.fullscreen.ThemeButtonDisplay;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.api.v2.common.event.FullscreenEventRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@JourneyMapPlugin(apiVersion="2.0.0-SNAPSHOT")
public class MapFrontiersPlugin
implements IClientPlugin {
    private static FullscreenMap fullscreenMap;

    public void initialize(IClientAPI jmAPI) {
        MapFrontiersClient.setjmAPI(jmAPI);
        FullscreenEventRegistry.FULLSCREEN_MAP_CLICK_EVENT.subscribe("mapfrontiers", clickEvent -> {
            boolean cancel;
            if (fullscreenMap == null) {
                return;
            }
            FullscreenMapEvent.Stage relevantStage = clickEvent.getButton() == 1 ? FullscreenMapEvent.Stage.PRE : FullscreenMapEvent.Stage.POST;
            if (clickEvent.getStage() == relevantStage && (cancel = fullscreenMap.mapClicked((ResourceKey<Level>)clickEvent.dimension, clickEvent.getLocation(), clickEvent.getButton()))) {
                clickEvent.cancel();
            }
        });
        FullscreenEventRegistry.FULLSCREEN_MAP_DRAG_EVENT.subscribe("mapfrontiers", mouseDraggedEvent -> {
            boolean cancel;
            if (fullscreenMap == null) {
                return;
            }
            if (mouseDraggedEvent.getStage() == FullscreenMapEvent.Stage.PRE && (cancel = fullscreenMap.mapDragged((ResourceKey<Level>)mouseDraggedEvent.dimension, mouseDraggedEvent.getLocation()))) {
                mouseDraggedEvent.cancel();
            }
        });
        FullscreenEventRegistry.FULLSCREEN_MAP_MOVE_EVENT.subscribe("mapfrontiers", mouseMoveEvent -> {
            if (fullscreenMap == null) {
                return;
            }
            fullscreenMap.mouseMoved((ResourceKey<Level>)mouseMoveEvent.dimension, mouseMoveEvent.getLocation());
        });
        ClientEventRegistry.DISPLAY_UPDATE_EVENT.subscribe("mapfrontiers", displayUpdateEvent -> {
            if (fullscreenMap == null) {
                return;
            }
            if (displayUpdateEvent.uiState.ui == Context.UI.Fullscreen) {
                if (displayUpdateEvent.uiState.active) {
                    fullscreenMap.updateButtons();
                } else {
                    fullscreenMap.stopEditing();
                    fullscreenMap.close();
                    fullscreenMap = null;
                }
            }
        });
        FullscreenEventRegistry.ADDON_BUTTON_DISPLAY_EVENT.subscribe("mapfrontiers", addonButtonDisplayEvent -> {
            ThemeButtonDisplay buttonDisplay = addonButtonDisplayEvent.getThemeButtonDisplay();
            ClientEventHandler.postAddonButtonDisplayEvent(buttonDisplay);
        });
        FullscreenEventRegistry.FULLSCREEN_POPUP_MENU_EVENT.subscribe("mapfrontiers", fullscreenPopupMenuEvent -> {
            ModPopupMenu popupMenu = fullscreenPopupMenuEvent.getPopupMenu();
            ClientEventHandler.postFullscreenPopupMenuEvent(popupMenu);
        });
        ClientEventHandler.subscribeAddonButtonDisplayEvent(MapFrontiersPlugin.class, buttonDisplay -> {
            if (fullscreenMap == null) {
                fullscreenMap = new FullscreenMap(jmAPI);
            }
            fullscreenMap.addButtons((ThemeButtonDisplay)buttonDisplay);
        });
        ClientEventHandler.subscribeFullscreenPopupMenuEvent(MapFrontiersPlugin.class, popupMenu -> {
            if (fullscreenMap != null) {
                fullscreenMap.addPopupMenu((ModPopupMenu)popupMenu);
            }
        });
    }

    public String getModId() {
        return "mapfrontiers";
    }

    public static boolean isEditing() {
        return fullscreenMap != null && (fullscreenMap.isEditingVertices() || fullscreenMap.isEditingChunks());
    }
}

