/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.PendingShareFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierCreated;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class CommandAccept {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode literalcommandnode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mapfrontiersaccept").requires(CommandAccept::checkPermission)).then(Commands.argument((String)"invitation id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)999)).executes(commandSource -> CommandAccept.acceptInvitation((CommandSourceStack)commandSource.getSource(), IntegerArgumentType.getInteger((CommandContext)commandSource, (String)"invitation id")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mfaccept").requires(CommandAccept::checkPermission)).redirect((CommandNode)literalcommandnode));
    }

    public static int acceptInvitation(CommandSourceStack source, int messageID) throws CommandSyntaxException {
        ServerLevel world = source.getLevel();
        if (!world.isClientSide()) {
            PendingShareFrontier pending = FrontiersManager.instance.getPendingShareFrontier(messageID);
            if (pending == null) {
                source.sendFailure((Component)Component.literal((String)"Invitation expired"));
            } else {
                if (pending.targetUser.equals(new SettingsUser((Player)source.getPlayerOrException()))) {
                    FrontierData frontier = FrontiersManager.instance.getFrontierFromID(pending.frontierID);
                    if (frontier == null || !frontier.getPersonal()) {
                        FrontiersManager.instance.removePendingShareFrontier(messageID);
                        source.sendFailure((Component)Component.literal((String)"The frontier no longer exists"));
                        return messageID;
                    }
                    SettingsUserShared userShared = frontier.getUserShared(pending.targetUser);
                    if (userShared == null) {
                        source.sendFailure((Component)Component.literal((String)""));
                        return messageID;
                    }
                    if (FrontiersManager.instance.hasPersonalFrontier(pending.targetUser, frontier.getId())) {
                        FrontiersManager.instance.removePendingShareFrontier(messageID);
                        source.sendFailure((Component)Component.literal((String)"You already have the frontier"));
                        return messageID;
                    }
                    FrontiersManager.instance.addPersonalFrontier(pending.targetUser, frontier);
                    userShared.setPending(false);
                    frontier.addChange(FrontierData.Change.Shared);
                    FrontiersManager.instance.removePendingShareFrontier(messageID);
                    PacketHandler.sendTo(new PacketFrontierCreated(frontier), source.getPlayerOrException());
                    PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(frontier), frontier, source.getServer());
                    frontier.removeChange(FrontierData.Change.Shared);
                    source.sendSuccess(() -> Component.literal((String)("Accepting frontier " + frontier.getName1() + " " + frontier.getName2())), false);
                    return messageID;
                }
                source.sendFailure((Component)Component.literal((String)"The invitation is for another player"));
                return messageID;
            }
        }
        return messageID;
    }

    public static boolean checkPermission(CommandSourceStack source) {
        try {
            return FrontiersManager.instance.canSendCommandAcceptFrontier(source.getPlayerOrException());
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }
}

