/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.util;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

@ParametersAreNonnullByDefault
public class UUIDHelper {
    public static UUID getUUIDFromName(String username, @Nullable MinecraftServer server) {
        if (server != null) {
            ServerPlayer player = server.getPlayerList().getPlayer(username);
            if (player != null) {
                return player.nameAndId().id();
            }
        } else {
            PlayerInfo playerInfo;
            ClientPacketListener handler = Minecraft.getInstance().getConnection();
            if (handler != null && (playerInfo = handler.getPlayerInfo(username)) != null) {
                return playerInfo.getProfile().id();
            }
        }
        return null;
    }

    public static String getNameFromUUID(UUID uuid, @Nullable MinecraftServer server) {
        if (server != null) {
            ServerPlayer player = server.getPlayerList().getPlayer(uuid);
            if (player != null) {
                return player.nameAndId().name();
            }
        } else {
            PlayerInfo playerInfo;
            ClientPacketListener handler = Minecraft.getInstance().getConnection();
            if (handler != null && (playerInfo = handler.getPlayerInfo(uuid)) != null) {
                return playerInfo.getProfile().name();
            }
        }
        return null;
    }

    public static UUID fromBytes(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void toBytes(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    private UUIDHelper() {
    }
}

