/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1074;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class FrontierListElement
extends ScrollBox.ScrollElement {
    private final class_327 font;
    private final FrontierOverlay frontier;
    private final String name1;
    private final String name2;
    private final String type;
    private final String owner;
    private final String dimension;
    private final String vertices;
    private final String chunks;
    private final int offset1;
    private final int offset2;

    public FrontierListElement(class_327 font, FrontierOverlay frontier) {
        super(450, 24);
        this.font = font;
        this.frontier = frontier;
        if (frontier.isNamed()) {
            this.name1 = frontier.getName1();
            this.name2 = frontier.getName2();
        } else {
            this.name1 = class_1074.method_4662((String)"mapfrontiers.unnamed_1", (Object[])new Object[]{class_124.field_1056});
            this.name2 = class_1074.method_4662((String)"mapfrontiers.unnamed_2", (Object[])new Object[]{class_124.field_1056});
        }
        this.type = class_1074.method_4662((String)"mapfrontiers.type", (Object[])new Object[]{class_1074.method_4662((String)(frontier.getPersonal() ? "mapfrontiers.config.Personal" : "mapfrontiers.config.Global"), (Object[])new Object[0])});
        this.owner = class_1074.method_4662((String)"mapfrontiers.owner", (Object[])new Object[]{frontier.getOwner()});
        this.dimension = class_1074.method_4662((String)"mapfrontiers.dimension", (Object[])new Object[]{frontier.getDimension().method_29177().toString()});
        if (frontier.getMode() == FrontierData.Mode.Vertex) {
            this.vertices = class_1074.method_4662((String)"mapfrontiers.vertices", (Object[])new Object[]{frontier.getVertexCount()});
            this.chunks = null;
        } else {
            this.vertices = null;
            this.chunks = class_1074.method_4662((String)"mapfrontiers.chunks", (Object[])new Object[]{frontier.getChunkCount()});
        }
        this.offset1 = StringHelper.getMaxWidth(font, class_1074.method_4662((String)"mapfrontiers.type", (Object[])new Object[]{class_1074.method_4662((String)"mapfrontiers.config.Personal", (Object[])new Object[0])}), class_1074.method_4662((String)"mapfrontiers.type", (Object[])new Object[]{class_1074.method_4662((String)"mapfrontiers.config.Global", (Object[])new Object[0])}));
        this.offset2 = StringHelper.getMaxWidth(font, class_1074.method_4662((String)"mapfrontiers.vertices", (Object[])new Object[]{9999}), class_1074.method_4662((String)"mapfrontiers.chunks", (Object[])new Object[]{9999}));
    }

    public FrontierOverlay getFrontier() {
        return this.frontier;
    }

    @Override
    protected void setX(int x) {
        super.setX(x);
    }

    @Override
    protected void setY(int y) {
        super.setY(y);
    }

    @Override
    protected void renderWidget(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        int color = -4144960;
        if (selected) {
            color = -1;
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -13619152);
        } else if (this.isHovered) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -1607454672);
        }
        int hiddenColor = -8947849;
        if (this.frontier.getVisibility(FrontierData.VisibilityData.Visibility.Frontier)) {
            graphics.method_25303(this.font, this.name1, this.x + 26, this.y + 4, color);
            graphics.method_25303(this.font, this.name2, this.x + 26, this.y + 14, color);
        } else {
            graphics.method_25303(this.font, String.valueOf(class_124.field_1055) + this.name1, this.x + 26, this.y + 4, hiddenColor);
            graphics.method_25303(this.font, String.valueOf(class_124.field_1055) + this.name2, this.x + 26, this.y + 14, hiddenColor);
        }
        graphics.method_25303(this.font, this.type, this.x + 170, this.y + 4, color);
        graphics.method_25303(this.font, this.dimension, this.x + 170, this.y + 14, -6710887);
        if (this.frontier.getMode() == FrontierData.Mode.Vertex) {
            graphics.method_25303(this.font, this.vertices, this.x + 180 + this.offset1, this.y + 4, color);
        } else {
            graphics.method_25303(this.font, this.chunks, this.x + 180 + this.offset1, this.y + 4, color);
        }
        graphics.method_25303(this.font, this.owner, this.x + 190 + this.offset1 + this.offset2, this.y + 4, color);
        graphics.method_25294(this.x + 1, this.y + 1, this.x + 23, this.y + 23, -1);
        graphics.method_25294(this.x + 2, this.y + 2, this.x + 22, this.y + 22, this.frontier.getColor() | 0xFF000000);
    }

    @Override
    public ScrollBox.ScrollElement.Action mousePressed(class_11909 event, boolean doubleClick) {
        if (this.visible && this.isHovered) {
            return ScrollBox.ScrollElement.Action.Clicked;
        }
        return ScrollBox.ScrollElement.Action.None;
    }
}

