/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.hud;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7446;
import net.minecraft.class_7924;
import net.minecraft.class_9307;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class HUD {
    private static final class_310 mc = class_310.method_1551();
    private FrontierOverlay frontier;
    private int frontierHash;
    private class_2338 lastPlayerPosition = new class_2338(0, 0, 0);
    private final StringWidget frontierName1;
    private final StringWidget frontierName2;
    private final StringWidget frontierOwner;
    private final List<Config.HUDSlot> slots = new ArrayList<Config.HUDSlot>();
    private int posX = 0;
    private int posY = 0;
    private int nameOffsetY = 0;
    private int ownerOffsetY = 0;
    private int bannerOffsetY = 0;
    private int nameLinesCount = 0;
    private int hudWidth = 0;
    private int hudHeight = 0;
    private int textScale = 1;
    private int bannerScale = 1;
    private boolean needUpdate = true;
    private boolean previewMode = false;
    private int displayWidth;
    private int displayHeight;

    public static HUD asPreview() {
        HUD hud = new HUD();
        hud.previewMode = true;
        class_7225 patternRegistry = (class_7225)HUD.mc.field_1687.method_30349().method_46759(class_7924.field_41252).get();
        class_9307 patterns = new class_9307.class_3750().method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39148).get(), class_1767.field_7942).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39144).get(), class_1767.field_7967).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39140).get(), class_1767.field_7951).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39168).get(), class_1767.field_7951).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39167).get(), class_1767.field_7963).method_16376((class_6880)patternRegistry.method_46746(class_7446.field_39156).get(), class_1767.field_7942).method_57573();
        FrontierData frontierData = new FrontierData();
        frontierData.setOwner(new SettingsUser((class_1657)HUD.mc.field_1724));
        frontierData.setName1("Preview Frontier");
        frontierData.setName2("-----------------");
        frontierData.setBanner(class_1767.field_7963, patterns);
        hud.frontier = new FrontierOverlay(frontierData, null);
        return hud;
    }

    public HUD() {
        this.frontierName1 = new StringWidget((class_2561)class_2561.method_43473(), HUD.mc.field_1772, StringWidget.Align.Center);
        this.frontierName2 = new StringWidget((class_2561)class_2561.method_43473(), HUD.mc.field_1772, StringWidget.Align.Center);
        this.frontierOwner = new StringWidget((class_2561)class_2561.method_43473(), HUD.mc.field_1772, StringWidget.Align.Center);
        ClientEventHandler.subscribeDeletedFrontierEvent(this, frontierID -> this.frontierChanged());
        ClientEventHandler.subscribeNewFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedConfigEvent(this, this::configUpdated);
    }

    public int getWidth() {
        return this.hudWidth;
    }

    public int getHeight() {
        return this.hudHeight;
    }

    public boolean isInside(int x, int y) {
        return x >= this.posX && x < this.posX + this.hudWidth && y >= this.posY && y < this.posY + this.hudHeight;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void tick() {
        if (this.previewMode || HUD.mc.field_1724 == null || Config.frontierVisibility == Config.Visibility.Never) {
            return;
        }
        class_2338 currentPlayerPosition = HUD.mc.field_1724.method_24515();
        if (currentPlayerPosition.method_10263() != this.lastPlayerPosition.method_10263() || currentPlayerPosition.method_10260() != this.lastPlayerPosition.method_10260()) {
            this.lastPlayerPosition = currentPlayerPosition;
            List<FrontierOverlay> frontiers = MapFrontiersClient.getFrontiersInPosition((class_5321<class_1937>)HUD.mc.field_1724.method_73183().method_27983(), this.lastPlayerPosition);
            if (!frontiers.isEmpty()) {
                FrontierOverlay newFrontier = frontiers.getFirst();
                if (this.frontierHash != newFrontier.getHash()) {
                    this.frontier = newFrontier;
                    this.frontierHash = newFrontier.getHash();
                    this.needUpdate = true;
                }
            } else if (this.frontier != null) {
                this.frontier = null;
                this.frontierHash = 0;
                this.needUpdate = true;
            }
        }
        if (this.frontier != null && this.frontierHash != this.frontier.getHash()) {
            this.frontierHash = this.frontier.getHash();
            this.needUpdate = true;
        }
    }

    public void configUpdated() {
        if (this.previewMode) {
            this.updateData();
        } else {
            this.needUpdate = true;
        }
    }

    public void frontierChanged() {
        if (this.previewMode) {
            return;
        }
        List<FrontierOverlay> frontiers = MapFrontiersClient.getFrontiersInPosition((class_5321<class_1937>)HUD.mc.field_1724.method_73183().method_27983(), this.lastPlayerPosition);
        if (!frontiers.isEmpty()) {
            FrontierOverlay newFrontier = frontiers.getFirst();
            if (this.frontierHash != newFrontier.getHash()) {
                this.frontier = newFrontier;
                this.frontierHash = newFrontier.getHash();
                this.needUpdate = true;
            }
        } else if (this.frontier != null) {
            this.frontier = null;
            this.frontierHash = 0;
            this.needUpdate = true;
        }
    }

    public void drawInGameHUD(class_332 graphics, float partialTicks) {
        if (this.previewMode) {
            return;
        }
        if (HUD.mc.field_1755 != null && !(HUD.mc.field_1755 instanceof class_408)) {
            return;
        }
        if (this.frontier == null) {
            return;
        }
        if (!Config.hudEnabled) {
            return;
        }
        this.draw(graphics, partialTicks);
    }

    public void draw(class_332 graphics, float partialTicks) {
        if (this.displayWidth != mc.method_22683().method_4489() || this.displayHeight != mc.method_22683().method_4506()) {
            this.needUpdate = true;
        }
        if ((Config.hudAnchor == Config.HUDAnchor.Minimap || Config.hudAnchor == Config.HUDAnchor.MinimapHorizontal || Config.hudAnchor == Config.HUDAnchor.MinimapVertical) && Services.JOURNEYMAP.minimapPropertiesChanged()) {
            this.needUpdate = true;
        }
        if (this.needUpdate) {
            this.needUpdate = false;
            this.updateData();
        }
        if (this.slots.isEmpty()) {
            return;
        }
        float factor = mc.method_22683().method_4495();
        int frameColor = Services.JOURNEYMAP.minimapLabelBackgroundColor();
        int textNameColor = Services.JOURNEYMAP.minimapLabelHighlightColor();
        int textOwnerColor = Services.JOURNEYMAP.minimapLabelForegroundColor();
        graphics.method_51448().pushMatrix();
        graphics.method_51448().scale(1.0f / factor, 1.0f / factor);
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.drawName(graphics, frameColor, textNameColor, partialTicks);
                    break;
                }
                case Owner: {
                    this.drawOwner(graphics, frameColor, textOwnerColor, partialTicks);
                    break;
                }
                case Banner: {
                    this.drawBanner(graphics, frameColor);
                    break;
                }
            }
        }
        graphics.method_51448().popMatrix();
    }

    private void drawName(class_332 graphics, int frameColor, int textColor, float partialTicks) {
        graphics.method_25294(this.posX, this.posY + this.nameOffsetY, this.posX + this.hudWidth, this.posY + this.nameOffsetY + 12 * this.nameLinesCount * this.textScale, frameColor);
        this.frontierName1.setColor(textColor);
        this.frontierName2.setColor(textColor);
        this.frontierName1.method_25394(graphics, 0, 0, partialTicks);
        this.frontierName2.method_25394(graphics, 0, 0, partialTicks);
    }

    private void drawOwner(class_332 graphics, int frameColor, int textColor, float partialTicks) {
        graphics.method_25294(this.posX, this.posY + this.ownerOffsetY, this.posX + this.hudWidth, this.posY + this.ownerOffsetY + 12 * this.textScale, frameColor);
        this.frontierOwner.setColor(textColor);
        this.frontierOwner.method_25394(graphics, 0, 0, partialTicks);
    }

    private void drawBanner(class_332 graphics, int frameColor) {
        int bannerX = this.posX + this.hudWidth / 2;
        int bannerY = this.posY + this.bannerOffsetY + 2;
        int[] bannerBounds = this.frontier.getBannerBounds(bannerX - 11 * this.bannerScale, bannerY, this.bannerScale);
        graphics.method_25294(bannerBounds[0] - 2, bannerBounds[1] - 2, bannerBounds[2] + 2, bannerBounds[3] + 2, frameColor);
        this.frontier.getBannerRenderer().renderBanner(graphics, bannerX, bannerY, this.bannerScale);
    }

    private void updateData() {
        int[] bannerBounds;
        String owner;
        this.displayWidth = mc.method_22683().method_4489();
        this.displayHeight = mc.method_22683().method_4506();
        this.slots.clear();
        if (this.frontier == null) {
            return;
        }
        this.addSlot(Config.hudSlot1);
        this.addSlot(Config.hudSlot2);
        this.addSlot(Config.hudSlot3);
        if (this.slots.isEmpty()) {
            return;
        }
        this.hudWidth = 0;
        this.hudHeight = 0;
        this.bannerScale = Config.hudBannerSize;
        this.nameLinesCount = 0;
        this.textScale = Config.hudTextSize;
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    if (!StringUtils.isBlank((CharSequence)this.frontier.getName1())) {
                        ++this.nameLinesCount;
                    }
                    if (!StringUtils.isBlank((CharSequence)this.frontier.getName2())) {
                        ++this.nameLinesCount;
                    }
                    int name1Width = HUD.mc.field_1772.method_1727(this.frontier.getName1()) + 3;
                    int name2Width = HUD.mc.field_1772.method_1727(this.frontier.getName2()) + 3;
                    int nameWidth = Math.max(name1Width, name2Width) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, nameWidth);
                    this.hudHeight += 12 * this.nameLinesCount * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    int ownerWidth = (HUD.mc.field_1772.method_1727(owner) + 3) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, ownerWidth);
                    this.hudHeight += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    bannerBounds = this.frontier.getBannerBounds(0, 0, this.bannerScale);
                    this.hudWidth = Math.max(this.hudWidth, bannerBounds[2] - bannerBounds[0] + 4);
                    this.hudHeight += bannerBounds[3] - bannerBounds[1] + 4;
                    break;
                }
            }
        }
        Config.Point anchorPos = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPos = Config.getHUDOrigin(Config.hudAnchor, this.hudWidth, this.hudHeight);
        this.posX = anchorPos.x - originPos.x + Config.hudXPosition;
        this.posY = anchorPos.y - originPos.y + Config.hudYPosition;
        int offsetY = 0;
        this.nameOffsetY = 0;
        this.ownerOffsetY = 0;
        this.bannerOffsetY = 0;
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.nameOffsetY = offsetY;
                    if (StringUtils.isBlank((CharSequence)this.frontier.getName1())) {
                        this.frontierName1.method_25355((class_2561)class_2561.method_43473());
                    } else {
                        this.frontierName1.method_46421(this.posX + this.hudWidth / 2);
                        this.frontierName1.method_46419(this.posY + this.nameOffsetY + 2 * this.textScale);
                        this.frontierName1.setScale(this.textScale);
                        this.frontierName1.method_25355((class_2561)class_2561.method_43470((String)this.frontier.getName1()));
                        offsetY += 12 * this.textScale;
                    }
                    if (StringUtils.isBlank((CharSequence)this.frontier.getName2())) {
                        this.frontierName2.method_25355((class_2561)class_2561.method_43473());
                        break;
                    }
                    this.frontierName2.method_46421(this.posX + this.hudWidth / 2);
                    this.frontierName2.method_46419(this.posY + offsetY + 2 * this.textScale);
                    this.frontierName2.setScale(this.textScale);
                    this.frontierName2.method_25355((class_2561)class_2561.method_43470((String)this.frontier.getName2()));
                    offsetY += 12 * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    this.ownerOffsetY = offsetY;
                    this.frontierOwner.method_46421(this.posX + this.hudWidth / 2);
                    this.frontierOwner.method_46419(this.posY + this.ownerOffsetY + 2 * this.textScale);
                    this.frontierOwner.setScale(this.textScale);
                    this.frontierOwner.method_25355((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1056) + owner)));
                    offsetY += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    bannerBounds = this.frontier.getBannerBounds(0, 0, this.bannerScale);
                    int bannerHeight = bannerBounds[3] - bannerBounds[1];
                    this.bannerOffsetY = offsetY - bannerBounds[1];
                    offsetY += bannerHeight + 4;
                    break;
                }
            }
        }
    }

    private String getOwnerString() {
        Object ownerString = "";
        if (!StringUtils.isBlank((CharSequence)this.frontier.getOwner().username)) {
            ownerString = this.frontier.getOwner().username;
        } else if (this.frontier.getOwner().uuid != null) {
            ownerString = this.frontier.getOwner().uuid.toString();
            ownerString = ((String)ownerString).substring(0, 8) + "...";
        }
        return ownerString;
    }

    private void addSlot(Config.HUDSlot slot) {
        if (slot == Config.HUDSlot.Name) {
            if (this.frontier.isNamed()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Owner) {
            if (!this.frontier.getOwner().isEmpty()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Banner && this.frontier.getBannerRenderer().hasBanner()) {
            this.slots.add(slot);
        }
    }
}

