/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ModSettings;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandshake;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class MapFrontiersClient {
    private static IClientAPI jmAPI;
    private static boolean handshakeSended;
    private static FrontiersOverlayManager frontiersOverlayManager;
    private static FrontiersOverlayManager personalFrontiersOverlayManager;
    private static SettingsProfile settingsProfile;
    private static ModSettings.Tab lastSettingsTab;
    protected static KeyMapping openSettingsKey;
    private static HUD hud;
    private static BlockPos lastPlayerPosition;
    private static final Set<FrontierOverlay> insideFrontiers;
    private static FrontierData clipboard;

    protected static void init() {
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent(MapFrontiersClient.class, profile -> {
            settingsProfile = profile;
        });
        ClientEventHandler.subscribeClientTickEvent(MapFrontiersClient.class, client -> {
            if (client.f_91073_ == null) {
                return;
            }
            if (!handshakeSended) {
                handshakeSended = true;
                PacketHandler.sendToServer(new PacketHandshake());
            }
            if (frontiersOverlayManager != null) {
                frontiersOverlayManager.updateAllOverlays(false);
                personalFrontiersOverlayManager.updateAllOverlays(false);
            }
            if (hud != null) {
                hud.tick();
            }
        });
        ClientEventHandler.subscribePlayerTickEvent(MapFrontiersClient.class, (client, player) -> {
            if (client.f_91073_ == null) {
                return;
            }
            if (frontiersOverlayManager == null) {
                return;
            }
            while (openSettingsKey != null && openSettingsKey.m_90859_()) {
                client.m_91152_((Screen)new ModSettings(null, false));
            }
            if (player == null) {
                return;
            }
            BlockPos currentPlayerPosition = player.m_20183_();
            if (currentPlayerPosition.m_123341_() != lastPlayerPosition.m_123341_() || currentPlayerPosition.m_123343_() != lastPlayerPosition.m_123343_()) {
                lastPlayerPosition = currentPlayerPosition;
                Set<FrontierOverlay> frontiers = personalFrontiersOverlayManager.getFrontiersForAnnounce((ResourceKey<Level>)player.m_9236_().m_46472_(), lastPlayerPosition);
                frontiers.addAll(frontiersOverlayManager.getFrontiersForAnnounce((ResourceKey<Level>)player.m_9236_().m_46472_(), lastPlayerPosition));
                Iterator<FrontierOverlay> i = insideFrontiers.iterator();
                while (i.hasNext()) {
                    FrontierOverlay inside = i.next();
                    if (!frontiers.stream().noneMatch(f -> f.getId().equals(inside.getId()))) continue;
                    if (inside.getAnnounceInChat() && (inside.isNamed() || Config.announceUnnamedFrontiers)) {
                        player.m_5661_((Component)Component.m_237110_((String)"mapfrontiers.chat.leaving", (Object[])new Object[]{MapFrontiersClient.createAnnounceTextWithName(inside)}), false);
                    }
                    i.remove();
                }
                for (FrontierOverlay frontier : frontiers) {
                    if (!insideFrontiers.add(frontier) || !frontier.isNamed() && !Config.announceUnnamedFrontiers) continue;
                    Component text = MapFrontiersClient.createAnnounceTextWithName(frontier);
                    if (frontier.getAnnounceInChat()) {
                        player.m_5661_((Component)Component.m_237110_((String)"mapfrontiers.chat.entering", (Object[])new Object[]{text}), false);
                    }
                    if (!frontier.getAnnounceInTitle()) continue;
                    if (Config.titleAnnouncementAboveHotbar) {
                        client.f_91065_.m_93063_(text, false);
                        continue;
                    }
                    client.f_91065_.m_168714_(text);
                }
            }
        });
        ClientEventHandler.subscribeHudRenderEvent(MapFrontiersClient.class, (graphics, delta) -> {
            if (hud != null) {
                hud.drawInGameHUD((GuiGraphics)graphics, delta.floatValue());
            }
        });
        ClientEventHandler.subscribeClientConnectedEvent(MapFrontiersClient.class, () -> {
            MapFrontiersClient.initializeManagers();
            hud = new HUD(frontiersOverlayManager, personalFrontiersOverlayManager);
            MapFrontiers.LOGGER.info("ClientConnectedEvent done");
        });
        ClientEventHandler.subscribeClientDisconnectedEvent(MapFrontiersClient.class, () -> {
            if (frontiersOverlayManager != null) {
                frontiersOverlayManager.close();
                frontiersOverlayManager = null;
                personalFrontiersOverlayManager.close();
                personalFrontiersOverlayManager = null;
            }
            if (hud != null) {
                hud = null;
            }
            settingsProfile = null;
            handshakeSended = false;
            MapFrontiers.LOGGER.info("ClientDisconnectedEvent done");
        });
    }

    private static Component createAnnounceTextWithName(FrontierOverlay frontier) {
        if (!frontier.isNamed()) {
            MutableComponent text = Component.m_237110_((String)"mapfrontiers.unnamed", (Object[])new Object[]{ChatFormatting.ITALIC});
            text.m_130938_(style -> style.m_131155_(Boolean.valueOf(true)).m_178520_(0xAAAAAA));
            return text;
        }
        Object name = frontier.getName1().trim();
        String name2 = frontier.getName2().trim();
        if (!StringUtils.isBlank((CharSequence)name2)) {
            if (!((String)name).isEmpty()) {
                name = (String)name + " ";
            }
            name = (String)name + name2;
        }
        MutableComponent text = Component.m_237113_((String)name);
        text.m_130938_(style -> style.m_178520_(frontier.getColor()));
        return text;
    }

    public static void setjmAPI(IClientAPI newJmAPI) {
        jmAPI = newJmAPI;
    }

    private static void initializeManagers() {
        if (jmAPI == null) {
            return;
        }
        if (frontiersOverlayManager == null) {
            frontiersOverlayManager = new FrontiersOverlayManager(jmAPI, false);
        }
        if (personalFrontiersOverlayManager == null) {
            personalFrontiersOverlayManager = new FrontiersOverlayManager(jmAPI, true);
        }
    }

    public static void setFrontiersFromServer(List<FrontierData> globalFrontiers, List<FrontierData> personalFrontiers) {
        MapFrontiersClient.initializeManagers();
        frontiersOverlayManager.setFrontiersFromServer(globalFrontiers);
        personalFrontiersOverlayManager.setFrontiersFromServer(personalFrontiers);
        if (hud != null) {
            hud.frontierChanged();
        }
    }

    public static FrontiersOverlayManager getFrontiersOverlayManager(boolean personal) {
        MapFrontiersClient.initializeManagers();
        if (personal) {
            return personalFrontiersOverlayManager;
        }
        return frontiersOverlayManager;
    }

    public static SettingsProfile getSettingsProfile() {
        return settingsProfile;
    }

    public static void setLastSettingsTab(ModSettings.Tab tab) {
        lastSettingsTab = tab;
    }

    public static ModSettings.Tab getLastSettingsTab() {
        return lastSettingsTab;
    }

    public static Component getOpenSettingsKey() {
        if (openSettingsKey == null || openSettingsKey.m_90862_()) {
            return null;
        }
        return openSettingsKey.m_90863_();
    }

    public static boolean isModOnServer() {
        return settingsProfile != null;
    }

    public static void setClipboard(FrontierData newClipboard) {
        clipboard = new FrontierData(newClipboard);
    }

    public static FrontierData getClipboard() {
        return clipboard;
    }

    static {
        handshakeSended = false;
        lastSettingsTab = ModSettings.Tab.Credits;
        lastPlayerPosition = new BlockPos(0, 0, 0);
        insideFrontiers = new HashSet<FrontierOverlay>();
        clipboard = null;
    }
}

