/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.common.Config;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

@ParametersAreNonnullByDefault
public class SimpleLabel
extends AbstractWidgetNoNarration {
    private final Font font;
    private float scale = 1.0f;
    private int color;
    private final Align align;
    private List<String> texts;
    private List<Integer> widths;
    private Config.Point topLeft;
    private Config.Point bottomRight;

    public SimpleLabel(Font font, int x, int y, Align align, Component text, int color) {
        super(x, y, 0, 0, text);
        this.font = font;
        this.color = color;
        this.align = align;
        this.setText(text);
    }

    public void setText(Component text) {
        this.texts = new ArrayList<String>();
        this.widths = new ArrayList<Integer>();
        for (String t : text.getString().split("\\R")) {
            this.texts.add(t);
            this.widths.add(this.font.m_92895_(t));
        }
        this.topLeft = new Config.Point();
        this.bottomRight = new Config.Point();
        this.bottomRight.y = this.texts.size() * 12;
        if (this.align == Align.Left) {
            for (int i = 0; i < this.texts.size(); ++i) {
                width = this.widths.get(i);
                if (width <= this.bottomRight.x) continue;
                this.bottomRight.x = width;
            }
        } else if (this.align == Align.Center) {
            for (int i = 0; i < this.texts.size(); ++i) {
                int halfWidth = this.widths.get(i) / 2;
                if (-halfWidth < this.topLeft.x) {
                    this.topLeft.x = -halfWidth;
                }
                if (halfWidth <= this.bottomRight.x) continue;
                this.bottomRight.x = halfWidth;
            }
        } else {
            for (int i = 0; i < this.texts.size(); ++i) {
                width = this.widths.get(i);
                if (-width >= this.topLeft.x) continue;
                this.topLeft.x = -width;
            }
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280168_().m_85841_(this.scale, this.scale, 1.0f);
        if (this.align == Align.Left) {
            for (int i = 0; i < this.texts.size(); ++i) {
                graphics.m_280488_(this.font, this.texts.get(i), Mth.m_14143_((float)((float)this.m_252754_() / this.scale)), Mth.m_14143_((float)((float)(this.m_252907_() + i * 12) / this.scale)), this.color);
            }
        } else if (this.align == Align.Center) {
            for (int i = 0; i < this.texts.size(); ++i) {
                graphics.m_280488_(this.font, this.texts.get(i), Mth.m_14143_((float)((float)this.m_252754_() / this.scale - (float)(this.widths.get(i) - 1) / 2.0f)), Mth.m_14143_((float)((float)(this.m_252907_() + i * 12) / this.scale)), this.color);
            }
        } else {
            for (int i = 0; i < this.texts.size(); ++i) {
                graphics.m_280488_(this.font, this.texts.get(i), Mth.m_14143_((float)((float)this.m_252754_() / this.scale - (float)this.widths.get(i).intValue())), Mth.m_14143_((float)((float)(this.m_252907_() + i * 12) / this.scale)), this.color);
            }
        }
        this.f_93622_ = (float)mouseX >= (float)this.topLeft.x * this.scale + (float)this.m_252754_() && (float)mouseY >= (float)this.topLeft.y * this.scale + (float)this.m_252907_() && (float)mouseX < (float)this.bottomRight.x * this.scale + (float)this.m_252754_() && (float)mouseY < (float)this.bottomRight.y * this.scale + (float)this.m_252907_();
        graphics.m_280168_().m_85841_(1.0f / this.scale, 1.0f / this.scale, 1.0f);
    }

    public static enum Align {
        Left,
        Center,
        Right;

    }
}

