/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;

public class SimpleSlider
extends AbstractSliderButton {
    private final Font font;
    private final int minValue;
    private final int maxValue;
    private final ValueChanged callback;
    private boolean dragging = false;
    private String translationKey;
    private SimpleLabel label;
    private int textColor = -6710887;
    private int textColorHighlight = -1;

    public SimpleSlider(Font font, int x, int y, int width, String translationKey, int minValue, int maxValue, int initialValue, ValueChanged callback) {
        super(x, y, width, 16, (Component)Component.m_237113_((String)String.valueOf(initialValue)), SimpleSlider.normalize(initialValue, minValue, maxValue));
        this.font = font;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.callback = callback;
        this.translationKey = translationKey;
        this.label = new SimpleLabel(font, this.m_252754_() + width / 2, this.m_252907_() + 5, SimpleLabel.Align.Center, (Component)Component.m_237110_((String)translationKey, (Object[])new Object[]{this.denormalize(this.f_93577_)}), this.textColor);
        this.m_5695_();
    }

    private static double normalize(int value, int min, int max) {
        return (double)(value - min) / (double)(max - min);
    }

    private int denormalize(double value) {
        return (int)Math.round((double)this.minValue + value * (double)(this.maxValue - this.minValue));
    }

    protected void m_5695_() {
        int val = this.denormalize(this.f_93577_);
        this.label.setText((Component)Component.m_237110_((String)this.translationKey, (Object[])new Object[]{val}));
    }

    protected void m_5697_() {
        int val = this.denormalize(this.f_93577_);
        this.callback.onChanged(val, this.dragging);
    }

    public void setValue(int value) {
        this.f_93577_ = SimpleSlider.normalize(value, this.minValue, this.maxValue);
        this.m_5695_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.f_93624_ && this.f_93622_) {
            int val = this.denormalize(this.f_93577_);
            val = delta > 0.0 ? Math.min(val + 1, this.maxValue) : Math.max(val - 1, this.minValue);
            this.setValue(val);
            this.m_5697_();
            return true;
        }
        return false;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.dragging = true;
        super.m_7212_(mouseX, mouseY, dragX, dragY);
    }

    public void mouseReleased() {
        if (this.dragging) {
            this.dragging = false;
            this.m_5697_();
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_93622_) {
            this.label.setColor(this.textColorHighlight);
        } else {
            this.label.setColor(this.textColor);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280656_(this.m_252754_(), this.m_252754_() + this.f_93618_, this.m_252907_(), -8947849);
        graphics.m_280656_(this.m_252754_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 16, -8947849);
        graphics.m_280315_(this.m_252754_(), this.m_252907_(), this.m_252907_() + 16, -8947849);
        graphics.m_280315_(this.m_252754_() + this.f_93618_, this.m_252907_(), this.m_252907_() + 16, -8947849);
        int handleX = this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 5)) + 1;
        graphics.m_280509_(handleX, this.m_252907_() + 1, handleX + 4, this.m_252907_() + 16, this.m_198029_() ? -1 : -5592406);
        this.label.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public static interface ValueChanged {
        public void onChanged(int var1, boolean var2);
    }
}

