/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class ShapeChunkButtons
extends AbstractWidgetNoNarration {
    private static final ResourceLocation texture = new ResourceLocation("mapfrontiers:textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private int size;
    private final SimpleLabel labelShapes;
    private final SimpleLabel labelChunks;
    private final Consumer<ShapeChunkButtons> callbackShapeUpdated;

    public ShapeChunkButtons(Font font, int x, int y, int selected, Consumer<ShapeChunkButtons> callbackShapeUpdated) {
        super(x, y, 214, 120, (Component)Component.m_237119_());
        this.selected = selected;
        this.labelShapes = new SimpleLabel(font, x + 107, y, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.initial_shape"), -1);
        this.labelChunks = new SimpleLabel(font, x + 107, y + 126, SimpleLabel.Align.Center, (Component)Component.m_237113_((String)""), -1);
        this.callbackShapeUpdated = callbackShapeUpdated;
        this.updateChunksLabel();
    }

    public void setSize(int size) {
        this.size = Math.min(Math.max(size, 1), 32);
        this.updateChunksLabel();
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2 || this.selected == 7) {
            return ShapeMeasure.None;
        }
        if (this.selected < 5) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Length;
    }

    public boolean m_93680_(double mouseX, double mouseY) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        return mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.m_93680_(mouseX, mouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        double col = (mouseX - (double)this.m_252754_() + 3.0) / 55.0;
        double row = (mouseY - (double)this.m_252907_() - 13.0) / 55.0;
        if (col >= 0.0 && col < 4.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 4;
            this.updateChunksLabel();
            this.callbackShapeUpdated.accept(this);
        }
    }

    public void m_7435_(SoundManager soundHandlerIn) {
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int col = 0;
        int row = 0;
        for (int i = 0; i < 8; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.m_280163_(texture, this.m_252754_() + col * 55, this.m_252907_() + row * 55 + 16, (float)(texX + 588), (float)texY, 49, 49, 980, 98);
            if (++col != 4) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.labelChunks.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void updateChunksLabel() {
        int chunks = 0;
        switch (this.selected) {
            case 1: {
                chunks = 1;
                break;
            }
            case 2: {
                chunks = this.size * this.size;
                break;
            }
            case 3: {
                chunks = Math.max(1, (this.size - 1) * 4);
                break;
            }
            case 4: {
                chunks = (this.size * this.size + 1) / 2;
                if (this.size % 2 != 0) break;
                chunks += this.size;
                break;
            }
            case 5: 
            case 6: {
                chunks = this.size;
                break;
            }
            case 7: {
                chunks = 1024;
            }
        }
        this.labelChunks.setText((Component)Component.m_237110_((String)"mapfrontiers.chunks", (Object[])new Object[]{chunks}));
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Length;

    }
}

