/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;

@ParametersAreNonnullByDefault
public class ShapeVertexButtons
extends AbstractWidgetNoNarration {
    private static final int[] vertexCount = new int[]{0, 1, 3, 3, 3, 3, 4, 4, 6, 6, 8, 16};
    private static final double[] vertexAngle = new double[]{0.0, 0.0, -90.0, 0.0, 90.0, 180.0, 45.0, 0.0, 30.0, 0.0, 22.5, 0.0};
    private static final ResourceLocation texture = new ResourceLocation("mapfrontiers:textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private final SimpleLabel labelShapes;
    private final SimpleLabel labelVertices;
    private final Consumer<ShapeVertexButtons> callbackShapeUpdated;

    public ShapeVertexButtons(Font font, int x, int y, int selected, Consumer<ShapeVertexButtons> callbackShapeUpdated) {
        super(x, y, 324, 120, (Component)Component.m_237119_());
        this.selected = selected;
        this.labelShapes = new SimpleLabel(font, x + 162, y, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.initial_shape"), -1);
        this.labelVertices = new SimpleLabel(font, x + 162, y + 126, SimpleLabel.Align.Center, (Component)Component.m_237113_((String)""), -1);
        this.callbackShapeUpdated = callbackShapeUpdated;
        this.updateVertexLabel();
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2) {
            return ShapeMeasure.None;
        }
        if (this.selected < 7) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Radius;
    }

    public List<Vec2> getVertices() {
        if (vertexCount[this.selected] == 0) {
            return null;
        }
        ArrayList<Vec2> vertices = new ArrayList<Vec2>();
        if (vertexCount[this.selected] == 1) {
            vertices.add(Vec2.f_82462_);
            return vertices;
        }
        double angle = vertexAngle[this.selected] / 180.0 * Math.PI;
        for (int i = 0; i < vertexCount[this.selected]; ++i) {
            double vertexAngle = Math.PI * 2 / (double)vertexCount[this.selected] * (double)i + angle;
            vertices.add(new Vec2((float)Math.cos(vertexAngle), (float)Math.sin(vertexAngle)));
        }
        return vertices;
    }

    public boolean m_93680_(double mouseX, double mouseY) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        return mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.m_93680_(mouseX, mouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        double col = (mouseX - (double)this.m_252754_() + 3.0) / 55.0;
        double row = (mouseY - (double)this.m_252907_() - 13.0) / 55.0;
        if (col >= 0.0 && col < 6.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 6;
            this.updateVertexLabel();
            this.callbackShapeUpdated.accept(this);
        }
    }

    public void m_7435_(SoundManager soundHandlerIn) {
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int col = 0;
        int row = 0;
        for (int i = 0; i < 12; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.m_280163_(texture, this.m_252754_() + col * 55, this.m_252907_() + row * 55 + 16, (float)texX, (float)texY, 49, 49, 980, 98);
            if (++col != 6) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.labelVertices.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void updateVertexLabel() {
        this.labelVertices.setText((Component)Component.m_237110_((String)"mapfrontiers.vertices", (Object[])new Object[]{vertexCount[this.selected]}));
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Radius;

    }
}

