/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsGroup;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

@ParametersAreNonnullByDefault
public class GroupActionElement
extends ScrollBox.ScrollElement {
    private final Font font;
    private final SettingsGroup group;
    private final ActionChangedConsumer actionChangedCallback;
    private final boolean ownersGroup;
    private boolean createFrontier;
    private boolean deleteFrontier;
    private boolean updateFrontier;
    private boolean updateSettings;
    private boolean personalFrontier;

    public GroupActionElement(Font font, SettingsGroup group, ActionChangedConsumer actionChangedCallback) {
        this(font, group, false, actionChangedCallback);
    }

    public GroupActionElement(Font font, SettingsGroup group, boolean ownersGroup, ActionChangedConsumer actionChangedCallback) {
        super(430, 16);
        this.font = font;
        this.group = group;
        this.actionChangedCallback = actionChangedCallback;
        this.ownersGroup = ownersGroup;
        this.createFrontier = group.hasAction(FrontierSettings.Action.CreateGlobalFrontier);
        this.deleteFrontier = group.hasAction(FrontierSettings.Action.DeleteGlobalFrontier);
        this.updateFrontier = group.hasAction(FrontierSettings.Action.UpdateGlobalFrontier);
        this.updateSettings = group.hasAction(FrontierSettings.Action.UpdateSettings);
        this.personalFrontier = group.hasAction(FrontierSettings.Action.SharePersonalFrontier);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected) {
        String text;
        if (this.isHovered) {
            graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, -1608375774);
        }
        if ((text = this.group.getName()).isEmpty()) {
            text = I18n.m_118938_((String)"mapfrontiers.unnamed", (Object[])new Object[]{ChatFormatting.ITALIC});
        }
        graphics.m_280488_(this.font, text, this.x + 4, this.y + 4, -1);
        if (!this.ownersGroup) {
            this.drawBox(graphics, this.x + 154, this.y + 2, this.createFrontier);
        }
        this.drawBox(graphics, this.x + 214, this.y + 2, this.deleteFrontier);
        this.drawBox(graphics, this.x + 274, this.y + 2, this.updateFrontier);
        if (!this.ownersGroup) {
            this.drawBox(graphics, this.x + 334, this.y + 2, this.updateSettings);
            this.drawBox(graphics, this.x + 394, this.y + 2, this.personalFrontier);
        }
    }

    @Override
    public ScrollBox.ScrollElement.Action mousePressed(double mouseX, double mouseY) {
        if (this.visible && this.isHovered && this.actionChangedCallback != null) {
            if (!this.ownersGroup && mouseX >= (double)(this.x + 130) && mouseX <= (double)(this.x + 190)) {
                this.createFrontier = !this.createFrontier;
                this.actionChangedCallback.accept(this.group, FrontierSettings.Action.CreateGlobalFrontier, this.createFrontier);
            } else if (mouseX >= (double)(this.x + 190) && mouseX <= (double)(this.x + 250)) {
                this.deleteFrontier = !this.deleteFrontier;
                this.actionChangedCallback.accept(this.group, FrontierSettings.Action.DeleteGlobalFrontier, this.deleteFrontier);
            } else if (mouseX >= (double)(this.x + 250) && mouseX <= (double)(this.x + 310)) {
                this.updateFrontier = !this.updateFrontier;
                this.actionChangedCallback.accept(this.group, FrontierSettings.Action.UpdateGlobalFrontier, this.updateFrontier);
            } else if (!this.ownersGroup && mouseX >= (double)(this.x + 310) && mouseX <= (double)(this.x + 370)) {
                this.updateSettings = !this.updateSettings;
                this.actionChangedCallback.accept(this.group, FrontierSettings.Action.UpdateSettings, this.updateSettings);
            } else if (!this.ownersGroup && mouseX >= (double)(this.x + 370) && mouseX <= (double)(this.x + 430)) {
                this.personalFrontier = !this.personalFrontier;
                this.actionChangedCallback.accept(this.group, FrontierSettings.Action.SharePersonalFrontier, this.personalFrontier);
            }
        }
        return ScrollBox.ScrollElement.Action.None;
    }

    private void drawBox(GuiGraphics graphics, int x, int y, boolean checked) {
        graphics.m_280509_(x, y, x + 12, y + 12, -12303292);
        graphics.m_280509_(x + 1, y + 1, x + 11, y + 11, -16777216);
        if (checked) {
            graphics.m_280509_(x + 2, y + 2, x + 10, y + 10, -10066330);
        }
    }

    @FunctionalInterface
    public static interface ActionChangedConsumer {
        public void accept(SettingsGroup var1, FrontierSettings.Action var2, boolean var3);
    }
}

