/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class HUD {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final FrontiersOverlayManager frontiersOverlayManager;
    private final FrontiersOverlayManager personalFrontiersOverlayManager;
    private FrontierOverlay frontier;
    private int frontierHash;
    private BlockPos lastPlayerPosition = new BlockPos(0, 0, 0);
    private final SimpleLabel frontierName1;
    private final SimpleLabel frontierName2;
    private final SimpleLabel frontierOwner;
    private final List<Config.HUDSlot> slots;
    private int posX = 0;
    private int posY = 0;
    private int nameOffsetY = 0;
    private int ownerOffsetY = 0;
    private int bannerOffsetY = 0;
    private int hudWidth = 0;
    private int hudHeight = 0;
    private int textScale = 1;
    private int bannerScale = 1;
    private boolean needUpdate = true;
    private boolean previewMode = false;
    private int displayWidth;
    private int displayHeight;

    public static HUD asPreview() {
        HUD hud = new HUD(null, null);
        hud.previewMode = true;
        ItemStack itemBanner = new ItemStack((ItemLike)Items.f_42728_);
        CompoundTag entityTag = itemBanner.m_41698_("BlockEntityTag");
        ListTag patterns = new BannerPattern.Builder().m_222705_(BannerPatterns.f_222723_, DyeColor.GREEN).m_222705_(BannerPatterns.f_222719_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222715_, DyeColor.LIGHT_BLUE).m_222705_(BannerPatterns.f_222743_, DyeColor.LIGHT_BLUE).m_222705_(BannerPatterns.f_222742_, DyeColor.BLACK).m_222705_(BannerPatterns.f_222731_, DyeColor.GREEN).m_58587_();
        entityTag.m_128365_("Patterns", (Tag)patterns);
        FrontierData frontierData = new FrontierData();
        frontierData.setOwner(new SettingsUser((Player)HUD.mc.f_91074_));
        frontierData.setName1("Preview Frontier");
        frontierData.setName2("-----------------");
        frontierData.setBanner(itemBanner);
        hud.frontier = new FrontierOverlay(frontierData, null);
        return hud;
    }

    public HUD(@Nullable FrontiersOverlayManager frontiersOverlayManager, @Nullable FrontiersOverlayManager personalFrontiersOverlayManager) {
        this.frontiersOverlayManager = frontiersOverlayManager;
        this.personalFrontiersOverlayManager = personalFrontiersOverlayManager;
        this.slots = new ArrayList<Config.HUDSlot>();
        this.frontierName1 = new SimpleLabel(HUD.mc.f_91062_, 0, 0, SimpleLabel.Align.Center, (Component)Component.m_237119_(), -1);
        this.frontierName2 = new SimpleLabel(HUD.mc.f_91062_, 0, 0, SimpleLabel.Align.Center, (Component)Component.m_237119_(), -1);
        this.frontierOwner = new SimpleLabel(HUD.mc.f_91062_, 0, 0, SimpleLabel.Align.Center, (Component)Component.m_237119_(), -1);
        ClientEventHandler.subscribeDeletedFrontierEvent(this, frontierID -> this.frontierChanged());
        ClientEventHandler.subscribeNewFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedFrontierEvent(this, (frontierOverlay, playerID) -> this.frontierChanged());
        ClientEventHandler.subscribeUpdatedConfigEvent(this, this::configUpdated);
    }

    public int getWidth() {
        return this.hudWidth;
    }

    public int getHeight() {
        return this.hudHeight;
    }

    public boolean isInside(int x, int y) {
        return x >= this.posX && x < this.posX + this.hudWidth && y >= this.posY && y < this.posY + this.hudHeight;
    }

    public void tick() {
        if (this.previewMode || this.frontiersOverlayManager == null || this.personalFrontiersOverlayManager == null || HUD.mc.f_91074_ == null) {
            return;
        }
        BlockPos currentPlayerPosition = HUD.mc.f_91074_.m_20183_();
        if (currentPlayerPosition.m_123341_() != this.lastPlayerPosition.m_123341_() || currentPlayerPosition.m_123343_() != this.lastPlayerPosition.m_123343_()) {
            this.lastPlayerPosition = currentPlayerPosition;
            FrontierOverlay newFrontier = this.personalFrontiersOverlayManager.getFrontierInPosition((ResourceKey<Level>)HUD.mc.f_91074_.m_9236_().m_46472_(), this.lastPlayerPosition);
            if (newFrontier == null) {
                newFrontier = this.frontiersOverlayManager.getFrontierInPosition((ResourceKey<Level>)HUD.mc.f_91074_.m_9236_().m_46472_(), this.lastPlayerPosition);
            }
            if (newFrontier != null) {
                if (this.frontierHash != newFrontier.getHash()) {
                    this.frontier = newFrontier;
                    this.frontierHash = newFrontier.getHash();
                    this.needUpdate = true;
                }
            } else if (this.frontier != null) {
                this.frontier = null;
                this.frontierHash = 0;
                this.needUpdate = true;
            }
        }
        if (this.frontier != null && this.frontierHash != this.frontier.getHash()) {
            this.frontierHash = this.frontier.getHash();
            this.needUpdate = true;
        }
    }

    public void configUpdated() {
        if (this.previewMode) {
            this.updateData();
        } else {
            this.needUpdate = true;
        }
    }

    public void frontierChanged() {
        if (this.previewMode || this.frontiersOverlayManager == null || this.personalFrontiersOverlayManager == null) {
            return;
        }
        FrontierOverlay newFrontier = this.personalFrontiersOverlayManager.getFrontierInPosition((ResourceKey<Level>)HUD.mc.f_91074_.m_9236_().m_46472_(), this.lastPlayerPosition);
        if (newFrontier == null) {
            newFrontier = this.frontiersOverlayManager.getFrontierInPosition((ResourceKey<Level>)HUD.mc.f_91074_.m_9236_().m_46472_(), this.lastPlayerPosition);
        }
        if (newFrontier != null) {
            if (this.frontierHash != newFrontier.getHash()) {
                this.frontier = newFrontier;
                this.frontierHash = newFrontier.getHash();
                this.needUpdate = true;
            }
        } else if (this.frontier != null) {
            this.frontier = null;
            this.frontierHash = 0;
            this.needUpdate = true;
        }
    }

    public void drawInGameHUD(GuiGraphics graphics, float partialTicks) {
        if (this.previewMode) {
            return;
        }
        if (HUD.mc.f_91080_ != null && !(HUD.mc.f_91080_ instanceof ChatScreen)) {
            return;
        }
        if (this.frontier == null) {
            return;
        }
        if (!Config.hudEnabled) {
            return;
        }
        this.draw(graphics, partialTicks);
    }

    public void draw(GuiGraphics graphics, float partialTicks) {
        if (this.displayWidth != mc.m_91268_().m_85441_() || this.displayHeight != mc.m_91268_().m_85442_()) {
            this.needUpdate = true;
        }
        if ((Config.hudAnchor == Config.HUDAnchor.Minimap || Config.hudAnchor == Config.HUDAnchor.MinimapHorizontal || Config.hudAnchor == Config.HUDAnchor.MinimapVertical) && Services.JOURNEYMAP.minimapPropertiesChanged()) {
            this.needUpdate = true;
        }
        if (this.needUpdate) {
            this.needUpdate = false;
            this.updateData();
        }
        if (this.slots.isEmpty()) {
            return;
        }
        float factor = (float)mc.m_91268_().m_85449_();
        int frameColor = Services.JOURNEYMAP.minimapLabelBackgroundColor();
        int textNameColor = Services.JOURNEYMAP.minimapLabelHighlightColor();
        int textOwnerColor = Services.JOURNEYMAP.minimapLabelForegroundColor();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(1.0f / factor, 1.0f / factor, 1.0f);
        graphics.m_280168_().m_85837_(0.0, 0.0, -100.0);
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.drawName(graphics, frameColor, textNameColor, partialTicks);
                    break;
                }
                case Owner: {
                    this.drawOwner(graphics, frameColor, textOwnerColor, partialTicks);
                    break;
                }
                case Banner: {
                    this.drawBanner(graphics, frameColor);
                    break;
                }
            }
        }
        graphics.m_280168_().m_85849_();
        GlStateManager._enableBlend();
    }

    private void drawName(GuiGraphics graphics, int frameColor, int textColor, float partialTicks) {
        graphics.m_280509_(this.posX, this.posY + this.nameOffsetY, this.posX + this.hudWidth, this.posY + this.nameOffsetY + 24 * this.textScale, frameColor);
        this.frontierName1.setColor(textColor);
        this.frontierName2.setColor(textColor);
        this.frontierName1.m_88315_(graphics, 0, 0, partialTicks);
        this.frontierName2.m_88315_(graphics, 0, 0, partialTicks);
    }

    private void drawOwner(GuiGraphics graphics, int frameColor, int textColor, float partialTicks) {
        graphics.m_280509_(this.posX, this.posY + this.ownerOffsetY, this.posX + this.hudWidth, this.posY + this.ownerOffsetY + 12 * this.textScale, frameColor);
        this.frontierOwner.setColor(textColor);
        this.frontierOwner.m_88315_(graphics, 0, 0, partialTicks);
    }

    private void drawBanner(GuiGraphics graphics, int frameColor) {
        int bannerX = this.posX + this.hudWidth / 2 - 11 * this.bannerScale;
        int bannerY = this.posY + this.bannerOffsetY + 2;
        int[] bannerBounds = this.frontier.getBannerBounds(bannerX, bannerY, this.bannerScale);
        graphics.m_280509_(bannerBounds[0] - 2, bannerBounds[1] - 2, bannerBounds[2] + 2, bannerBounds[3] + 2, frameColor);
        this.frontier.renderBanner(mc, graphics, bannerX, bannerY, this.bannerScale);
    }

    private void updateData() {
        int[] bannerBounds;
        String owner;
        this.displayWidth = mc.m_91268_().m_85441_();
        this.displayHeight = mc.m_91268_().m_85442_();
        this.slots.clear();
        if (this.frontier == null) {
            return;
        }
        this.addSlot(Config.hudSlot1);
        this.addSlot(Config.hudSlot2);
        this.addSlot(Config.hudSlot3);
        if (this.slots.isEmpty()) {
            return;
        }
        this.hudWidth = 0;
        this.hudHeight = 0;
        this.bannerScale = Config.hudBannerSize;
        this.textScale = Services.JOURNEYMAP.getMinimapFontScale();
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    int name1Width = HUD.mc.f_91062_.m_92895_(this.frontier.getName1()) + 3;
                    int name2Width = HUD.mc.f_91062_.m_92895_(this.frontier.getName2()) + 3;
                    int nameWidth = Math.max(name1Width, name2Width) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, nameWidth);
                    this.hudHeight += 24 * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    int ownerWidth = (HUD.mc.f_91062_.m_92895_(owner) + 3) * this.textScale;
                    this.hudWidth = Math.max(this.hudWidth, ownerWidth);
                    this.hudHeight += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    bannerBounds = this.frontier.getBannerBounds(0, 0, this.bannerScale);
                    this.hudWidth = Math.max(this.hudWidth, bannerBounds[2] - bannerBounds[0] + 4);
                    this.hudHeight += bannerBounds[3] - bannerBounds[1] + 4;
                    break;
                }
            }
        }
        Config.Point anchorPos = Config.getHUDAnchor(Config.hudAnchor);
        Config.Point originPos = Config.getHUDOrigin(Config.hudAnchor, this.hudWidth, this.hudHeight);
        this.posX = anchorPos.x - originPos.x + Config.hudXPosition;
        this.posY = anchorPos.y - originPos.y + Config.hudYPosition;
        int offsetY = 0;
        this.nameOffsetY = 0;
        this.ownerOffsetY = 0;
        this.bannerOffsetY = 0;
        for (Config.HUDSlot slot : this.slots) {
            switch (slot) {
                case Name: {
                    this.nameOffsetY = offsetY;
                    this.frontierName1.m_252865_(this.posX + this.hudWidth / 2);
                    this.frontierName1.m_253211_(this.posY + this.nameOffsetY + 2 * this.textScale);
                    this.frontierName1.setScale(this.textScale);
                    this.frontierName1.setText((Component)Component.m_237113_((String)this.frontier.getName1()));
                    this.frontierName2.m_252865_(this.posX + this.hudWidth / 2);
                    this.frontierName2.m_253211_(this.posY + this.nameOffsetY + 14 * this.textScale);
                    this.frontierName2.setScale(this.textScale);
                    this.frontierName2.setText((Component)Component.m_237113_((String)this.frontier.getName2()));
                    offsetY += 24 * this.textScale;
                    break;
                }
                case Owner: {
                    if (this.frontier.getOwner().isEmpty()) break;
                    owner = this.getOwnerString();
                    this.ownerOffsetY = offsetY;
                    this.frontierOwner.m_252865_(this.posX + this.hudWidth / 2);
                    this.frontierOwner.m_253211_(this.posY + this.ownerOffsetY + 2);
                    this.frontierOwner.setScale(this.textScale);
                    this.frontierOwner.setText((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.ITALIC) + owner)));
                    offsetY += 12 * this.textScale;
                    break;
                }
                case Banner: {
                    bannerBounds = this.frontier.getBannerBounds(0, 0, this.bannerScale);
                    int bannerHeight = bannerBounds[3] - bannerBounds[1];
                    this.bannerOffsetY = offsetY - bannerBounds[1];
                    offsetY += bannerHeight + 4;
                    break;
                }
            }
        }
    }

    private String getOwnerString() {
        Object ownerString = "";
        if (!StringUtils.isBlank((CharSequence)this.frontier.getOwner().username)) {
            ownerString = this.frontier.getOwner().username;
        } else if (this.frontier.getOwner().uuid != null) {
            ownerString = this.frontier.getOwner().uuid.toString();
            ownerString = ((String)ownerString).substring(0, 8) + "...";
        }
        return ownerString;
    }

    private void addSlot(Config.HUDSlot slot) {
        if (slot == Config.HUDSlot.Name) {
            if (this.frontier.isNamed()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Owner) {
            if (!this.frontier.getOwner().isEmpty()) {
                this.slots.add(slot);
            }
        } else if (slot == Config.HUDSlot.Banner && this.frontier.hasBanner()) {
            this.slots.add(slot);
        }
    }
}

