/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.FullscreenMap;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.FrontierListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.RadioListElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierInfo;
import games.alejandrocoria.mapfrontiers.client.gui.screen.NewFrontier;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class FrontierList
extends Screen {
    private final IClientAPI jmAPI;
    private final FullscreenMap fullscreenMap;
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private ScrollBox frontiers;
    private ScrollBox filterType;
    private ScrollBox filterOwner;
    private ScrollBox filterDimension;
    private SimpleButton buttonResetFilters;
    private SimpleButton buttonCreate;
    private SimpleButton buttonInfo;
    private SimpleButton buttonDelete;
    private SimpleButton buttonVisible;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels;

    public FrontierList(IClientAPI jmAPI, FullscreenMap fullscreenMap) {
        super((Component)Component.m_237115_((String)"mapfrontiers.title_frontiers"));
        this.jmAPI = jmAPI;
        this.fullscreenMap = fullscreenMap;
        this.labels = new ArrayList<SimpleLabel>();
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeNewFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            this.updateFrontiers();
            this.updateButtons();
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> this.updateButtons());
    }

    public void m_7856_() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.f_96541_, this, 772, 332);
        this.actualWidth = (int)((float)this.f_96543_ * this.scaleFactor);
        this.actualHeight = (int)((float)this.f_96544_ * this.scaleFactor);
        this.labels.clear();
        this.frontiers = new ScrollBox(this.actualWidth / 2 - 300, 50, 450, this.actualHeight - 100, 24);
        this.frontiers.setElementDeletedCallback(element -> this.updateButtons());
        this.frontiers.setElementClickedCallback(element -> {
            FrontierOverlay frontier = ((FrontierListElement)element).getFrontier();
            this.fullscreenMap.selectFrontier(frontier);
            this.updateButtons();
        });
        this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2 + 170, 74, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.filter_type"), -2236963));
        this.filterType = new ScrollBox(this.actualWidth / 2 + 170, 86, 200, 48, 16);
        this.filterType.addElement(new RadioListElement(this.f_96547_, Config.getTranslatedEnum(Config.FilterFrontierType.All), Config.FilterFrontierType.All.ordinal()));
        this.filterType.addElement(new RadioListElement(this.f_96547_, Config.getTranslatedEnum(Config.FilterFrontierType.Global), Config.FilterFrontierType.Global.ordinal()));
        this.filterType.addElement(new RadioListElement(this.f_96547_, Config.getTranslatedEnum(Config.FilterFrontierType.Personal), Config.FilterFrontierType.Personal.ordinal()));
        this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
        this.filterType.setElementDeletedCallback(element -> this.updateButtons());
        this.filterType.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierType = Config.FilterFrontierType.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2 + 170, 144, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.filter_owner"), -2236963));
        this.filterOwner = new ScrollBox(this.actualWidth / 2 + 170, 156, 200, 48, 16);
        this.filterOwner.addElement(new RadioListElement(this.f_96547_, Config.getTranslatedEnum(Config.FilterFrontierOwner.All), Config.FilterFrontierOwner.All.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.f_96547_, Config.getTranslatedEnum(Config.FilterFrontierOwner.You), Config.FilterFrontierOwner.You.ordinal()));
        this.filterOwner.addElement(new RadioListElement(this.f_96547_, Config.getTranslatedEnum(Config.FilterFrontierOwner.Others), Config.FilterFrontierOwner.Others.ordinal()));
        this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
        this.filterOwner.setElementDeletedCallback(element -> this.updateButtons());
        this.filterOwner.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierOwner = Config.FilterFrontierOwner.values()[selected];
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2 + 170, 214, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.filter_dimension"), -2236963));
        this.filterDimension = new ScrollBox(this.actualWidth / 2 + 170, 226, 200, this.actualHeight - 296, 16);
        this.filterDimension.addElement(new RadioListElement(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.config.All"), "all".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.f_96547_, (Component)Component.m_237115_((String)"mapfrontiers.config.Current"), "current".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.f_96547_, (Component)Component.m_237113_((String)"minecraft:overworld"), "minecraft:overworld".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.f_96547_, (Component)Component.m_237113_((String)"minecraft:the_nether"), "minecraft:the_nether".hashCode()));
        this.filterDimension.addElement(new RadioListElement(this.f_96547_, (Component)Component.m_237113_((String)"minecraft:the_end"), "minecraft:the_end".hashCode()));
        this.addDimensionsToFilter();
        this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        this.filterDimension.setElementDeletedCallback(element -> this.updateButtons());
        this.filterDimension.setElementClickedCallback(element -> {
            int selected = ((RadioListElement)element).getId();
            Config.filterFrontierDimension = selected == "all".hashCode() ? "all" : (selected == "current".hashCode() ? "current" : this.getDimensionFromHash(selected));
            this.updateFrontiers();
            ClientEventHandler.postUpdatedConfigEvent();
            this.updateButtons();
        });
        if (this.filterDimension.getSelectedElement() == null) {
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
        }
        this.buttonResetFilters = new SimpleButton(this.f_96547_, this.actualWidth / 2 + 170, 50, 110, (Component)Component.m_237115_((String)"mapfrontiers.reset_filters"), this::buttonPressed);
        this.buttonCreate = new SimpleButton(this.f_96547_, this.actualWidth / 2 - 295, this.actualHeight - 28, 110, (Component)Component.m_237115_((String)"mapfrontiers.create"), this::buttonPressed);
        this.buttonInfo = new SimpleButton(this.f_96547_, this.actualWidth / 2 - 175, this.actualHeight - 28, 110, (Component)Component.m_237115_((String)"mapfrontiers.info"), this::buttonPressed);
        this.buttonDelete = new SimpleButton(this.f_96547_, this.actualWidth / 2 - 55, this.actualHeight - 28, 110, (Component)Component.m_237115_((String)"mapfrontiers.delete"), this::buttonPressed);
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonVisible = new SimpleButton(this.f_96547_, this.actualWidth / 2 + 65, this.actualHeight - 28, 110, (Component)Component.m_237115_((String)"mapfrontiers.hide"), this::buttonPressed);
        this.buttonDone = new SimpleButton(this.f_96547_, this.actualWidth / 2 + 185, this.actualHeight - 28, 110, (Component)Component.m_237115_((String)"gui.done"), this::buttonPressed);
        this.m_142416_((GuiEventListener)this.frontiers);
        this.m_142416_((GuiEventListener)this.filterType);
        this.m_142416_((GuiEventListener)this.filterOwner);
        this.m_142416_((GuiEventListener)this.filterDimension);
        this.m_142416_((GuiEventListener)this.buttonResetFilters);
        this.m_142416_((GuiEventListener)this.buttonCreate);
        this.m_142416_((GuiEventListener)this.buttonInfo);
        this.m_142416_((GuiEventListener)this.buttonDelete);
        this.m_142416_((GuiEventListener)this.buttonVisible);
        this.m_142416_((GuiEventListener)this.buttonDone);
        this.updateFrontiers();
        if (this.fullscreenMap.getSelected() != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(this.fullscreenMap.getSelected().getId()));
        }
        this.updateButtons();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.actualWidth / 2, 8, -1);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_) continue;
            label.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6375_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        for (GuiEventListener w : this.m_6702_()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.m_7979_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void buttonPressed(Button button) {
        if (button == this.buttonResetFilters) {
            Config.filterFrontierType = Config.FilterFrontierType.All;
            this.filterType.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierType.ordinal());
            Config.filterFrontierOwner = Config.FilterFrontierOwner.All;
            this.filterOwner.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierOwner.ordinal());
            Config.filterFrontierDimension = "all";
            this.filterDimension.selectElementIf(element -> ((RadioListElement)element).getId() == Config.filterFrontierDimension.hashCode());
            this.updateFrontiers();
            this.updateButtons();
        } else if (button == this.buttonCreate) {
            Services.PLATFORM.popGuiLayer();
            Services.PLATFORM.pushGuiLayer(new NewFrontier(this.jmAPI));
        } else if (button == this.buttonInfo) {
            Services.PLATFORM.popGuiLayer();
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            Services.PLATFORM.pushGuiLayer(new FrontierInfo(this.jmAPI, frontier, () -> Services.PLATFORM.pushGuiLayer(new FrontierList(this.jmAPI, this.fullscreenMap))));
        } else if (button == this.buttonDelete) {
            FrontierOverlay frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
            FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
            frontierManager.clientDeleteFrontier(frontier);
            this.frontiers.removeElement(this.frontiers.getSelectedElement());
            this.updateButtons();
        } else if (button == this.buttonVisible) {
            FrontierOverlay frontier;
            frontier.setVisible(!(frontier = ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier()).getVisible());
            FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
            frontierManager.clientUpdateFrontier(frontier);
            this.updateButtons();
        } else if (button == this.buttonDone) {
            Services.PLATFORM.popGuiLayer();
        }
    }

    public void m_7861_() {
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    private void addDimensionsToFilter() {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.equals("minecraft:overworld") || dimension.equals("minecraft:the_nether") || dimension.equals("minecraft:the_end")) continue;
            this.filterDimension.addElement(new RadioListElement(this.f_96547_, (Component)Component.m_237113_((String)dimension), dimension.hashCode()));
        }
    }

    private String getDimensionFromHash(int hash) {
        List<String> dimensions = Services.JOURNEYMAP.getDimensionList();
        for (String dimension : dimensions) {
            if (dimension.hashCode() != hash) continue;
            return dimension;
        }
        return "";
    }

    private void updateFrontiers() {
        FrontierOverlay selectedFrontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        UUID frontierID = selectedFrontier == null ? null : selectedFrontier.getId();
        this.frontiers.removeAll();
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Personal) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers().values()) {
                for (FrontierOverlay frontier : dimension) {
                    if (!this.checkFilterOwner(frontier) || !this.checkFilterDimension(frontier)) continue;
                    this.frontiers.addElement(new FrontierListElement(this.f_96547_, frontier));
                }
            }
        }
        if (Config.filterFrontierType == Config.FilterFrontierType.All || Config.filterFrontierType == Config.FilterFrontierType.Global) {
            for (ArrayList<FrontierOverlay> dimension : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers().values()) {
                for (FrontierOverlay frontier : dimension) {
                    if (!this.checkFilterOwner(frontier) || !this.checkFilterDimension(frontier)) continue;
                    this.frontiers.addElement(new FrontierListElement(this.f_96547_, frontier));
                }
            }
        }
        if (frontierID != null) {
            this.frontiers.selectElementIf(element -> ((FrontierListElement)element).getFrontier().getId().equals(frontierID));
        }
    }

    private boolean checkFilterOwner(FrontierOverlay frontier) {
        boolean ownerIsPlayer;
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.All) {
            return true;
        }
        boolean bl = ownerIsPlayer = this.f_96541_.f_91074_ != null && frontier.getOwner().equals(new SettingsUser((Player)this.f_96541_.f_91074_));
        if (Config.filterFrontierOwner == Config.FilterFrontierOwner.You) {
            return ownerIsPlayer;
        }
        return !ownerIsPlayer;
    }

    private boolean checkFilterDimension(FrontierOverlay frontier) {
        if (Config.filterFrontierDimension.equals("all")) {
            return true;
        }
        String dimension = Config.filterFrontierDimension;
        if (dimension.equals("current") && this.f_96541_.f_91073_ != null) {
            dimension = this.f_96541_.f_91073_.m_46472_().m_135782_().toString();
        }
        return frontier.getDimension().m_135782_().toString().equals(dimension);
    }

    private void updateButtons() {
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((Player)this.f_96541_.f_91074_);
        FrontierOverlay frontier = this.frontiers.getSelectedElement() == null ? null : ((FrontierListElement)this.frontiers.getSelectedElement()).getFrontier();
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, frontier, playerUser);
        this.buttonInfo.f_93624_ = this.frontiers.getSelectedElement() != null;
        this.buttonDelete.f_93624_ = actions.canDelete;
        this.buttonVisible.f_93624_ = actions.canUpdate;
        if (frontier != null && frontier.getVisible()) {
            this.buttonVisible.m_93666_((Component)Component.m_237115_((String)"mapfrontiers.hide"));
        } else {
            this.buttonVisible.m_93666_((Component)Component.m_237115_((String)"mapfrontiers.show"));
        }
    }
}

