/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.TabbedBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.LinkButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.PatreonButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.GroupActionElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.GroupElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.UserElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxDouble;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.screen.HUDSettings;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierSettings;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketRequestFrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsGroup;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class ModSettings
extends Screen {
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private final Screen previousScreen;
    private final boolean showKeyHint;
    private FrontierSettings settings;
    private TabbedBox tabbedBox;
    private LinkButton buttonWeb;
    private LinkButton buttonProject;
    private PatreonButton buttonPatreon;
    private OptionButton buttonFullscreenButtons;
    private OptionButton buttonFullscreenVisibility;
    private OptionButton buttonFullscreenNameVisibility;
    private OptionButton buttonFullscreenOwnerVisibility;
    private OptionButton buttonMinimapVisibility;
    private OptionButton buttonMinimapNameVisibility;
    private OptionButton buttonMinimapOwnerVisibility;
    private OptionButton ButtonTitleAnnouncementAboveHotbar;
    private OptionButton buttonAnnounceUnnamedFrontiers;
    private OptionButton buttonHideNamesThatDontFit;
    private TextBoxDouble textPolygonsOpacity;
    private TextBoxInt textSnapDistance;
    private OptionButton buttonHUDEnabled;
    private SimpleButton buttonEditHUD;
    private ScrollBox groups;
    private ScrollBox users;
    private ScrollBox groupsActions;
    private TextBox textNewGroupName;
    private IconButton buttonNewGroup;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;
    private TextBox textGroupName;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels;
    private final Map<SimpleLabel, List<Component>> labelTooltips;
    private boolean canEditGroups;
    private Tab tabSelected;
    private int ticksSinceLastUpdate = 0;

    public ModSettings(@Nullable Screen previousScreen, boolean showKeyHint) {
        super((Component)Component.m_237115_((String)"mapfrontiers.title_settings"));
        this.previousScreen = previousScreen;
        this.showKeyHint = showKeyHint;
        this.labels = new ArrayList<SimpleLabel>();
        this.labelTooltips = new HashMap<SimpleLabel, List<Component>>();
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            if (profile.updateSettings == SettingsProfile.State.Enabled == this.canEditGroups) {
                return;
            }
            if (this.tabSelected != null) {
                MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            }
            this.f_96541_.m_91152_((Screen)new ModSettings(previousScreen, showKeyHint));
        });
    }

    private ModSettings() {
        super((Component)Component.m_237119_());
        this.previousScreen = null;
        this.showKeyHint = false;
        this.labels = null;
        this.labelTooltips = null;
    }

    public static ModSettings createDummy() {
        return new ModSettings();
    }

    public void m_7856_() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.f_96541_, this, 696, 366);
        this.actualWidth = (int)((float)this.f_96543_ * this.scaleFactor);
        this.actualHeight = (int)((float)this.f_96544_ * this.scaleFactor);
        boolean bl = this.canEditGroups = MapFrontiersClient.isModOnServer() && MapFrontiersClient.getSettingsProfile().updateSettings == SettingsProfile.State.Enabled;
        if (this.tabSelected == null) {
            this.tabSelected = MapFrontiersClient.getLastSettingsTab();
        }
        this.tabbedBox = new TabbedBox(this.f_96547_, 40, 24, this.actualWidth - 80, this.actualHeight - 64, tab -> {
            this.tabSelected = Tab.values()[tab];
            if (this.tabSelected == Tab.Actions) {
                this.updateGroupsActions();
            }
            this.resetLabels();
            this.updateButtonsVisibility();
        });
        this.tabbedBox.addTab((Component)Component.m_237115_((String)"mapfrontiers.credits"), true);
        this.tabbedBox.addTab((Component)Component.m_237115_((String)"mapfrontiers.general"), true);
        this.tabbedBox.addTab((Component)Component.m_237115_((String)"mapfrontiers.groups"), this.canEditGroups);
        this.tabbedBox.addTab((Component)Component.m_237115_((String)"mapfrontiers.actions"), this.canEditGroups);
        if (!(this.canEditGroups || this.tabSelected != Tab.Groups && this.tabSelected != Tab.Actions)) {
            this.tabSelected = Tab.Credits;
        }
        this.tabbedBox.setTabSelected(this.tabSelected.ordinal());
        this.buttonWeb = new LinkButton(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 98, (Component)Component.m_237113_((String)"alejandrocoria.games"), "https://alejandrocoria.games", open -> this.linkClicked(open, this.buttonWeb));
        this.buttonProject = new LinkButton(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 20, (Component)Component.m_237113_((String)"curseforge.com/minecraft/mc-mods/mapfrontiers"), "https://www.curseforge.com/minecraft/mc-mods/mapfrontiers", open -> this.linkClicked(open, this.buttonProject));
        this.buttonPatreon = new PatreonButton(this.actualWidth / 2, this.actualHeight / 2 + 36, "https://www.patreon.com/alejandrocoria", open -> this.linkClicked(open, this.buttonPatreon));
        this.buttonFullscreenButtons = new OptionButton(this.f_96547_, this.actualWidth / 2 + 80, 54, 40, this::buttonPressed);
        this.buttonFullscreenButtons.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonFullscreenButtons.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonFullscreenButtons.setSelected(Config.fullscreenButtons ? 0 : 1);
        this.buttonFullscreenVisibility = new OptionButton(this.f_96547_, this.actualWidth / 2 - 120, 106, 80, this::buttonPressed);
        this.buttonFullscreenVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonFullscreenVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonFullscreenVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonFullscreenVisibility.setSelected(Config.fullscreenVisibility.ordinal());
        this.buttonFullscreenNameVisibility = new OptionButton(this.f_96547_, this.actualWidth / 2 - 120, 122, 80, this::buttonPressed);
        this.buttonFullscreenNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonFullscreenNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonFullscreenNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonFullscreenNameVisibility.setSelected(Config.fullscreenNameVisibility.ordinal());
        this.buttonFullscreenOwnerVisibility = new OptionButton(this.f_96547_, this.actualWidth / 2 - 120, 138, 80, this::buttonPressed);
        this.buttonFullscreenOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonFullscreenOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonFullscreenOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonFullscreenOwnerVisibility.setSelected(Config.fullscreenOwnerVisibility.ordinal());
        this.buttonMinimapVisibility = new OptionButton(this.f_96547_, this.actualWidth / 2 + 140, 106, 80, this::buttonPressed);
        this.buttonMinimapVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonMinimapVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonMinimapVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonMinimapVisibility.setSelected(Config.minimapVisibility.ordinal());
        this.buttonMinimapNameVisibility = new OptionButton(this.f_96547_, this.actualWidth / 2 + 140, 122, 80, this::buttonPressed);
        this.buttonMinimapNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonMinimapNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonMinimapNameVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonMinimapNameVisibility.setSelected(Config.minimapNameVisibility.ordinal());
        this.buttonMinimapOwnerVisibility = new OptionButton(this.f_96547_, this.actualWidth / 2 + 140, 138, 80, this::buttonPressed);
        this.buttonMinimapOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Custom));
        this.buttonMinimapOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Always));
        this.buttonMinimapOwnerVisibility.addOption(Config.getTranslatedEnum(Config.Visibility.Never));
        this.buttonMinimapOwnerVisibility.setSelected(Config.minimapOwnerVisibility.ordinal());
        this.ButtonTitleAnnouncementAboveHotbar = new OptionButton(this.f_96547_, this.actualWidth / 2 + 80, 170, 40, this::buttonPressed);
        this.ButtonTitleAnnouncementAboveHotbar.addOption((Component)Component.m_237115_((String)"options.on"));
        this.ButtonTitleAnnouncementAboveHotbar.addOption((Component)Component.m_237115_((String)"options.off"));
        this.ButtonTitleAnnouncementAboveHotbar.setSelected(Config.titleAnnouncementAboveHotbar ? 0 : 1);
        this.buttonAnnounceUnnamedFrontiers = new OptionButton(this.f_96547_, this.actualWidth / 2 + 80, 186, 40, this::buttonPressed);
        this.buttonAnnounceUnnamedFrontiers.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonAnnounceUnnamedFrontiers.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonAnnounceUnnamedFrontiers.setSelected(Config.announceUnnamedFrontiers ? 0 : 1);
        this.buttonHideNamesThatDontFit = new OptionButton(this.f_96547_, this.actualWidth / 2 + 80, 202, 40, this::buttonPressed);
        this.buttonHideNamesThatDontFit.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonHideNamesThatDontFit.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonHideNamesThatDontFit.setSelected(Config.hideNamesThatDontFit ? 0 : 1);
        this.textPolygonsOpacity = new TextBoxDouble(0.4, 0.0, 1.0, this.f_96547_, this.actualWidth / 2 + 80, 218, 40);
        this.textPolygonsOpacity.m_94144_(String.valueOf(Config.polygonsOpacity));
        this.textPolygonsOpacity.m_94199_(6);
        this.textPolygonsOpacity.setValueChangedCallback(value -> {
            Config.polygonsOpacity = value;
        });
        this.textSnapDistance = new TextBoxInt(8, 0, 16, this.f_96547_, this.actualWidth / 2 + 80, 234, 40);
        this.textSnapDistance.m_94144_(String.valueOf(Config.snapDistance));
        this.textSnapDistance.m_94199_(2);
        this.textSnapDistance.setValueChangedCallback(value -> {
            Config.snapDistance = value;
        });
        this.buttonHUDEnabled = new OptionButton(this.f_96547_, this.actualWidth / 2 + 80, 288, 40, this::buttonPressed);
        this.buttonHUDEnabled.addOption((Component)Component.m_237115_((String)"options.on"));
        this.buttonHUDEnabled.addOption((Component)Component.m_237115_((String)"options.off"));
        this.buttonHUDEnabled.setSelected(Config.hudEnabled ? 0 : 1);
        this.buttonEditHUD = new SimpleButton(this.f_96547_, this.actualWidth / 2 - 50, 308, 100, (Component)Component.m_237115_((String)"mapfrontiers.edit_hud"), this::buttonPressed);
        this.groups = new ScrollBox(50, 50, 160, this.actualHeight - 120, 16);
        this.groups.setElementClickedCallback(element -> {
            this.groupClicked((GroupElement)element);
            this.updateButtonsVisibility();
        });
        this.groups.setElementDeletedCallback(element -> {
            if (this.groups.getSelectedElement() != null) {
                this.groupClicked((GroupElement)this.groups.getSelectedElement());
            }
            this.settings.removeCustomGroup(((GroupElement)element).getGroup());
            this.sendChangesToServer();
        });
        this.users = new ScrollBox(250, 82, 258, this.actualHeight - 150, 16);
        this.users.setElementDeletedCallback(element -> {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            group.removeUser(((UserElement)element).getUser());
            this.sendChangesToServer();
        });
        this.groupsActions = new ScrollBox(this.actualWidth / 2 - 215, 82, 430, this.actualHeight - 128, 16);
        this.textNewGroupName = new TextBox(this.f_96547_, 50, this.actualHeight - 61, 140, I18n.m_118938_((String)"mapfrontiers.new_group_name", (Object[])new Object[0]));
        this.textNewGroupName.m_94199_(22);
        this.buttonNewGroup = new IconButton(192, this.actualHeight - 61, IconButton.Type.Add, this::buttonPressed);
        this.textNewUser = new TextBoxUser(this.f_96541_, this.f_96547_, 250, this.actualHeight - 61, 238, I18n.m_118938_((String)"mapfrontiers.new_user", (Object[])new Object[0]));
        this.textNewUser.m_94199_(38);
        this.buttonNewUser = new IconButton(490, this.actualHeight - 61, IconButton.Type.Add, this::buttonPressed);
        this.textGroupName = new TextBox(this.f_96547_, 250, 50, 140);
        this.textGroupName.m_94199_(22);
        this.textGroupName.m_94186_(false);
        this.textGroupName.m_94182_(false);
        this.textGroupName.setLostFocusCallback(value -> {
            GroupElement groupElement;
            if (this.tabSelected == Tab.Groups && (groupElement = (GroupElement)this.groups.getSelectedElement()) != null) {
                groupElement.getGroup().setName((String)value);
                this.sendChangesToServer();
            }
        });
        this.buttonDone = new SimpleButton(this.f_96547_, this.actualWidth / 2 - 70, this.actualHeight - 28, 140, (Component)Component.m_237115_((String)"gui.done"), this::buttonPressed);
        this.m_142416_((GuiEventListener)this.tabbedBox);
        this.m_142416_((GuiEventListener)this.buttonWeb);
        this.m_142416_((GuiEventListener)this.buttonProject);
        this.m_142416_((GuiEventListener)this.buttonPatreon);
        this.m_142416_((GuiEventListener)this.buttonFullscreenButtons);
        this.m_142416_((GuiEventListener)this.buttonFullscreenVisibility);
        this.m_142416_((GuiEventListener)this.buttonFullscreenNameVisibility);
        this.m_142416_((GuiEventListener)this.buttonFullscreenOwnerVisibility);
        this.m_142416_((GuiEventListener)this.buttonMinimapVisibility);
        this.m_142416_((GuiEventListener)this.buttonMinimapNameVisibility);
        this.m_142416_((GuiEventListener)this.buttonMinimapOwnerVisibility);
        this.m_142416_((GuiEventListener)this.ButtonTitleAnnouncementAboveHotbar);
        this.m_142416_((GuiEventListener)this.buttonAnnounceUnnamedFrontiers);
        this.m_142416_((GuiEventListener)this.buttonHideNamesThatDontFit);
        this.m_142416_((GuiEventListener)this.textPolygonsOpacity);
        this.m_142416_((GuiEventListener)this.textSnapDistance);
        this.m_142416_((GuiEventListener)this.buttonHUDEnabled);
        this.m_142416_((GuiEventListener)this.buttonEditHUD);
        this.m_142416_((GuiEventListener)this.groups);
        this.m_142416_((GuiEventListener)this.users);
        this.m_142416_((GuiEventListener)this.groupsActions);
        this.m_142416_((GuiEventListener)this.textNewGroupName);
        this.m_142416_((GuiEventListener)this.buttonNewGroup);
        this.m_142416_((GuiEventListener)this.textNewUser);
        this.m_142416_((GuiEventListener)this.buttonNewUser);
        this.m_142416_((GuiEventListener)this.textGroupName);
        this.m_142416_((GuiEventListener)this.buttonDone);
        this.resetLabels();
        this.updateButtonsVisibility();
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketRequestFrontierSettings());
        }
    }

    public void m_86600_() {
        if (!this.canEditGroups || this.settings == null) {
            return;
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 100) {
            this.ticksSinceLastUpdate = 0;
            PacketHandler.sendToServer(new PacketRequestFrontierSettings(this.settings.getChangeCounter()));
            ClientPacketListener handler = this.f_96541_.m_91403_();
            if (handler == null) {
                return;
            }
            for (ScrollBox.ScrollElement element : this.users.getElements()) {
                UserElement userElement = (UserElement)element;
                SettingsUser user = userElement.getUser();
                PlayerInfo networkplayerinfo = null;
                if (user.uuid != null) {
                    networkplayerinfo = handler.m_104949_(user.uuid);
                } else if (!StringUtils.isBlank((CharSequence)user.username)) {
                    networkplayerinfo = handler.m_104938_(user.username);
                }
                if (networkplayerinfo == null) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 0) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 150) {
                    userElement.setPingBar(5);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 300) {
                    userElement.setPingBar(4);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 600) {
                    userElement.setPingBar(3);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 1000) {
                    userElement.setPingBar(2);
                    continue;
                }
                userElement.setPingBar(1);
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.actualWidth / 2, 8, -1);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_) continue;
            label.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_ || !label.m_274382_()) continue;
            List<Component> tooltip = this.labelTooltips.get((Object)label);
            if (tooltip == null) break;
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
            break;
        }
        if (this.scaleFactor != 1.0f) {
            graphics.m_280168_().m_85849_();
        }
    }

    public boolean m_7933_(int key, int value, int modifier) {
        if (key == 69 && !(this.m_7222_() instanceof EditBox)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(key, value, modifier);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6375_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        for (GuiEventListener w : this.m_6702_()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, delta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.m_7979_(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void buttonPressed(Button button) {
        if (button == this.buttonFullscreenButtons) {
            Config.fullscreenButtons = this.buttonFullscreenButtons.getSelected() == 0;
        } else if (button == this.buttonFullscreenVisibility) {
            Config.fullscreenVisibility = Config.Visibility.values()[this.buttonFullscreenVisibility.getSelected()];
        } else if (button == this.buttonFullscreenNameVisibility) {
            Config.fullscreenNameVisibility = Config.Visibility.values()[this.buttonFullscreenNameVisibility.getSelected()];
        } else if (button == this.buttonFullscreenOwnerVisibility) {
            Config.fullscreenOwnerVisibility = Config.Visibility.values()[this.buttonFullscreenOwnerVisibility.getSelected()];
        } else if (button == this.buttonMinimapVisibility) {
            Config.minimapVisibility = Config.Visibility.values()[this.buttonMinimapVisibility.getSelected()];
        } else if (button == this.buttonMinimapNameVisibility) {
            Config.minimapNameVisibility = Config.Visibility.values()[this.buttonMinimapNameVisibility.getSelected()];
        } else if (button == this.buttonMinimapOwnerVisibility) {
            Config.minimapOwnerVisibility = Config.Visibility.values()[this.buttonMinimapOwnerVisibility.getSelected()];
        } else if (button == this.ButtonTitleAnnouncementAboveHotbar) {
            Config.titleAnnouncementAboveHotbar = this.ButtonTitleAnnouncementAboveHotbar.getSelected() == 0;
        } else if (button == this.buttonAnnounceUnnamedFrontiers) {
            Config.announceUnnamedFrontiers = this.buttonAnnounceUnnamedFrontiers.getSelected() == 0;
        } else if (button == this.buttonHideNamesThatDontFit) {
            Config.hideNamesThatDontFit = this.buttonHideNamesThatDontFit.getSelected() == 0;
        } else if (button == this.buttonHUDEnabled) {
            Config.hudEnabled = this.buttonHUDEnabled.getSelected() == 0;
            this.updateButtonsVisibility();
        } else if (button == this.buttonEditHUD) {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            this.f_96541_.m_91152_((Screen)new HUDSettings(this.previousScreen, this.showKeyHint));
        } else if (button == this.buttonNewGroup) {
            if (this.settings != null) {
                SettingsGroup group = this.settings.createCustomGroup(this.textNewGroupName.m_94155_());
                this.textNewGroupName.m_94144_("");
                GroupElement element = new GroupElement(this.f_96547_, this, group);
                this.groups.addElement(element);
                this.groups.scrollBottom();
                this.groupClicked(element);
                this.groupsActions.scrollBottom();
                this.sendChangesToServer();
            }
        } else if (button == this.buttonNewUser) {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            SettingsUser user = new SettingsUser();
            String usernameOrUUID = this.textNewUser.m_94155_();
            if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
                return;
            }
            if (usernameOrUUID.length() < 28) {
                user.username = usernameOrUUID;
                user.fillMissingInfo(false, null);
            } else {
                if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                    this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_error_uuid_size"));
                    return;
                }
                usernameOrUUID = usernameOrUUID.toLowerCase();
                String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
                try {
                    user.uuid = UUID.fromString(uuid);
                    user.fillMissingInfo(true, null);
                }
                catch (Exception e) {
                    this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_error_uuid_format"));
                    return;
                }
            }
            if (group.hasUser(user)) {
                this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_error_user_repeated"));
                return;
            }
            group.addUser(user);
            UserElement element = new UserElement(this.f_96547_, this, user);
            this.users.addElement(element);
            this.users.scrollBottom();
            this.textNewUser.m_94144_("");
            this.sendChangesToServer();
        } else if (button == this.buttonDone) {
            this.m_7379_();
        }
    }

    public void m_7861_() {
        ClientEventHandler.postUpdatedConfigEvent();
        MapFrontiersClient.setLastSettingsTab(this.tabSelected);
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.previousScreen);
    }

    public void linkClicked(boolean open, AbstractWidget widget) {
        if (open) {
            if (widget == this.buttonWeb) {
                this.buttonWeb.openLink();
            } else if (widget == this.buttonProject) {
                this.buttonProject.openLink();
            } else if (widget == this.buttonPatreon) {
                this.buttonPatreon.openLink();
            } else {
                return;
            }
        }
        MapFrontiersClient.setLastSettingsTab(this.tabSelected);
        this.f_96541_.m_91152_((Screen)new ModSettings(this.previousScreen, this.showKeyHint));
    }

    public void setFrontierSettings(FrontierSettings settings) {
        this.settings = settings;
        GroupElement selectedElement = (GroupElement)this.groups.getSelectedElement();
        int selectedIndex = this.groups.getSelectedIndex();
        this.groups.removeAll();
        this.groups.addElement(new GroupElement(this.f_96547_, this, settings.getOPsGroup()));
        this.groups.addElement(new GroupElement(this.f_96547_, this, settings.getOwnersGroup()));
        this.groups.addElement(new GroupElement(this.f_96547_, this, settings.getEveryoneGroup()));
        for (SettingsGroup group : settings.getCustomGroups()) {
            this.groups.addElement(new GroupElement(this.f_96547_, this, group));
        }
        this.updateGroupsActions();
        this.resetLabels();
        this.updateButtonsVisibility();
        if (selectedElement != null) {
            this.groups.selectElementIf(element -> ((GroupElement)element).getGroup().getName().equals(selectedElement.getGroup().getName()));
        }
        if (this.groups.getSelectedElement() == null) {
            this.groups.selectIndex(selectedIndex);
        }
        if (this.groups.getSelectedElement() != null) {
            this.groupClicked((GroupElement)this.groups.getSelectedElement());
        }
    }

    private void resetLabels() {
        this.labels.clear();
        this.labelTooltips.clear();
        if (this.tabSelected == Tab.Credits) {
            this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 106, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.credits_created_by"), -1));
            this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 58, SimpleLabel.Align.Center, (Component)Component.m_237110_((String)"mapfrontiers.credits_many_thanks", (Object[])new Object[]{Services.PLATFORM.getPlatformName()}), -1));
            this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 - 28, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.credits_project"), 0xAAAAAA));
            this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2, this.actualHeight / 2 + 22, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.credits_patreon"), 0xAAAAAA));
            this.labels.add(new SimpleLabel(this.f_96547_, 50, this.actualHeight - 54, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.credits_translation"), -1));
        } else if (this.tabSelected == Tab.General) {
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 120, 56, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenButtons"), -2236963), Config.getTooltip("fullscreenButtons"));
            this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2, 90, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.frontiers"), -1));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 300, 108, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenVisibility"), -2236963), Config.getTooltip("fullscreenVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 300, 124, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenNameVisibility"), -2236963), Config.getTooltip("fullscreenNameVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 300, 140, SimpleLabel.Align.Left, Config.getTranslatedName("fullscreenOwnerVisibility"), -2236963), Config.getTooltip("fullscreenOwnerVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 + 30, 108, SimpleLabel.Align.Left, Config.getTranslatedName("minimapVisibility"), -2236963), Config.getTooltip("minimapVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 + 30, 124, SimpleLabel.Align.Left, Config.getTranslatedName("minimapNameVisibility"), -2236963), Config.getTooltip("minimapNameVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 + 30, 140, SimpleLabel.Align.Left, Config.getTranslatedName("minimapOwnerVisibility"), -2236963), Config.getTooltip("minimapOwnerVisibility"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 120, 172, SimpleLabel.Align.Left, Config.getTranslatedName("titleAnnouncementAboveHotbar"), -2236963), Config.getTooltip("titleAnnouncementAboveHotbar"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 120, 188, SimpleLabel.Align.Left, Config.getTranslatedName("announceUnnamedFrontiers"), -2236963), Config.getTooltip("announceUnnamedFrontiers"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 120, 204, SimpleLabel.Align.Left, Config.getTranslatedName("hideNamesThatDontFit"), -2236963), Config.getTooltip("hideNamesThatDontFit"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 120, 220, SimpleLabel.Align.Left, Config.getTranslatedName("polygonsOpacity"), -2236963), Config.getTooltip("polygonsOpacity"));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 120, 236, SimpleLabel.Align.Left, Config.getTranslatedName("snapDistance"), -2236963), Config.getTooltip("snapDistance"));
            this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2, 270, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.hud"), -1));
            this.addLabelWithTooltip(new SimpleLabel(this.f_96547_, this.actualWidth / 2 - 120, 290, SimpleLabel.Align.Left, Config.getTranslatedName("hud.enabled"), -2236963), Config.getTooltip("hud.enabled"));
        } else if (this.tabSelected == Tab.Groups) {
            GroupElement element;
            if (this.settings != null && (element = (GroupElement)this.groups.getSelectedElement()) != null && element.getGroup().isSpecial()) {
                SettingsGroup group = element.getGroup();
                if (group == this.settings.getOPsGroup()) {
                    this.labels.add(new SimpleLabel(this.f_96547_, 250, 82, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.group_ops_desc"), -2236963));
                } else if (group == this.settings.getOwnersGroup()) {
                    this.labels.add(new SimpleLabel(this.f_96547_, 250, 82, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.group_owners_desc"), -2236963));
                } else if (group == this.settings.getEveryoneGroup()) {
                    this.labels.add(new SimpleLabel(this.f_96547_, 250, 82, SimpleLabel.Align.Left, (Component)Component.m_237115_((String)"mapfrontiers.group_everyone_desc"), -2236963));
                }
            }
        } else if (this.tabSelected == Tab.Actions) {
            int x = this.actualWidth / 2 - 55;
            this.labels.add(new SimpleLabel(this.f_96547_, x, 47, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.create_global_frontier"), -1));
            this.labels.add(new SimpleLabel(this.f_96547_, x + 60, 47, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.delete_global_frontier"), -1));
            this.labels.add(new SimpleLabel(this.f_96547_, x + 120, 47, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.update_global_frontier"), -1));
            this.labels.add(new SimpleLabel(this.f_96547_, x + 180, 53, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.update_settings"), -1));
            this.labels.add(new SimpleLabel(this.f_96547_, x + 240, 47, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.share_personal_frontier"), -1));
        }
        if (this.tabSelected == Tab.Credits || this.tabSelected == Tab.General) {
            Component key;
            this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth - 48, this.actualHeight - 54, SimpleLabel.Align.Right, (Component)Component.m_237113_((String)Services.PLATFORM.getModVersion()), -1));
            if (this.showKeyHint && (key = MapFrontiersClient.getOpenSettingsKey()) != null) {
                this.labels.add(new SimpleLabel(this.f_96547_, this.actualWidth / 2, this.actualHeight - 54, SimpleLabel.Align.Center, (Component)Component.m_237110_((String)"mapfrontiers.key.open_settings.hint", (Object[])new Object[]{key}), -1));
            }
        }
    }

    private void addLabelWithTooltip(SimpleLabel label, List<Component> tooltip) {
        this.labels.add(label);
        this.labelTooltips.put(label, tooltip);
    }

    private void updateButtonsVisibility() {
        this.buttonWeb.f_93624_ = this.tabSelected == Tab.Credits;
        this.buttonProject.f_93624_ = this.tabSelected == Tab.Credits;
        this.buttonPatreon.f_93624_ = this.tabSelected == Tab.Credits;
        this.buttonFullscreenButtons.f_93624_ = this.tabSelected == Tab.General;
        this.buttonFullscreenVisibility.f_93624_ = this.tabSelected == Tab.General;
        this.buttonFullscreenNameVisibility.f_93624_ = this.tabSelected == Tab.General;
        this.buttonFullscreenOwnerVisibility.f_93624_ = this.tabSelected == Tab.General;
        this.buttonMinimapVisibility.f_93624_ = this.tabSelected == Tab.General;
        this.buttonMinimapNameVisibility.f_93624_ = this.tabSelected == Tab.General;
        this.buttonMinimapOwnerVisibility.f_93624_ = this.tabSelected == Tab.General;
        this.ButtonTitleAnnouncementAboveHotbar.f_93624_ = this.tabSelected == Tab.General;
        this.buttonAnnounceUnnamedFrontiers.f_93624_ = this.tabSelected == Tab.General;
        this.buttonHideNamesThatDontFit.f_93624_ = this.tabSelected == Tab.General;
        this.textPolygonsOpacity.f_93624_ = this.tabSelected == Tab.General;
        this.textSnapDistance.f_93624_ = this.tabSelected == Tab.General;
        this.buttonHUDEnabled.f_93624_ = this.tabSelected == Tab.General;
        this.buttonEditHUD.f_93624_ = this.tabSelected == Tab.General && Config.hudEnabled && this.f_96541_.f_91074_ != null;
        this.groups.f_93624_ = this.tabSelected == Tab.Groups;
        this.users.f_93624_ = this.tabSelected == Tab.Groups;
        this.groupsActions.f_93624_ = this.tabSelected == Tab.Actions;
        this.textNewGroupName.f_93624_ = this.tabSelected == Tab.Groups;
        this.buttonNewGroup.f_93624_ = this.tabSelected == Tab.Groups;
        this.textNewUser.f_93624_ = this.canAddNewUser();
        this.buttonNewUser.f_93624_ = this.canAddNewUser();
        this.textGroupName.f_93624_ = this.tabSelected == Tab.Groups;
    }

    public void groupClicked(GroupElement element) {
        this.groups.selectElement(element);
        this.textGroupName.m_94144_(element.getGroup().getName());
        this.textGroupName.m_94186_(!element.getGroup().isSpecial());
        this.textGroupName.m_94182_(!element.getGroup().isSpecial());
        this.textGroupName.m_93692_(false);
        this.resetLabels();
        this.updateUsers();
    }

    private void sendChangesToServer() {
        if (this.settings != null) {
            this.settings.advanceChangeCounter();
            PacketHandler.sendToServer(new PacketFrontierSettings(this.settings));
        }
    }

    private void updateUsers() {
        this.users.removeAll();
        GroupElement element = (GroupElement)this.groups.getSelectedElement();
        if (element != null && !element.getGroup().isSpecial()) {
            for (SettingsUser user : element.getGroup().getUsers()) {
                this.users.addElement(new UserElement(this.f_96547_, this, user));
            }
        }
        this.buttonNewUser.f_93624_ = this.canAddNewUser();
        this.textNewUser.f_93624_ = this.canAddNewUser();
    }

    private void updateGroupsActions() {
        if (this.settings != null) {
            this.groupsActions.removeAll();
            this.groupsActions.addElement(new GroupActionElement(this.f_96547_, this.settings.getOPsGroup(), this::actionChanged));
            this.groupsActions.addElement(new GroupActionElement(this.f_96547_, this.settings.getOwnersGroup(), true, this::actionChanged));
            this.groupsActions.addElement(new GroupActionElement(this.f_96547_, this.settings.getEveryoneGroup(), this::actionChanged));
            for (SettingsGroup group : this.settings.getCustomGroups()) {
                this.groupsActions.addElement(new GroupActionElement(this.f_96547_, group, this::actionChanged));
            }
        }
    }

    private void actionChanged(SettingsGroup group, FrontierSettings.Action action, boolean checked) {
        if (checked) {
            group.addAction(action);
        } else {
            group.removeAction(action);
        }
        this.sendChangesToServer();
    }

    private boolean canAddNewUser() {
        if (this.tabSelected == Tab.Groups && this.groups.getSelectedElement() != null) {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            return !group.isSpecial();
        }
        return false;
    }

    public static enum Tab {
        Credits,
        General,
        Groups,
        Actions;

    }
}

