/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.UserSharedElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketRemoveSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketUpdateSharedUserPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class ShareSettings
extends Screen {
    private final FrontiersOverlayManager frontiersOverlayManager;
    private FrontierOverlay frontier;
    private ScrollBox users;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;
    private SimpleButton buttonDone;
    private final List<SimpleLabel> labels;
    private boolean canUpdate;
    private int ticksSinceLastUpdate = 0;

    public ShareSettings(FrontiersOverlayManager frontiersOverlayManager, FrontierOverlay frontier) {
        super((Component)Component.m_237115_((String)"mapfrontiers.title_share_settings"));
        this.frontiersOverlayManager = frontiersOverlayManager;
        this.frontier = frontier;
        this.labels = new ArrayList<SimpleLabel>();
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontierID.equals(this.frontier.getId())) {
                Services.PLATFORM.popGuiLayer();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (frontierOverlay.getId().equals(this.frontier.getId())) {
                this.frontier = frontierOverlay;
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
        });
    }

    public void m_7856_() {
        if (!MapFrontiersClient.isModOnServer()) {
            Services.PLATFORM.popGuiLayer();
        }
        this.users = new ScrollBox(this.f_96543_ / 2 - 215, 82, 430, this.f_96544_ - 128, 16);
        this.users.setElementDeletedCallback(element -> {
            SettingsUser user = ((UserSharedElement)element).getUser();
            this.frontier.removeUserShared(user);
            PacketHandler.sendToServer(new PacketRemoveSharedUserPersonalFrontier(this.frontier.getId(), user));
            this.resetLabels();
        });
        this.textNewUser = new TextBoxUser(this.f_96541_, this.f_96547_, this.f_96543_ / 2 - 125, this.f_96544_ - 61, 238);
        this.textNewUser.m_94199_(38);
        this.buttonNewUser = new IconButton(this.f_96543_ / 2 + 114, this.f_96544_ - 61, IconButton.Type.Add, button -> this.buttonNewUserPressed());
        this.buttonNewUser.f_93624_ = false;
        this.buttonDone = new SimpleButton(this.f_96547_, this.f_96543_ / 2 - 70, this.f_96544_ - 28, 140, (Component)Component.m_237115_((String)"gui.done"), this::buttonPressed);
        this.m_142416_((GuiEventListener)this.buttonNewUser);
        this.m_142416_((GuiEventListener)this.users);
        this.m_142416_((GuiEventListener)this.textNewUser);
        this.m_142416_((GuiEventListener)this.buttonDone);
        this.updateCanUpdate();
        this.updateButtonsVisibility();
        this.updateUsers();
    }

    public void m_86600_() {
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 100) {
            this.ticksSinceLastUpdate = 0;
            ClientPacketListener handler = this.f_96541_.m_91403_();
            if (handler == null) {
                return;
            }
            for (ScrollBox.ScrollElement element : this.users.getElements()) {
                UserSharedElement userElement = (UserSharedElement)element;
                SettingsUser user = userElement.getUser();
                PlayerInfo networkplayerinfo = null;
                if (user.uuid != null) {
                    networkplayerinfo = handler.m_104949_(user.uuid);
                } else if (!StringUtils.isBlank((CharSequence)user.username)) {
                    networkplayerinfo = handler.m_104938_(user.username);
                }
                if (networkplayerinfo == null) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 0) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 150) {
                    userElement.setPingBar(5);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 300) {
                    userElement.setPingBar(4);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 600) {
                    userElement.setPingBar(3);
                    continue;
                }
                if (networkplayerinfo.m_105330_() < 1000) {
                    userElement.setPingBar(2);
                    continue;
                }
                userElement.setPingBar(1);
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, -1);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        for (SimpleLabel label : this.labels) {
            if (!label.f_93624_) continue;
            label.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (GuiEventListener w : this.m_6702_()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected void buttonPressed(Button button) {
        if (button == this.buttonDone) {
            Services.PLATFORM.popGuiLayer();
        }
    }

    private void buttonNewUserPressed() {
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        SettingsUser user = new SettingsUser();
        String usernameOrUUID = this.textNewUser.m_94155_();
        this.textNewUser.m_93692_(false);
        if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
            return;
        }
        if (usernameOrUUID.length() < 28) {
            user.username = usernameOrUUID;
            user.fillMissingInfo(false, null);
        } else {
            if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_error_uuid_size"));
                return;
            }
            usernameOrUUID = usernameOrUUID.toLowerCase();
            String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
            try {
                user.uuid = UUID.fromString(uuid);
                user.fillMissingInfo(true, null);
            }
            catch (Exception e) {
                this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_error_uuid_format"));
                return;
            }
        }
        if (user.uuid == null) {
            this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_shared_error_user_not_found"));
            return;
        }
        ClientPacketListener handler = this.f_96541_.m_91403_();
        if (handler != null && handler.m_104949_(user.uuid) == null) {
            this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_shared_error_user_not_found"));
            return;
        }
        if (user.username.equals(this.f_96541_.f_91074_.m_36316_().getName())) {
            this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_shared_error_self"));
            return;
        }
        if (this.frontier.getOwner().equals(user)) {
            this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_shared_error_owner"));
            return;
        }
        if (this.frontier.hasUserShared(user)) {
            this.textNewUser.setError((Component)Component.m_237115_((String)"mapfrontiers.new_user_shared_error_user_repeated"));
            return;
        }
        SettingsUserShared userShared = new SettingsUserShared(user, true);
        this.frontier.addUserShared(userShared);
        this.frontiersOverlayManager.clientShareFrontier(this.frontier.getId(), user);
        UserSharedElement element = new UserSharedElement(this.f_96547_, this, userShared, this.canUpdate, true, this::actionChanged);
        this.users.addElement(element);
        this.users.scrollBottom();
        this.textNewUser.m_94144_("");
        this.resetLabels();
    }

    public void m_7861_() {
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    private void resetLabels() {
        this.labels.clear();
        if (!this.users.getElements().isEmpty()) {
            int x = this.f_96543_ / 2 + 35;
            this.labels.add(new SimpleLabel(this.f_96547_, x, 54, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.update_frontier"), -1));
            this.labels.add(new SimpleLabel(this.f_96547_, x + 60, 54, SimpleLabel.Align.Center, (Component)Component.m_237115_((String)"mapfrontiers.update_settings"), -1));
        }
    }

    private void updateButtonsVisibility() {
        this.users.f_93624_ = true;
        this.buttonNewUser.f_93624_ = this.canUpdate;
        this.textNewUser.f_93624_ = this.canUpdate;
    }

    private void actionChanged(SettingsUserShared user, SettingsUserShared.Action action, boolean checked) {
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        if (checked) {
            user.addAction(action);
        } else {
            user.removeAction(action);
        }
        if (user.getUser().equals(new SettingsUser((Player)this.f_96541_.f_91074_))) {
            if (action == SettingsUserShared.Action.UpdateSettings) {
                this.updateCanUpdate();
                this.updateUsers();
                this.updateButtonsVisibility();
            }
            this.frontier.setModified(new Date());
            ClientEventHandler.postUpdatedFrontierEvent(this.frontier, -1);
        }
        PacketHandler.sendToServer(new PacketUpdateSharedUserPersonalFrontier(this.frontier.getId(), user));
    }

    private void updateUsers() {
        this.users.removeAll();
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        SettingsUser player = new SettingsUser((Player)this.f_96541_.f_91074_);
        if (this.frontier.getUsersShared() != null) {
            for (SettingsUserShared user : this.frontier.getUsersShared()) {
                this.users.addElement(new UserSharedElement(this.f_96547_, this, user, this.canUpdate, !user.getUser().equals(player), this::actionChanged));
            }
        }
        this.resetLabels();
    }

    private void updateCanUpdate() {
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        this.canUpdate = this.frontier.checkActionUserShared(new SettingsUser((Player)this.f_96541_.f_91074_), SettingsUserShared.Action.UpdateSettings);
    }
}

