/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.PendingShareFrontier;
import games.alejandrocoria.mapfrontiers.common.event.EventHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.ColorHelper;
import games.alejandrocoria.mapfrontiers.common.util.ContainerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

@ParametersAreNonnullByDefault
public class FrontiersManager {
    public static FrontiersManager instance;
    private final HashMap<UUID, FrontierData> allFrontiers;
    private final HashMap<ResourceKey<Level>, ArrayList<FrontierData>> dimensionsGlobalFrontiers;
    private final HashMap<SettingsUser, HashMap<ResourceKey<Level>, ArrayList<FrontierData>>> usersDimensionsPersonalFrontiers;
    private final HashMap<Integer, PendingShareFrontier> pendingShareFrontiers;
    private int pendingShareFrontiersTick = 0;
    private FrontierSettings frontierSettings;
    private File ModDir;
    private boolean frontierOwnersChecked = false;
    public static final int dataVersion = 10;
    private static int pendingShareFrontierID;
    private static final int pendingShareFrontierTickDuration = 1200;

    public FrontiersManager() {
        instance = this;
        this.allFrontiers = new HashMap();
        this.dimensionsGlobalFrontiers = new HashMap();
        this.usersDimensionsPersonalFrontiers = new HashMap();
        this.pendingShareFrontiers = new HashMap();
        this.frontierSettings = new FrontierSettings();
        EventHandler.subscribeServerTickEvent(this, server -> {
            ++this.pendingShareFrontiersTick;
            if (this.pendingShareFrontiersTick >= 100) {
                this.pendingShareFrontiersTick -= 100;
                for (PendingShareFrontier pending : this.pendingShareFrontiers.values()) {
                    boolean removed;
                    FrontierData frontier;
                    pending.tickCount += 100;
                    if (pending.tickCount < 1200 || (frontier = this.getFrontierFromID(pending.frontierID)) == null || frontier.getUsersShared() == null || !(removed = frontier.getUsersShared().removeIf(x -> x.getUser().equals(pending.targetUser)))) continue;
                    PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(frontier), frontier, server);
                }
                this.pendingShareFrontiers.entrySet().removeIf(x -> ((PendingShareFrontier)x.getValue()).tickCount >= 1200);
            }
        });
    }

    public void close() {
        EventHandler.unsuscribeAllEvents(this);
    }

    public void setSettings(FrontierSettings frontierSettings) {
        this.frontierSettings = frontierSettings;
        this.saveData();
    }

    public FrontierSettings getSettings() {
        return this.frontierSettings;
    }

    public Map<ResourceKey<Level>, ArrayList<FrontierData>> getAllGlobalFrontiers() {
        return this.dimensionsGlobalFrontiers;
    }

    public List<FrontierData> getAllGlobalFrontiers(ResourceKey<Level> dimension) {
        return this.dimensionsGlobalFrontiers.computeIfAbsent(dimension, k -> new ArrayList());
    }

    public Map<ResourceKey<Level>, ArrayList<FrontierData>> getAllPersonalFrontiers(SettingsUser user) {
        return this.usersDimensionsPersonalFrontiers.computeIfAbsent(user, k -> new HashMap());
    }

    public List<FrontierData> getAllPersonalFrontiers(SettingsUser user, ResourceKey<Level> dimension) {
        HashMap dimensionsPersonalFrontiers = this.usersDimensionsPersonalFrontiers.computeIfAbsent(user, k -> new HashMap());
        return dimensionsPersonalFrontiers.computeIfAbsent(dimension, k -> new ArrayList());
    }

    public FrontierData getFrontierFromID(UUID id) {
        return this.allFrontiers.get(id);
    }

    public FrontierData createNewGlobalFrontier(ResourceKey<Level> dimension, ServerPlayer player, @Nullable List<BlockPos> vertices, @Nullable List<ChunkPos> chunks) {
        List<FrontierData> frontiers = this.getAllGlobalFrontiers(dimension);
        return this.createNewFrontier(frontiers, dimension, false, player, vertices, chunks);
    }

    public FrontierData createNewPersonalFrontier(ResourceKey<Level> dimension, ServerPlayer player, @Nullable List<BlockPos> vertices, @Nullable List<ChunkPos> chunks) {
        List<FrontierData> frontiers = this.getAllPersonalFrontiers(new SettingsUser((Player)player), dimension);
        return this.createNewFrontier(frontiers, dimension, true, player, vertices, chunks);
    }

    private FrontierData createNewFrontier(List<FrontierData> frontiers, ResourceKey<Level> dimension, boolean personal, ServerPlayer player, @Nullable List<BlockPos> vertices, @Nullable List<ChunkPos> chunks) {
        FrontierData frontier = new FrontierData();
        frontier.setId(UUID.randomUUID());
        frontier.setOwner(new SettingsUser((Player)player));
        frontier.setDimension(dimension);
        frontier.setPersonal(personal);
        frontier.setColor(ColorHelper.getRandomColor());
        frontier.setCreated(new Date());
        if (vertices != null) {
            frontier.setMode(FrontierData.Mode.Vertex);
            for (BlockPos vertex : vertices) {
                frontier.addVertex(vertex);
            }
        }
        if (chunks != null) {
            frontier.setMode(FrontierData.Mode.Chunk);
            for (ChunkPos chunk : chunks) {
                frontier.toggleChunk(chunk);
            }
        }
        frontiers.add(frontier);
        this.allFrontiers.put(frontier.getId(), frontier);
        this.saveData();
        return frontier;
    }

    public void addPersonalFrontier(FrontierData frontier) {
        if (!frontier.getPersonal()) {
            return;
        }
        List<FrontierData> frontiers = this.getAllPersonalFrontiers(frontier.getOwner(), frontier.getDimension());
        frontiers.add(frontier);
        this.allFrontiers.put(frontier.getId(), frontier);
        this.saveData();
    }

    public void addPersonalFrontier(SettingsUser user, FrontierData frontier) {
        List<FrontierData> frontiers = this.getAllPersonalFrontiers(user, frontier.getDimension());
        frontiers.add(frontier);
        this.saveData();
    }

    public boolean deleteGlobalFrontier(ResourceKey<Level> dimension, UUID id) {
        List frontiers = this.dimensionsGlobalFrontiers.get(dimension);
        if (frontiers == null) {
            return false;
        }
        boolean deleted = frontiers.removeIf(x -> x.id.equals(id));
        boolean bl = this.allFrontiers.remove(id) != null;
        this.saveData();
        return deleted |= bl;
    }

    public boolean deletePersonalFrontier(SettingsUser user, ResourceKey<Level> dimension, UUID id) {
        Map dimensionsPersonalFrontiers = this.usersDimensionsPersonalFrontiers.get(user);
        if (dimensionsPersonalFrontiers == null) {
            return false;
        }
        List frontiers = (List)dimensionsPersonalFrontiers.get(dimension);
        if (frontiers == null) {
            return false;
        }
        for (FrontierData frontier : frontiers) {
            if (!frontier.getOwner().equals(user)) continue;
            this.allFrontiers.remove(id);
            break;
        }
        boolean deleted = frontiers.removeIf(x -> x.id.equals(id));
        this.saveData();
        return deleted;
    }

    public boolean updateGlobalFrontier(FrontierData updatedFrontier) {
        List frontiers = this.dimensionsGlobalFrontiers.get(updatedFrontier.getDimension());
        if (frontiers == null) {
            return false;
        }
        int index = ContainerHelper.getIndexFromLambda(frontiers, i -> ((FrontierData)frontiers.get(i)).getId().equals(updatedFrontier.getId()));
        if (index < 0) {
            return false;
        }
        updatedFrontier.setModified(new Date());
        FrontierData frontier = (FrontierData)frontiers.get(index);
        frontier.updateFromData(updatedFrontier);
        this.saveData();
        return true;
    }

    public boolean updatePersonalFrontier(SettingsUser user, FrontierData updatedFrontier) {
        Map dimensionsPersonalFrontiers = this.usersDimensionsPersonalFrontiers.get(user);
        if (dimensionsPersonalFrontiers == null) {
            return false;
        }
        List frontiers = (List)dimensionsPersonalFrontiers.get(updatedFrontier.getDimension());
        if (frontiers == null) {
            return false;
        }
        int index = ContainerHelper.getIndexFromLambda(frontiers, i -> ((FrontierData)frontiers.get(i)).getId().equals(updatedFrontier.getId()));
        if (index < 0) {
            return false;
        }
        updatedFrontier.setModified(new Date());
        FrontierData frontier = (FrontierData)frontiers.get(index);
        frontier.updateFromData(updatedFrontier);
        this.saveData();
        return true;
    }

    public boolean hasPersonalFrontier(SettingsUser user, UUID frontierID) {
        for (List list : this.getAllPersonalFrontiers(user).values()) {
            for (FrontierData frontier : list) {
                if (!frontier.getId().equals(frontierID)) continue;
                return true;
            }
        }
        return false;
    }

    public int addShareMessage(SettingsUser targetUser, UUID frontierID) {
        this.pendingShareFrontiers.put(++pendingShareFrontierID, new PendingShareFrontier(frontierID, targetUser));
        return pendingShareFrontierID;
    }

    public PendingShareFrontier getPendingShareFrontier(int messageID) {
        return this.pendingShareFrontiers.get(messageID);
    }

    public void removePendingShareFrontier(int messageID) {
        this.pendingShareFrontiers.remove(messageID);
    }

    public void removePendingShareFrontier(SettingsUser user) {
        this.pendingShareFrontiers.entrySet().removeIf(x -> ((PendingShareFrontier)x.getValue()).targetUser.equals(user));
    }

    public boolean canSendCommandAcceptFrontier(ServerPlayer player) {
        return this.frontierSettings.checkAction(FrontierSettings.Action.SharePersonalFrontier, new SettingsUser((Player)player), MapFrontiers.isOPorHost(player), null);
    }

    public void ensureOwners(MinecraftServer server) {
        if (this.frontierOwnersChecked) {
            return;
        }
        for (FrontierData frontier : this.allFrontiers.values()) {
            frontier.ensureOwner(server);
        }
        this.frontierOwnersChecked = true;
    }

    private void readFromNBT(CompoundTag nbt) {
        int version = nbt.m_128451_("Version");
        if (version == 0) {
            MapFrontiers.LOGGER.warn("Data version in frontiers not found, expected 10");
        } else if (version < 5) {
            MapFrontiers.LOGGER.warn("Data version in frontiers lower than expected. The mod support from 5 to 10");
        } else if (version > 10) {
            MapFrontiers.LOGGER.warn("Data version in frontiers higher than expected. The mod uses 10");
        }
        ListTag allFrontiersTagList = nbt.m_128437_("frontiers", 10);
        for (int i = 0; i < allFrontiersTagList.size(); ++i) {
            FrontierData frontier = new FrontierData();
            CompoundTag frontierTag = allFrontiersTagList.m_128728_(i);
            frontier.readFromNBT(frontierTag, version);
            frontier.removePendingUsersShared();
            this.allFrontiers.put(frontier.getId(), frontier);
            if (frontier.getPersonal()) {
                this.getAllPersonalFrontiers(frontier.getOwner(), frontier.getDimension()).add(frontier);
                if (frontier.getUsersShared() == null) continue;
                for (SettingsUserShared sharedUser : frontier.getUsersShared()) {
                    this.getAllPersonalFrontiers(sharedUser.getUser(), frontier.getDimension()).add(frontier);
                }
                continue;
            }
            this.getAllGlobalFrontiers(frontier.getDimension()).add(frontier);
        }
    }

    private void writeToNBT(CompoundTag nbt) {
        ListTag allFrontiersTagList = new ListTag();
        for (FrontierData frontier : this.allFrontiers.values()) {
            CompoundTag frontierTag = new CompoundTag();
            frontier.writeToNBT(frontierTag);
            allFrontiersTagList.add((Object)frontierTag);
        }
        nbt.m_128365_("frontiers", (Tag)allFrontiersTagList);
        nbt.m_128405_("Version", 10);
    }

    public void loadOrCreateData(MinecraftServer server) {
        try {
            CompoundTag nbtFrontiers;
            File mcDir = server.m_6982_() ? server.m_6237_() : (Minecraft.m_91087_().m_91092_() != null ? Minecraft.m_91087_().m_91092_().m_129843_(LevelResource.f_78182_).toFile() : Minecraft.m_91087_().f_91069_);
            this.ModDir = new File(mcDir, "mapfrontiers");
            if (this.ModDir.mkdirs()) {
                MapFrontiers.LOGGER.info("Created folder: " + this.ModDir.toString());
            }
            if ((nbtFrontiers = this.loadFile("frontiers.dat")).m_128456_()) {
                this.writeToNBT(nbtFrontiers);
                this.saveFile("frontiers.dat", nbtFrontiers);
            } else {
                this.readFromNBT(nbtFrontiers);
            }
            CompoundTag nbtSettings = this.loadFile("settings.dat");
            if (nbtSettings.m_128456_()) {
                this.frontierSettings.resetToDefault();
                this.frontierSettings.writeToNBT(nbtSettings);
                this.saveFile("settings.dat", nbtSettings);
            } else {
                this.frontierSettings.readFromNBT(nbtSettings);
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveData() {
        CompoundTag nbtFrontiers = new CompoundTag();
        this.writeToNBT(nbtFrontiers);
        this.saveFile("frontiers.dat", nbtFrontiers);
        CompoundTag nbtSettings = new CompoundTag();
        this.frontierSettings.writeToNBT(nbtSettings);
        this.saveFile("settings.dat", nbtSettings);
    }

    private CompoundTag loadFile(String filename) {
        File f = new File(this.ModDir, filename);
        if (f.exists()) {
            CompoundTag compoundTag;
            FileInputStream inputStream = new FileInputStream(f);
            try {
                compoundTag = NbtIo.m_128939_((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
            return compoundTag;
        }
        return new CompoundTag();
    }

    private void saveFile(String filename, CompoundTag nbt) {
        try {
            File f = new File(this.ModDir, filename);
            try (FileOutputStream outputStream = new FileOutputStream(f);){
                NbtIo.m_128947_((CompoundTag)nbt, (OutputStream)outputStream);
            }
            catch (Exception e) {
                MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        pendingShareFrontierID = 0;
    }
}

