/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class PacketFrontiers {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_frontier");
    private final List<FrontierData> globalFrontiers = new ArrayList<FrontierData>();
    private final List<FrontierData> personalFrontiers = new ArrayList<FrontierData>();

    public void addGlobalFrontier(FrontierData frontier) {
        this.globalFrontiers.add(frontier);
    }

    public void addPersonalFrontier(FrontierData frontier) {
        this.personalFrontiers.add(frontier);
    }

    public void addGlobalFrontiers(List<FrontierData> frontiers) {
        this.globalFrontiers.addAll(frontiers);
    }

    public void addPersonalFrontiers(List<FrontierData> frontiers) {
        this.personalFrontiers.addAll(frontiers);
    }

    public static PacketFrontiers decode(FriendlyByteBuf buf) {
        FrontierData frontier;
        int i;
        PacketFrontiers packet = new PacketFrontiers();
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            frontier = new FrontierData();
            frontier.fromBytes(buf);
            packet.addGlobalFrontier(frontier);
        }
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            frontier = new FrontierData();
            frontier.fromBytes(buf);
            packet.addPersonalFrontier(frontier);
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.globalFrontiers.size());
        for (FrontierData frontier : this.globalFrontiers) {
            frontier.toBytes(buf, false);
        }
        buf.writeInt(this.personalFrontiers.size());
        for (FrontierData frontier : this.personalFrontiers) {
            frontier.toBytes(buf, false);
        }
    }

    public static void handle(PacketContext<PacketFrontiers> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketFrontiers message = (PacketFrontiers)ctx.message();
            MapFrontiersClient.setFrontiersFromServer(message.globalFrontiers, message.personalFrontiers);
        }
    }
}

