/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class PacketPersonalFrontier {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_personal_frontier");
    private final FrontierData frontier;

    public PacketPersonalFrontier() {
        this.frontier = new FrontierData();
    }

    public PacketPersonalFrontier(FrontierData frontier) {
        this.frontier = frontier;
    }

    public static PacketPersonalFrontier decode(FriendlyByteBuf buf) {
        PacketPersonalFrontier packet = new PacketPersonalFrontier();
        packet.frontier.fromBytes(buf);
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        this.frontier.toBytes(buf, false);
    }

    public static void handle(PacketContext<PacketPersonalFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketPersonalFrontier message = (PacketPersonalFrontier)ctx.message();
            ServerPlayer player = ctx.sender();
            if (player == null) {
                return;
            }
            SettingsUser playerUser = new SettingsUser((Player)player);
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontier.getId());
            if (currentFrontier == null && message.frontier.getPersonal() && message.frontier.getOwner().equals(playerUser)) {
                message.frontier.removeAllUserShared();
                message.frontier.removeChange(FrontierData.Change.Shared);
                FrontiersManager.instance.addPersonalFrontier(message.frontier);
            }
        }
    }
}

