/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class PacketPersonalFrontierShared {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mapfrontiers", "packet_personal_frontier_shared");
    private int shareMessageID;
    private final SettingsUser playerSharing;
    private final SettingsUser owner;
    private String name1;
    private String name2;

    public PacketPersonalFrontierShared() {
        this.shareMessageID = -1;
        this.playerSharing = new SettingsUser();
        this.owner = new SettingsUser();
        this.name1 = "";
        this.name2 = "";
    }

    public PacketPersonalFrontierShared(int shareMessageID, SettingsUser playerSharing, SettingsUser owner, String name1, String name2) {
        this.shareMessageID = shareMessageID;
        this.playerSharing = playerSharing;
        this.owner = owner;
        this.name1 = name1;
        this.name2 = name2;
    }

    public static PacketPersonalFrontierShared decode(FriendlyByteBuf buf) {
        PacketPersonalFrontierShared packet = new PacketPersonalFrontierShared();
        packet.shareMessageID = buf.readInt();
        packet.playerSharing.fromBytes(buf);
        packet.owner.fromBytes(buf);
        packet.name1 = buf.m_130136_(17);
        packet.name2 = buf.m_130136_(17);
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.shareMessageID);
        this.playerSharing.toBytes(buf);
        this.owner.toBytes(buf);
        buf.m_130070_(this.name1);
        buf.m_130070_(this.name2);
    }

    public static void handle(PacketContext<PacketPersonalFrontierShared> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            PacketPersonalFrontierShared message = (PacketPersonalFrontierShared)ctx.message();
            Object frontierName = message.name1.isEmpty() && message.name2.isEmpty() ? "Unnamed Frontier" : (message.name1.isEmpty() ? message.name2 : (message.name2.isEmpty() ? message.name1 : message.name1 + " " + message.name2));
            MutableComponent button = Component.m_237113_((String)frontierName);
            button.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to accept or use command /mfaccept " + message.shareMessageID)))));
            button.m_130938_(style -> style.m_131136_(Boolean.valueOf(true)));
            button.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mapfrontiersaccept " + message.shareMessageID)));
            MutableComponent text = Component.m_237113_((String)(PacketPersonalFrontierShared.userToString(message.playerSharing) + " "));
            if (message.playerSharing.equals(message.owner)) {
                text.m_130946_("want to share a frontier with you: ");
            } else {
                text.m_130946_("want to share a frontier from " + PacketPersonalFrontierShared.userToString(message.owner) + " with you: ");
            }
            text.m_7220_((Component)button);
            player.m_213846_((Component)text);
        }
    }

    private static String userToString(SettingsUser user) {
        String string = !StringUtils.isBlank((CharSequence)user.username) ? user.username : (user.uuid != null ? user.uuid.toString() : "User not found");
        return string;
    }
}

