/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class ColorPaletteWidget
extends AbstractWidgetNoNarration {
    private static final int[] palette = new int[]{-65536, Short.MIN_VALUE, -256, -8323328, -16711936, -16711808, -16711681, -16744193, -16776961, -8388353, -65281, -65408, -11063545, -16777216, -12566464, -8355712, -4210753, -1};
    private static final int[] paletteInactive = new int[]{-13355980, -10921639, -8487298, -9737365, -10987432, -10526881, -10066330, -12434878, -14935012, -13684945, -12434878, -12895429, -14079703, -15856114, -13750738, -11711155, -9605779, -7500403};
    private int color;
    private final Consumer<Integer> onPress;

    public ColorPaletteWidget(int color, Consumer<Integer> onPress) {
        super(0, 0, 139, 70, (Component)Component.empty());
        this.color = color;
        this.onPress = onPress;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigationEvent) {
        return null;
    }

    public void onClick(double mouseX, double mouseY) {
        double paletteX = (mouseX - (double)this.getX()) / 23.0;
        double paletteY = (mouseY - (double)this.getY()) / 23.0;
        if (paletteX >= 0.0 && paletteX < 6.0 && paletteY >= 0.0 && paletteY < 3.0) {
            this.color = palette[(int)paletteX + (int)paletteY * 6];
            this.onPress.accept(this.color);
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -16777216);
        int col = 0;
        int row = 0;
        for (int c : this.active ? palette : paletteInactive) {
            if (this.active && c == this.color) {
                graphics.fill(this.getX() + col * 23, this.getY() + row * 23, this.getX() + 23 + col * 23, this.getY() + 23 + row * 23, -1);
            }
            graphics.fill(this.getX() + 1 + col * 23, this.getY() + 1 + row * 23, this.getX() + 22 + col * 23, this.getY() + 22 + row * 23, c);
            if (++col != 6) continue;
            col = 0;
            ++row;
        }
    }
}

