/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.dialog;

import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.PreviewFrontiersWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxDouble;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class FrontierAppearanceDialog
extends AutoScaledScreen {
    private static final Component hideNamesThatDontFitLabel = Config.getTranslatedName("hideNamesThatDontFit");
    private static final Tooltip hideNamesThatDontFitTooltip = Config.getTooltip("hideNamesThatDontFit");
    private static final Component polygonsOpacityLabel = Config.getTranslatedName("polygonsOpacity");
    private static final Tooltip polygonsOpacityTooltip = Config.getTooltip("polygonsOpacity");
    private static final Component borderWidthLabel = Config.getTranslatedName("borderWidth");
    private static final Tooltip borderWidthTooltip = Config.getTooltip("borderWidth");
    private static final Component borderOpacityLabel = Config.getTranslatedName("borderOpacity");
    private static final Tooltip borderOpacityTooltip = Config.getTooltip("borderOpacity");
    private static final Component textSizeLabel = Config.getTranslatedName("textSize");
    private static final Tooltip textSizeTooltip = Config.getTooltip("textSize");
    private static final Component textOpacityLabel = Config.getTranslatedName("textOpacity");
    private static final Tooltip textOpacityTooltip = Config.getTooltip("textOpacity");
    private static final Component textColorLabel = Config.getTranslatedName("textColor");
    private static final Tooltip textColorTooltip = Config.getTooltip("textColor");
    private static final Component bannerSizeLabel = Config.getTranslatedName("bannerSize");
    private static final Tooltip bannerSizeTooltip = Config.getTooltip("bannerSize");
    private static final Component bannerOpacityLabel = Config.getTranslatedName("bannerOpacity");
    private static final Tooltip bannerOpacityTooltip = Config.getTooltip("bannerOpacity");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private static final Component onLabel = Component.translatable((String)"options.on");
    private static final Component offLabel = Component.translatable((String)"options.off");
    private StringWidget labelHideNamesThatDontFit;
    private StringWidget labelPolygonsOpacity;
    private StringWidget labelBorderWidth;
    private StringWidget labelBorderOpacity;
    private StringWidget labelTextSize;
    private StringWidget labelTextOpacity;
    private StringWidget labelTextUsesCustomColor;
    private StringWidget labelBannerSize;
    private StringWidget labelBannerOpacity;
    private OptionButton buttonHideNamesThatDontFit;
    private TextBoxDouble textPolygonsOpacity;
    private TextBoxInt textBorderWidth;
    private TextBoxDouble textBorderOpacity;
    private TextBoxInt textTextSize;
    private TextBoxDouble textTextOpacity;
    private OptionButton buttonTextUsesCustomColor;
    private TextBoxInt textBannerSize;
    private TextBoxDouble textBannerOpacity;
    private PreviewFrontiersWidget previewFrontiers;
    private SimpleButton doneButton;

    public FrontierAppearanceDialog() {
        super((Component)Component.empty(), 455, 255);
    }

    @Override
    protected void initScreen() {
        LinearLayout mainLayout = LinearLayout.vertical().spacing(8);
        mainLayout.defaultCellSetting().alignHorizontallyCenter();
        this.content.addChild((LayoutElement)mainLayout);
        LinearLayout columnsLayout = LinearLayout.horizontal().spacing(8);
        mainLayout.addChild((LayoutElement)columnsLayout);
        GridLayout settingsLayout = new GridLayout().spacing(4);
        settingsLayout.defaultCellSetting().alignHorizontallyLeft();
        columnsLayout.addChild((LayoutElement)settingsLayout);
        int row = 0;
        this.labelHideNamesThatDontFit = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(hideNamesThatDontFitLabel, this.font).setColor(-4144960), row, 0);
        this.labelHideNamesThatDontFit.setTooltip(hideNamesThatDontFitTooltip);
        this.buttonHideNamesThatDontFit = (OptionButton)settingsLayout.addChild((LayoutElement)new OptionButton(this.font, 60, b -> {
            Config.hideNamesThatDontFit = b.getSelected() == 0;
            this.previewFrontiers.configUpdated();
        }), row++, 1);
        this.buttonHideNamesThatDontFit.addOption(onLabel);
        this.buttonHideNamesThatDontFit.addOption(offLabel);
        this.buttonHideNamesThatDontFit.setSelected(Config.hideNamesThatDontFit ? 0 : 1);
        this.labelPolygonsOpacity = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(polygonsOpacityLabel, this.font).setColor(-4144960), row, 0);
        this.labelPolygonsOpacity.setTooltip(polygonsOpacityTooltip);
        this.textPolygonsOpacity = (TextBoxDouble)settingsLayout.addChild((LayoutElement)new TextBoxDouble(0.4, 0.0, 1.0, this.font, 60), row++, 1);
        this.textPolygonsOpacity.setValue(String.valueOf(Config.polygonsOpacity));
        this.textPolygonsOpacity.setMaxLength(6);
        this.textPolygonsOpacity.setValueChangedCallback(value -> {
            Config.polygonsOpacity = value;
            this.previewFrontiers.configUpdated();
        });
        this.labelBorderWidth = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(borderWidthLabel, this.font).setColor(-4144960), row, 0);
        this.labelBorderWidth.setTooltip(borderWidthTooltip);
        this.textBorderWidth = (TextBoxInt)settingsLayout.addChild((LayoutElement)new TextBoxInt(0, 0, 64, this.font, 60), row++, 1);
        this.textBorderWidth.setValue(String.valueOf(Config.borderWidth));
        this.textBorderWidth.setMaxLength(2);
        this.textBorderWidth.setValueChangedCallback(value -> {
            Config.borderWidth = value;
            this.previewFrontiers.configUpdated();
        });
        this.labelBorderOpacity = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(borderOpacityLabel, this.font).setColor(-4144960), row, 0);
        this.labelBorderOpacity.setTooltip(borderOpacityTooltip);
        this.textBorderOpacity = (TextBoxDouble)settingsLayout.addChild((LayoutElement)new TextBoxDouble(1.0, 0.0, 1.0, this.font, 60), row++, 1);
        this.textBorderOpacity.setValue(String.valueOf(Config.borderOpacity));
        this.textBorderOpacity.setMaxLength(6);
        this.textBorderOpacity.setValueChangedCallback(value -> {
            Config.borderOpacity = value;
            this.previewFrontiers.configUpdated();
        });
        this.labelTextSize = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(textSizeLabel, this.font).setColor(-4144960), row, 0);
        this.labelTextSize.setTooltip(textSizeTooltip);
        this.textTextSize = (TextBoxInt)settingsLayout.addChild((LayoutElement)new TextBoxInt(2, 1, 5, this.font, 60), row++, 1);
        this.textTextSize.setValue(String.valueOf(Config.textSize));
        this.textTextSize.setMaxLength(2);
        this.textTextSize.setValueChangedCallback(value -> {
            Config.textSize = value;
            this.previewFrontiers.configUpdated();
        });
        this.labelTextOpacity = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(textOpacityLabel, this.font).setColor(-4144960), row, 0);
        this.labelTextOpacity.setTooltip(textOpacityTooltip);
        this.textTextOpacity = (TextBoxDouble)settingsLayout.addChild((LayoutElement)new TextBoxDouble(1.0, 0.0, 1.0, this.font, 60), row++, 1);
        this.textTextOpacity.setValue(String.valueOf(Config.textOpacity));
        this.textTextOpacity.setMaxLength(6);
        this.textTextOpacity.setValueChangedCallback(value -> {
            Config.textOpacity = value;
            this.previewFrontiers.configUpdated();
        });
        this.labelTextUsesCustomColor = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(textColorLabel, this.font).setColor(-4144960), row, 0);
        this.labelTextUsesCustomColor.setTooltip(textColorTooltip);
        this.buttonTextUsesCustomColor = (OptionButton)settingsLayout.addChild((LayoutElement)new OptionButton(this.font, 60, b -> {
            Config.textColor = Config.TextColor.values()[b.getSelected()];
            this.previewFrontiers.configUpdated();
        }), row++, 1);
        this.buttonTextUsesCustomColor.addOption(Config.getTranslatedEnum(Config.TextColor.Frontier));
        this.buttonTextUsesCustomColor.addOption(Config.getTranslatedEnum(Config.TextColor.Bright));
        this.buttonTextUsesCustomColor.addOption(Config.getTranslatedEnum(Config.TextColor.White));
        this.buttonTextUsesCustomColor.setSelected(Config.textColor.ordinal());
        this.labelBannerSize = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(bannerSizeLabel, this.font).setColor(-4144960), row, 0);
        this.labelBannerSize.setTooltip(bannerSizeTooltip);
        this.textBannerSize = (TextBoxInt)settingsLayout.addChild((LayoutElement)new TextBoxInt(2, 1, 5, this.font, 60), row++, 1);
        this.textBannerSize.setValue(String.valueOf(Config.bannerSize));
        this.textBannerSize.setMaxLength(2);
        this.textBannerSize.setValueChangedCallback(value -> {
            Config.bannerSize = value;
            this.previewFrontiers.configUpdated();
        });
        this.labelBannerOpacity = (StringWidget)settingsLayout.addChild((LayoutElement)new StringWidget(bannerOpacityLabel, this.font).setColor(-4144960), row, 0);
        this.labelBannerOpacity.setTooltip(bannerOpacityTooltip);
        this.textBannerOpacity = (TextBoxDouble)settingsLayout.addChild((LayoutElement)new TextBoxDouble(1.0, 0.0, 1.0, this.font, 60), row++, 1);
        this.textBannerOpacity.setValue(String.valueOf(Config.bannerOpacity));
        this.textBannerOpacity.setMaxLength(6);
        this.textBannerOpacity.setValueChangedCallback(value -> {
            Config.bannerOpacity = value;
            this.previewFrontiers.configUpdated();
        });
        this.previewFrontiers = (PreviewFrontiersWidget)columnsLayout.addChild((LayoutElement)new PreviewFrontiersWidget());
        this.doneButton = (SimpleButton)mainLayout.addChild((LayoutElement)new SimpleButton(this.font, 100, doneLabel, b -> this.onClose()));
    }

    @Override
    public void repositionElements() {
        this.previewFrontiers.setScaleFactor(this.scaleFactor);
        super.repositionElements();
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.getWidth() + 20, this.content.getHeight() + 20);
    }

    public void onClose() {
        ClientEventHandler.postUpdatedConfigEvent();
        super.onClose();
    }
}

