/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.dialog;

import games.alejandrocoria.mapfrontiers.client.ChatFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import javax.annotation.Nullable;
import net.minecraft.class_310;

public class AcceptFrontierCopyDialog
extends ConfirmationDialog {
    private static final String titleKey = "mapfrontiers.receive_frontier_copy";
    private static final String descKey = "mapfrontiers.accept_frontier_desc";
    private static final String descReplaceKey = "mapfrontiers.accept_frontier_desc_replace";
    private static final String confirmKey = "mapfrontiers.accept_frontier";
    private static final String confirmReplaceKey = "mapfrontiers.replace";
    private static final String confirmNoReplaceKey = "mapfrontiers.accept_frontier_as_new";
    private static final String cancelKey = "gui.cancel";

    public AcceptFrontierCopyDialog(int id, FrontierData receivedFrontier, @Nullable FrontierOverlay currentFrontier) {
        super(titleKey, currentFrontier == null ? descKey : descReplaceKey, currentFrontier == null ? confirmKey : confirmReplaceKey, cancelKey, currentFrontier == null ? null : confirmNoReplaceKey, response -> {
            if (response == ConfirmationDialog.Response.Confirm && currentFrontier == null) {
                AcceptFrontierCopyDialog.acceptFrontier(id, receivedFrontier, null);
            } else if (response == ConfirmationDialog.Response.Confirm) {
                AcceptFrontierCopyDialog.acceptFrontierAndReplace(id, receivedFrontier, currentFrontier);
            } else {
                AcceptFrontierCopyDialog.acceptFrontier(id, receivedFrontier, currentFrontier);
            }
        });
    }

    @Override
    protected void initScreen() {
        super.initScreen();
        if (this.confirmAlternativeButton != null) {
            this.confirmButton.setTextColors(-34953, -65536);
        }
    }

    private static void acceptFrontier(int id, FrontierData receivedFrontier, @Nullable FrontierOverlay currentFrontier) {
        if (currentFrontier != null) {
            currentFrontier.removeCopiedFromInfo();
            ClientEventHandler.postUpdatedFrontierEvent(currentFrontier, class_310.method_1551().field_1724.method_5628());
        }
        FrontierOverlay frontierOverlay = MapFrontiersClient.getFrontiersOverlayManager(true).addFrontier(receivedFrontier);
        ClientEventHandler.postNewFrontierEvent(frontierOverlay, class_310.method_1551().field_1724.method_5628());
        ChatFrontiers.removeReceivedId(id);
    }

    private static void acceptFrontierAndReplace(int id, FrontierData receivedFrontier, FrontierOverlay currentFrontier) {
        MapFrontiersClient.getFrontiersOverlayManager(currentFrontier.getPersonal()).deleteFrontier(currentFrontier.getDimension(), currentFrontier.getId());
        ClientEventHandler.postDeletedFrontierEvent(currentFrontier.getId());
        FrontierOverlay frontierOverlay = MapFrontiersClient.getFrontiersOverlayManager(true).addFrontier(receivedFrontier);
        ClientEventHandler.postNewFrontierEvent(frontierOverlay, class_310.method_1551().field_1724.method_5628());
        ChatFrontiers.removeReceivedId(id);
    }
}

