/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierCreated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketChangeFrontierToGlobal {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_change_frontier_to_global");
    public static final class_9139<class_9129, PacketChangeFrontierToGlobal> STREAM_CODEC = class_9139.method_56438(PacketChangeFrontierToGlobal::encode, PacketChangeFrontierToGlobal::new);
    private UUID frontierID;
    private Date modified;

    public PacketChangeFrontierToGlobal(UUID frontierID, @Nullable Date modified) {
        this.frontierID = frontierID;
        this.modified = modified;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketChangeFrontierToGlobal(class_2540 buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
                if (buf.readBoolean()) {
                    this.modified = new Date(buf.readLong());
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketChangeFrontierToGlobal: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
            if (this.modified == null) {
                buf.method_52964(false);
            } else {
                buf.method_52964(true);
                buf.method_52974(this.modified.getTime());
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketChangeFrontierToGlobal: %s", t));
        }
    }

    public static void handle(PacketContext<PacketChangeFrontierToGlobal> ctx) {
        PacketChangeFrontierToGlobal message = (PacketChangeFrontierToGlobal)ctx.message();
        if (Side.SERVER.equals((Object)ctx.side())) {
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.field_13995;
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            FrontierData frontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (frontier != null) {
                if (frontier.getPersonal() && frontier.getOwner().equals(playerUser)) {
                    boolean changed;
                    ArrayList<class_3222> relevantPlayers = new ArrayList<class_3222>();
                    relevantPlayers.add(player);
                    if (frontier.getUsersShared() != null) {
                        for (SettingsUserShared userShared : frontier.getUsersShared()) {
                            class_3222 otherPlayer;
                            if (userShared.isPending() || (otherPlayer = server.method_3760().method_14602(userShared.getUser().uuid)) == null) continue;
                            relevantPlayers.add(otherPlayer);
                        }
                    }
                    if (changed = FrontiersManager.instance.changePersonalFrontierToGlobal(frontier.getOwner(), frontier.getDimension(), frontier.getId())) {
                        PacketHandler.sendTo(new PacketChangeFrontierToGlobal(frontier.getId(), frontier.getModified()), relevantPlayers);
                        PacketHandler.sendToAllExcept(new PacketFrontierCreated(frontier, player.method_5628()), server, relevantPlayers);
                    }
                    return;
                }
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        } else {
            FrontiersOverlayManager personalManager = MapFrontiersClient.getFrontiersOverlayManager(true);
            FrontierOverlay frontierOverlay = personalManager.deleteFrontier(message.frontierID);
            frontierOverlay.setPersonal(false);
            if (message.modified != null) {
                frontierOverlay.setModified(message.modified);
            }
            frontierOverlay.removeAllUserShared();
            frontierOverlay.removeChanges();
            frontierOverlay.recreateBannerRenderer();
            MapFrontiersClient.getFrontiersOverlayManager(false).addFrontier(frontierOverlay);
            ClientEventHandler.postUpdatedFrontierEvent(frontierOverlay, -1);
            frontierOverlay.updateOverlay();
        }
    }
}

