/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierDeleted;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketChangeFrontierToPersonal {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_change_frontier_to_personal");
    public static final class_9139<class_9129, PacketChangeFrontierToPersonal> STREAM_CODEC = class_9139.method_56438(PacketChangeFrontierToPersonal::encode, PacketChangeFrontierToPersonal::new);
    private UUID frontierID;
    private Date modified;

    public PacketChangeFrontierToPersonal(UUID frontierID, @Nullable Date modified) {
        this.frontierID = frontierID;
        this.modified = modified;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketChangeFrontierToPersonal(class_2540 buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
                if (buf.readBoolean()) {
                    this.modified = new Date(buf.readLong());
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketChangeFrontierToPersonal: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
            if (this.modified == null) {
                buf.method_52964(false);
            } else {
                buf.method_52964(true);
                buf.method_52974(this.modified.getTime());
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketChangeFrontierToPersonal: %s", t));
        }
    }

    public static void handle(PacketContext<PacketChangeFrontierToPersonal> ctx) {
        PacketChangeFrontierToPersonal message = (PacketChangeFrontierToPersonal)ctx.message();
        if (Side.SERVER.equals((Object)ctx.side())) {
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.field_13995;
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            FrontierData frontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (frontier != null) {
                if (!frontier.getPersonal()) {
                    boolean changed;
                    if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.DeleteGlobalFrontier, playerUser, MapFrontiers.isOPorHost(player), frontier.getOwner()) && (changed = FrontiersManager.instance.changeGlobalFrontierToPersonal(frontier.getOwner(), frontier.getDimension(), frontier.getId()))) {
                        PacketHandler.sendTo(new PacketChangeFrontierToPersonal(frontier.getId(), frontier.getModified()), player);
                        PacketHandler.sendToAllExcept(new PacketFrontierDeleted(frontier.getDimension(), frontier.getId(), false, player.method_5628()), server, player);
                    }
                    return;
                }
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        } else {
            FrontiersOverlayManager globalManager = MapFrontiersClient.getFrontiersOverlayManager(false);
            FrontierOverlay frontierOverlay = globalManager.deleteFrontier(message.frontierID);
            frontierOverlay.setPersonal(true);
            if (message.modified != null) {
                frontierOverlay.setModified(message.modified);
            }
            frontierOverlay.setCurrentPlayerAsOwner();
            frontierOverlay.recreateBannerRenderer();
            MapFrontiersClient.getFrontiersOverlayManager(true).addFrontier(frontierOverlay);
            ClientEventHandler.postUpdatedFrontierEvent(frontierOverlay, -1);
            frontierOverlay.updateOverlay();
        }
    }
}

