/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@ParametersAreNonnullByDefault
public class PacketFrontierCreated {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_frontier_created");
    public static final class_9139<class_9129, PacketFrontierCreated> STREAM_CODEC = class_9139.method_56438(PacketFrontierCreated::encode, PacketFrontierCreated::new);
    private final FrontierData frontier;
    private int playerID = -1;

    public PacketFrontierCreated(FrontierData frontier) {
        this.frontier = frontier;
    }

    public PacketFrontierCreated(FrontierData frontier, int playerID) {
        this.frontier = frontier;
        this.playerID = playerID;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketFrontierCreated(class_2540 buf) {
        this.frontier = new FrontierData();
        try {
            if (buf.readableBytes() > 1) {
                this.frontier.fromBytes(buf);
                this.playerID = buf.readInt();
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketFrontierCreated: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            this.frontier.toBytes(buf, false);
            buf.method_53002(this.playerID);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketFrontierCreated: %s", t));
        }
    }

    public static void handle(PacketContext<PacketFrontierCreated> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketFrontierCreated message = (PacketFrontierCreated)ctx.message();
            FrontierOverlay frontierOverlay = MapFrontiersClient.getFrontiersOverlayManager(message.frontier.getPersonal()).addFrontier(message.frontier);
            if (frontierOverlay != null) {
                ClientEventHandler.postNewFrontierEvent(frontierOverlay, message.playerID);
            }
        }
    }
}

